/*
 * Decompiled with CFR 0.152.
 */
package arc;

import arc.func.Cons;
import arc.struct.IntMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.NetJavaImpl;
import java.io.InputStream;

public class Net {
    private NetJavaImpl impl = new NetJavaImpl();

    public void setBlock(boolean block) {
        this.impl.setBlock(block);
    }

    public void http(HttpRequest httpRequest, Cons<HttpResponse> success, Cons<Throwable> failure) {
        this.impl.http(httpRequest, success, failure);
    }

    public void httpGet(String url, Cons<HttpResponse> success, Cons<Throwable> failure) {
        this.http(new HttpRequest().method(HttpMethod.GET).url(url), success, failure);
    }

    public void httpPost(String url, String content, Cons<HttpResponse> success, Cons<Throwable> failure) {
        this.http(new HttpRequest().method(HttpMethod.POST).content(content).url(url), success, failure);
    }

    public static class HttpRequest {
        public HttpMethod method;
        public String url;
        public ObjectMap<String, String> headers = new ObjectMap();
        public int timeout = 2000;
        public String content;
        public InputStream contentStream;
        public long contentLength;
        public boolean followRedirects = true;
        public boolean includeCredentials = false;

        public HttpRequest() {
        }

        public HttpRequest(HttpMethod method) {
            this.method = method;
        }

        public HttpRequest method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public HttpRequest url(String url) {
            this.url = url;
            return this;
        }

        public HttpRequest timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public HttpRequest redirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public HttpRequest credentials(boolean includeCredentials) {
            this.includeCredentials = includeCredentials;
            return this;
        }

        public HttpRequest header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public HttpRequest content(String content) {
            this.content = content;
            return this;
        }

        public HttpRequest content(InputStream contentStream, long contentLength) {
            this.contentStream = contentStream;
            this.contentLength = contentLength;
            return this;
        }
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        CONNECT,
        OPTIONS,
        TRACE;

    }

    public static enum HttpStatus {
        UNKNOWN_STATUS(-1),
        CONTINUE(100),
        SWITCHING_PROTOCOLS(101),
        PROCESSING(102),
        OK(200),
        CREATED(201),
        ACCEPTED(202),
        NON_AUTHORITATIVE_INFORMATION(203),
        NO_CONTENT(204),
        RESET_CONTENT(205),
        PARTIAL_CONTENT(206),
        MULTI_STATUS(207),
        MULTIPLE_CHOICES(300),
        MOVED_PERMANENTLY(301),
        MOVED_TEMPORARILY(302),
        SEE_OTHER(303),
        NOT_MODIFIED(304),
        USE_PROXY(305),
        TEMPORARY_REDIRECT(307),
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        PAYMENT_REQUIRED(402),
        FORBIDDEN(403),
        NOT_FOUND(404),
        METHOD_NOT_ALLOWED(405),
        NOT_ACCEPTABLE(406),
        PROXY_AUTHENTICATION_REQUIRED(407),
        REQUEST_TIMEOUT(408),
        CONFLICT(409),
        GONE(410),
        LENGTH_REQUIRED(411),
        PRECONDITION_FAILED(412),
        REQUEST_TOO_LONG(413),
        REQUEST_URI_TOO_LONG(414),
        UNSUPPORTED_MEDIA_TYPE(415),
        REQUESTED_RANGE_NOT_SATISFIABLE(416),
        EXPECTATION_FAILED(417),
        INSUFFICIENT_SPACE_ON_RESOURCE(419),
        METHOD_FAILURE(420),
        UNPROCESSABLE_ENTITY(422),
        LOCKED(423),
        FAILED_DEPENDENCY(424),
        INTERNAL_SERVER_ERROR(500),
        NOT_IMPLEMENTED(501),
        BAD_GATEWAY(502),
        SERVICE_UNAVAILABLE(503),
        GATEWAY_TIMEOUT(504),
        HTTP_VERSION_NOT_SUPPORTED(505),
        INSUFFICIENT_STORAGE(507);

        private static IntMap<HttpStatus> byCode;
        public final int code;

        private HttpStatus(int code) {
            this.code = code;
        }

        public static HttpStatus byCode(int code) {
            if (byCode == null) {
                byCode = new IntMap();
                for (HttpStatus status : HttpStatus.values()) {
                    byCode.put(status.code, status);
                }
            }
            return byCode.get(code, UNKNOWN_STATUS);
        }
    }

    public static interface HttpResponse {
        public byte[] getResult();

        public String getResultAsString();

        public InputStream getResultAsStream();

        public HttpStatus getStatus();

        public String getHeader(String var1);

        public ObjectMap<String, Seq<String>> getHeaders();
    }
}

