/*
 * Decompiled with CFR 0.152.
 */
package arc.assets;

import arc.assets.AssetDescriptor;
import arc.assets.AssetErrorListener;
import arc.assets.AssetLoaderParameters;
import arc.assets.AssetLoadingTask;
import arc.assets.Loadable;
import arc.assets.RefCountedContainer;
import arc.assets.loaders.AssetLoader;
import arc.assets.loaders.AsynchronousAssetLoader;
import arc.assets.loaders.CubemapLoader;
import arc.assets.loaders.CustomLoader;
import arc.assets.loaders.FileHandleResolver;
import arc.assets.loaders.FontLoader;
import arc.assets.loaders.I18NBundleLoader;
import arc.assets.loaders.MusicLoader;
import arc.assets.loaders.PixmapLoader;
import arc.assets.loaders.ShaderProgramLoader;
import arc.assets.loaders.SoundLoader;
import arc.assets.loaders.TextureAtlasLoader;
import arc.assets.loaders.TextureLoader;
import arc.assets.loaders.resolvers.InternalFileHandleResolver;
import arc.audio.Music;
import arc.audio.Sound;
import arc.files.Fi;
import arc.graphics.Cubemap;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.gl.Shader;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Disposable;
import arc.util.I18NBundle;
import arc.util.Time;
import arc.util.async.AsyncExecutor;
import arc.util.async.Threads;
import java.util.Stack;

public class AssetManager
implements Disposable {
    final ObjectMap<Class, ObjectMap<String, RefCountedContainer>> assets = new ObjectMap();
    final ObjectMap<String, Class> assetTypes = new ObjectMap();
    final ObjectMap<String, Seq<String>> assetDependencies = new ObjectMap();
    final ObjectSet<String> injected = new ObjectSet();
    final ObjectMap<Class, ObjectMap<String, AssetLoader>> loaders = new ObjectMap();
    final Seq<AssetDescriptor> loadQueue = new Seq();
    final AsyncExecutor executor;
    final Stack<AssetLoadingTask> tasks = new Stack();
    final FileHandleResolver resolver;
    AssetErrorListener listener = null;
    int loaded = 0;
    int toLoad = 0;
    int peakTasks = 0;

    public AssetManager() {
        this(new InternalFileHandleResolver());
    }

    public AssetManager(FileHandleResolver resolver) {
        this(resolver, true);
    }

    public AssetManager(FileHandleResolver resolver, boolean defaultLoaders) {
        this.resolver = resolver;
        if (defaultLoaders) {
            this.setLoader(Font.class, new FontLoader(resolver));
            this.setLoader(Music.class, new MusicLoader(resolver));
            this.setLoader(Pixmap.class, new PixmapLoader(resolver));
            this.setLoader(Sound.class, new SoundLoader(resolver));
            this.setLoader(TextureAtlas.class, new TextureAtlasLoader(resolver));
            this.setLoader(Texture.class, new TextureLoader(resolver));
            this.setLoader(I18NBundle.class, new I18NBundleLoader(resolver));
            this.setLoader(Shader.class, new ShaderProgramLoader(resolver));
            this.setLoader(Cubemap.class, new CubemapLoader(resolver));
        }
        this.executor = new AsyncExecutor(1);
    }

    public FileHandleResolver getFileHandleResolver() {
        return this.resolver;
    }

    public synchronized <T> T get(String fileName) {
        Class type = this.assetTypes.get(fileName);
        if (type == null) {
            throw new ArcRuntimeException("Asset not loaded: " + fileName);
        }
        ObjectMap<String, RefCountedContainer> assetsByType = this.assets.get(type);
        if (assetsByType == null) {
            throw new ArcRuntimeException("Asset not loaded: " + fileName);
        }
        RefCountedContainer assetContainer = assetsByType.get(fileName);
        if (assetContainer == null) {
            throw new ArcRuntimeException("Asset not loaded: " + fileName);
        }
        Object asset = assetContainer.getObject(type);
        if (asset == null) {
            throw new ArcRuntimeException("Asset not loaded: " + fileName);
        }
        return asset;
    }

    public synchronized <T> T get(String fileName, Class<T> type) {
        ObjectMap<String, RefCountedContainer> assetsByType = this.assets.get(type);
        if (assetsByType == null) {
            throw new ArcRuntimeException("Asset not loaded: " + fileName);
        }
        RefCountedContainer assetContainer = assetsByType.get(fileName);
        if (assetContainer == null) {
            throw new ArcRuntimeException("Asset not loaded: " + fileName);
        }
        T asset = assetContainer.getObject(type);
        if (asset == null) {
            throw new ArcRuntimeException("Asset not loaded: " + fileName);
        }
        return asset;
    }

    public synchronized <T> Seq<T> getAll(Class<T> type, Seq<T> out) {
        ObjectMap<String, RefCountedContainer> assetsByType = this.assets.get(type);
        if (assetsByType != null) {
            for (ObjectMap.Entry entry : assetsByType.entries()) {
                out.add(((RefCountedContainer)entry.value).getObject(type));
            }
        }
        return out;
    }

    public synchronized <T> T get(AssetDescriptor<T> assetDescriptor) {
        return this.get(assetDescriptor.fileName, assetDescriptor.type);
    }

    public synchronized boolean contains(String fileName) {
        if (this.tasks.size() > 0 && ((AssetLoadingTask)this.tasks.firstElement()).assetDesc.fileName.equals(fileName)) {
            return true;
        }
        for (int i = 0; i < this.loadQueue.size; ++i) {
            if (!this.loadQueue.get((int)i).fileName.equals(fileName)) continue;
            return true;
        }
        return this.isLoaded(fileName);
    }

    public synchronized boolean contains(String fileName, Class type) {
        if (this.tasks.size() > 0) {
            AssetDescriptor assetDesc = ((AssetLoadingTask)this.tasks.firstElement()).assetDesc;
            if (assetDesc.type == type && assetDesc.fileName.equals(fileName)) {
                return true;
            }
        }
        for (int i = 0; i < this.loadQueue.size; ++i) {
            AssetDescriptor assetDesc = this.loadQueue.get(i);
            if (assetDesc.type != type || !assetDesc.fileName.equals(fileName)) continue;
            return true;
        }
        return this.isLoaded(fileName, type);
    }

    public synchronized void unload(String fileName) {
        Seq<String> dependencies;
        if (this.tasks.size() > 0) {
            AssetLoadingTask currAsset = (AssetLoadingTask)this.tasks.firstElement();
            if (currAsset.assetDesc.fileName.equals(fileName)) {
                currAsset.cancel = true;
                return;
            }
        }
        int foundIndex = -1;
        for (int i = 0; i < this.loadQueue.size; ++i) {
            if (!this.loadQueue.get((int)i).fileName.equals(fileName)) continue;
            foundIndex = i;
            break;
        }
        if (foundIndex != -1) {
            --this.toLoad;
            this.loadQueue.remove(foundIndex);
            return;
        }
        Class type = this.assetTypes.get(fileName);
        if (type == null) {
            throw new ArcRuntimeException("Asset not loaded: " + fileName);
        }
        RefCountedContainer assetRef = this.assets.get(type).get(fileName);
        assetRef.decRefCount();
        if (assetRef.getRefCount() <= 0) {
            if (assetRef.getObject(Object.class) instanceof Disposable) {
                ((Disposable)assetRef.getObject(Object.class)).dispose();
            }
            this.assetTypes.remove(fileName);
            this.assets.get(type).remove(fileName);
        }
        if ((dependencies = this.assetDependencies.get(fileName)) != null) {
            for (String dependency : dependencies) {
                if (!this.isLoaded(dependency)) continue;
                this.unload(dependency);
            }
        }
        if (assetRef.getRefCount() <= 0) {
            this.assetDependencies.remove(fileName);
        }
    }

    public synchronized <T> boolean containsAsset(T asset) {
        ObjectMap<String, RefCountedContainer> assetsByType = this.assets.get(asset.getClass());
        if (assetsByType == null) {
            return false;
        }
        for (String fileName : assetsByType.keys()) {
            Object otherAsset = assetsByType.get(fileName).getObject(Object.class);
            if (otherAsset != asset && !asset.equals(otherAsset)) continue;
            return true;
        }
        return false;
    }

    public synchronized <T> String getAssetFileName(T asset) {
        for (Class assetType : this.assets.keys()) {
            ObjectMap<String, RefCountedContainer> assetsByType = this.assets.get(assetType);
            for (String fileName : assetsByType.keys()) {
                Object otherAsset = assetsByType.get(fileName).getObject(Object.class);
                if (otherAsset != asset && !asset.equals(otherAsset)) continue;
                return fileName;
            }
        }
        return null;
    }

    public synchronized boolean isLoaded(AssetDescriptor assetDesc) {
        return this.isLoaded(assetDesc.fileName);
    }

    public synchronized boolean isLoaded(String fileName) {
        if (fileName == null) {
            return false;
        }
        return this.assetTypes.containsKey(fileName);
    }

    public synchronized boolean isLoaded(String fileName, Class type) {
        ObjectMap<String, RefCountedContainer> assetsByType = this.assets.get(type);
        if (assetsByType == null) {
            return false;
        }
        RefCountedContainer assetContainer = assetsByType.get(fileName);
        if (assetContainer == null) {
            return false;
        }
        return assetContainer.getObject(type) != null;
    }

    public <T> AssetLoader getLoader(Class<T> type) {
        return this.getLoader(type, null);
    }

    public <T> AssetLoader getLoader(Class<T> type, String fileName) {
        ObjectMap<String, AssetLoader> loaders = this.loaders.get(type);
        if (loaders == null || loaders.size < 1) {
            return null;
        }
        if (fileName == null) {
            return loaders.get("");
        }
        AssetLoader result = null;
        int l = -1;
        for (ObjectMap.Entry entry : loaders.entries()) {
            if (((String)entry.key).length() <= l || !fileName.endsWith((String)entry.key)) continue;
            result = (AssetLoader)entry.value;
            l = ((String)entry.key).length();
        }
        return result;
    }

    public synchronized <T> AssetDescriptor load(String fileName, Class<T> type) {
        return this.load(fileName, type, null);
    }

    public synchronized AssetDescriptor loadRun(String name, Class<?> type, Runnable loadasync) {
        return this.loadRun(name, type, loadasync, () -> {});
    }

    public synchronized AssetDescriptor loadRun(String name, Class<?> type, final Runnable loadasync, final Runnable loadsync) {
        if (this.getLoader(type) != null) {
            throw new IllegalArgumentException("Class already registered or loaded: " + type);
        }
        this.setLoader(type, new CustomLoader(){

            public void loadAsync(AssetManager manager, String fileName, Fi file, AssetLoaderParameters parameter) {
                loadasync.run();
            }

            @Override
            public Object loadSync(AssetManager manager, String fileName, Fi file, AssetLoaderParameters parameter) {
                loadsync.run();
                return super.loadSync(manager, fileName, file, parameter);
            }
        });
        return this.load(name, type, null);
    }

    public synchronized AssetDescriptor load(final Loadable load) {
        if (this.getLoader(load.getClass()) == null) {
            this.setLoader(load.getClass(), new AsynchronousAssetLoader(new InternalFileHandleResolver()){

                public void loadAsync(AssetManager manager, String fileName, Fi file, AssetLoaderParameters parameter) {
                    load.loadAsync();
                }

                public Object loadSync(AssetManager manager, String fileName, Fi file, AssetLoaderParameters parameter) {
                    load.loadSync();
                    return load;
                }

                @Override
                public Seq<AssetDescriptor> getDependencies(String fileName, Fi file, AssetLoaderParameters parameter) {
                    return load.getDependencies();
                }
            });
        }
        return this.load(load.getName(), load.getClass(), null);
    }

    public synchronized <T> AssetDescriptor load(String fileName, Class<T> type, AssetLoaderParameters<T> parameter) {
        AssetDescriptor desc;
        int i;
        AssetLoader loader = this.getLoader(type, fileName);
        if (loader == null) {
            throw new ArcRuntimeException("No loader for type: " + type.getSimpleName());
        }
        if (this.loadQueue.size == 0) {
            this.loaded = 0;
            this.toLoad = 0;
            this.peakTasks = 0;
        }
        for (i = 0; i < this.loadQueue.size; ++i) {
            desc = this.loadQueue.get(i);
            if (!desc.fileName.equals(fileName) || desc.type.equals(type)) continue;
            throw new ArcRuntimeException("Asset with name '" + fileName + "' already in preload queue, but has different type (expected: " + type.getSimpleName() + ", found: " + desc.type.getSimpleName() + ")");
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            desc = ((AssetLoadingTask)this.tasks.get((int)i)).assetDesc;
            if (!desc.fileName.equals(fileName) || desc.type.equals(type)) continue;
            throw new ArcRuntimeException("Asset with name '" + fileName + "' already in task list, but has different type (expected: " + type.getSimpleName() + ", found: " + desc.type.getSimpleName() + ")");
        }
        Class otherType = this.assetTypes.get(fileName);
        if (otherType != null && !otherType.equals(type)) {
            throw new ArcRuntimeException("Asset with name '" + fileName + "' already loaded, but has different type (expected: " + type.getSimpleName() + ", found: " + otherType.getSimpleName() + ")");
        }
        ++this.toLoad;
        AssetDescriptor<T> assetDesc = new AssetDescriptor<T>(fileName, type, parameter);
        this.loadQueue.add(assetDesc);
        return assetDesc;
    }

    public synchronized AssetDescriptor load(AssetDescriptor desc) {
        return this.load(desc.fileName, desc.type, desc.params);
    }

    public synchronized boolean update() {
        try {
            if (this.tasks.size() == 0) {
                while (this.loadQueue.size != 0 && this.tasks.size() == 0) {
                    this.nextTask();
                }
                if (this.tasks.size() == 0) {
                    return true;
                }
            }
            return this.updateTask() && this.loadQueue.size == 0 && this.tasks.size() == 0;
        }
        catch (Throwable t) {
            this.handleTaskError(t);
            return this.loadQueue.size == 0;
        }
    }

    public synchronized AssetDescriptor getCurrentLoading() {
        if (this.tasks.size() > 0) {
            return ((AssetLoadingTask)this.tasks.firstElement()).assetDesc;
        }
        return null;
    }

    public boolean update(int millis) {
        long endTime = Time.millis() + (long)millis;
        boolean done;
        while (!(done = this.update()) && Time.millis() <= endTime) {
            Threads.yield();
        }
        return done;
    }

    public synchronized boolean isFinished() {
        return this.loadQueue.size == 0 && this.tasks.size() == 0;
    }

    public void finishLoading() {
        while (!this.update()) {
            Threads.yield();
        }
    }

    public void finishLoadingAsset(AssetDescriptor assetDesc) {
        this.finishLoadingAsset(assetDesc.fileName);
    }

    public void finishLoadingAsset(String fileName) {
        while (!this.isLoaded(fileName)) {
            this.update();
            Threads.yield();
        }
    }

    synchronized void injectDependencies(String parentAssetFilename, Seq<AssetDescriptor> dependendAssetDescs) {
        ObjectSet<String> injected = this.injected;
        for (AssetDescriptor desc : dependendAssetDescs) {
            if (injected.contains(desc.fileName)) continue;
            injected.add(desc.fileName);
            this.injectDependency(parentAssetFilename, desc);
        }
        injected.clear();
    }

    private synchronized void injectDependency(String parentAssetFilename, AssetDescriptor dependendAssetDesc) {
        Seq<String> dependencies = this.assetDependencies.get(parentAssetFilename);
        if (dependencies == null) {
            dependencies = new Seq();
            this.assetDependencies.put(parentAssetFilename, dependencies);
        }
        dependencies.add(dependendAssetDesc.fileName);
        if (this.isLoaded(dependendAssetDesc.fileName)) {
            Class type = this.assetTypes.get(dependendAssetDesc.fileName);
            RefCountedContainer assetRef = this.assets.get(type).get(dependendAssetDesc.fileName);
            assetRef.incRefCount();
            this.incrementRefCountedDependencies(dependendAssetDesc.fileName);
        } else {
            this.addTask(dependendAssetDesc);
        }
    }

    private void nextTask() {
        AssetDescriptor assetDesc = this.loadQueue.remove(0);
        if (this.isLoaded(assetDesc.fileName)) {
            Class type = this.assetTypes.get(assetDesc.fileName);
            RefCountedContainer assetRef = this.assets.get(type).get(assetDesc.fileName);
            assetRef.incRefCount();
            this.incrementRefCountedDependencies(assetDesc.fileName);
            if (assetDesc.params != null && assetDesc.params.loadedCallback != null) {
                assetDesc.params.loadedCallback.finishedLoading(this, assetDesc.fileName, assetDesc.type);
            }
            ++this.loaded;
        } else {
            this.addTask(assetDesc);
        }
    }

    private void addTask(AssetDescriptor assetDesc) {
        AssetLoader loader = this.getLoader(assetDesc.type, assetDesc.fileName);
        if (loader == null) {
            throw new ArcRuntimeException("No loader for type: " + assetDesc.type.getSimpleName());
        }
        this.tasks.push(new AssetLoadingTask(this, assetDesc, loader, this.executor));
        ++this.peakTasks;
    }

    protected <T> void addAsset(String fileName, Class<T> type, T asset) {
        this.assetTypes.put(fileName, type);
        ObjectMap<String, RefCountedContainer> typeToAssets = this.assets.get(type);
        if (typeToAssets == null) {
            typeToAssets = new ObjectMap();
            this.assets.put(type, typeToAssets);
        }
        typeToAssets.put(fileName, new RefCountedContainer(asset));
    }

    private boolean updateTask() {
        AssetLoadingTask task = this.tasks.peek();
        boolean complete = true;
        try {
            complete = task.cancel || task.update();
        }
        catch (RuntimeException ex) {
            task.cancel = true;
            this.taskFailed(task.assetDesc, ex);
        }
        if (complete) {
            if (this.tasks.size() == 1) {
                ++this.loaded;
                this.peakTasks = 0;
            }
            this.tasks.pop();
            if (task.cancel) {
                return true;
            }
            this.addAsset(task.assetDesc.fileName, task.assetDesc.type, task.getAsset());
            if (task.assetDesc.params != null && task.assetDesc.params.loadedCallback != null) {
                task.assetDesc.params.loadedCallback.finishedLoading(this, task.assetDesc.fileName, task.assetDesc.type);
            }
            task.assetDesc.loaded.get(task.getAsset());
            return true;
        }
        return false;
    }

    protected void taskFailed(AssetDescriptor assetDesc, RuntimeException ex) {
        throw ex;
    }

    private void incrementRefCountedDependencies(String parent) {
        Seq<String> dependencies = this.assetDependencies.get(parent);
        if (dependencies == null) {
            return;
        }
        for (String dependency : dependencies) {
            Class type = this.assetTypes.get(dependency);
            RefCountedContainer assetRef = this.assets.get(type).get(dependency);
            assetRef.incRefCount();
            this.incrementRefCountedDependencies(dependency);
        }
    }

    private void handleTaskError(Throwable t) {
        if (this.tasks.isEmpty()) {
            throw new ArcRuntimeException(t);
        }
        AssetLoadingTask task = this.tasks.pop();
        AssetDescriptor assetDesc = task.assetDesc;
        if (task.dependenciesLoaded && task.dependencies != null) {
            for (AssetDescriptor desc : task.dependencies) {
                this.unload(desc.fileName);
            }
        }
        this.tasks.clear();
        if (this.listener != null) {
            this.listener.error(assetDesc, t);
        }
        if (assetDesc.errored == null) {
            throw new ArcRuntimeException(t);
        }
        assetDesc.errored.get(t);
    }

    public synchronized <T, P extends AssetLoaderParameters<T>> void setLoader(Class<T> type, AssetLoader<T, P> loader) {
        this.setLoader(type, null, loader);
    }

    public synchronized <T, P extends AssetLoaderParameters<T>> void setLoader(Class<T> type, String suffix, AssetLoader<T, P> loader) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be null.");
        }
        ObjectMap loaders = this.loaders.get(type);
        if (loaders == null) {
            loaders = new ObjectMap();
            this.loaders.put(type, loaders);
        }
        loaders.put(suffix == null ? "" : suffix, loader);
    }

    public synchronized int getLoadedAssets() {
        return this.assetTypes.size;
    }

    public synchronized int getQueuedAssets() {
        return this.loadQueue.size + this.tasks.size();
    }

    public synchronized float getProgress() {
        if (this.toLoad == 0) {
            return 1.0f;
        }
        float fractionalLoaded = this.loaded;
        if (this.peakTasks > 0) {
            fractionalLoaded += (float)(this.peakTasks - this.tasks.size()) / (float)this.peakTasks;
        }
        return Math.min(1.0f, fractionalLoaded / (float)this.toLoad);
    }

    public synchronized void setErrorListener(AssetErrorListener listener) {
        this.listener = listener;
    }

    @Override
    public synchronized void dispose() {
        this.clear();
        this.executor.dispose();
    }

    public synchronized void clear() {
        this.loadQueue.clear();
        while (!this.update()) {
        }
        ObjectIntMap<String> dependencyCount = new ObjectIntMap<String>();
        while (this.assetTypes.size > 0) {
            dependencyCount.clear();
            Seq<String> assets = this.assetTypes.keys().toSeq();
            for (String asset : assets) {
                dependencyCount.put(asset, 0);
            }
            for (String asset : assets) {
                Seq<String> dependencies = this.assetDependencies.get(asset);
                if (dependencies == null) continue;
                for (String dependency : dependencies) {
                    int count = dependencyCount.get(dependency, 0);
                    dependencyCount.put(dependency, ++count);
                }
            }
            for (String asset : assets) {
                if (dependencyCount.get(asset, 0) != 0) continue;
                this.unload(asset);
            }
        }
        this.assets.clear();
        this.assetTypes.clear();
        this.assetDependencies.clear();
        this.loaded = 0;
        this.toLoad = 0;
        this.peakTasks = 0;
        this.loadQueue.clear();
        this.tasks.clear();
    }

    public synchronized int getReferenceCount(String fileName) {
        Class type = this.assetTypes.get(fileName);
        if (type == null) {
            throw new ArcRuntimeException("Asset not loaded: " + fileName);
        }
        return this.assets.get(type).get(fileName).getRefCount();
    }

    public synchronized void setReferenceCount(String fileName, int refCount) {
        Class type = this.assetTypes.get(fileName);
        if (type == null) {
            throw new ArcRuntimeException("Asset not loaded: " + fileName);
        }
        this.assets.get(type).get(fileName).setRefCount(refCount);
    }

    public synchronized String getDiagnostics() {
        StringBuilder sb = new StringBuilder();
        for (String fileName : this.assetTypes.keys()) {
            sb.append(fileName);
            sb.append(", ");
            Class type = this.assetTypes.get(fileName);
            RefCountedContainer assetRef = this.assets.get(type).get(fileName);
            Seq<String> dependencies = this.assetDependencies.get(fileName);
            sb.append(type.getSimpleName());
            sb.append(", refs: ");
            sb.append(assetRef.getRefCount());
            if (dependencies != null) {
                sb.append(", deps: [");
                for (String dep : dependencies) {
                    sb.append(dep);
                    sb.append(",");
                }
                sb.append("]");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public synchronized Seq<String> getAssetNames() {
        return this.assetTypes.keys().toSeq();
    }

    public synchronized Seq<String> getDependencies(String fileName) {
        return this.assetDependencies.get(fileName);
    }

    public synchronized Class getAssetType(String fileName) {
        return this.assetTypes.get(fileName);
    }
}

