/*
 * Decompiled with CFR 0.152.
 */
package arc.audio;

import arc.Core;
import arc.audio.AudioFilter;
import arc.audio.AudioSource;
import arc.audio.Soloud;
import arc.util.Nullable;

public class AudioBus
extends AudioSource {
    public int id;

    public AudioBus() {
        if (Core.audio != null && Core.audio.initialized) {
            this.init();
        }
    }

    @Override
    public void setFilter(int index, @Nullable AudioFilter filter) {
        if (this.handle == 0L) {
            return;
        }
        Soloud.sourceFilter(this.handle, index, filter == null ? 0L : filter.handle);
    }

    AudioBus init() {
        if (this.handle != 0L) {
            return this;
        }
        this.handle = Soloud.busNew();
        this.id = Soloud.sourcePlay(this.handle);
        return this;
    }

    public boolean playing() {
        return this.handle != 0L && Core.audio.isPlaying(this.id);
    }

    public void play() {
        if (this.handle == 0L || Soloud.idValid(this.id)) {
            return;
        }
        this.id = Soloud.sourcePlay(this.handle);
    }

    public void replay() {
        if (this.handle == 0L) {
            return;
        }
        this.id = Soloud.sourcePlay(this.handle);
    }

    public void stop() {
        Core.audio.stop(this.id);
        this.id = 0;
    }

    public void fadeFilterParam(int filter, int attribute, float value, float timeSec) {
        Core.audio.fadeFilterParam(this.id, filter, attribute, value, timeSec);
    }

    public void setFilterParam(int filter, int attribute, float value) {
        Core.audio.setFilterParam(this.id, filter, attribute, value);
    }

    public void setVolume(float volume) {
        Core.audio.setVolume(this.id, volume);
    }
}

