/*
 * Decompiled with CFR 0.152.
 */
package arc.files;

import arc.Files;
import arc.files.Fi;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Log;
import arc.util.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFi
extends Fi {
    private ZipFi[] children = new ZipFi[0];
    private ZipFi parent;
    private String path;
    @Nullable
    private final ZipEntry entry;
    private final ZipFile zip;

    public ZipFi(Fi zipFileLoc) {
        super(new File(""), Files.FileType.absolute);
        this.entry = null;
        try {
            this.zip = new ZipFile(zipFileLoc.file());
            this.path = "";
            Seq<String> names = Seq.with(Collections.list(this.zip.entries())).map((T z) -> z.getName().replace('\\', '/'));
            ObjectSet<String> paths = new ObjectSet<String>();
            for (String path : names) {
                paths.add(path);
                while (path.contains("/") && !path.equals("/") && path.substring(0, path.length() - 1).contains("/")) {
                    int index = path.endsWith("/") ? path.substring(0, path.length() - 1).lastIndexOf(47) : path.lastIndexOf(47);
                    path = path.substring(0, index);
                    paths.add(path.endsWith("/") ? path : path + "/");
                }
            }
            if (paths.contains("/")) {
                this.file = new File("/");
                paths.remove("/");
            }
            Seq<ZipFi> files = Seq.with(paths).map((T s) -> this.zip.getEntry((String)s) != null ? new ZipFi(this.zip.getEntry((String)s), this.zip) : new ZipFi((String)s, this.zip));
            files.add(this);
            files.each(file -> {
                file.parent = files.find(other -> other.isDirectory() && other != file && file.path().startsWith(other.path()) && (!file.path().substring(1 + other.path().length()).contains("/") || file.path().endsWith("/") && this.countSlahes(file.path().substring(1 + other.path().length())) == 1));
            });
            files.each(file -> {
                file.children = (ZipFi[])files.select(f -> f.parent == file).toArray(ZipFi.class);
            });
            this.parent = null;
        }
        catch (IOException e) {
            throw new ArcRuntimeException(e);
        }
    }

    private int countSlahes(String str) {
        int sum = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '/') continue;
            ++sum;
        }
        return sum;
    }

    private ZipFi(ZipEntry entry, ZipFile file) {
        super(new File(entry.getName()), Files.FileType.absolute);
        this.path = entry.getName().replace('\\', '/');
        this.entry = entry;
        this.zip = file;
    }

    private ZipFi(String path, ZipFile file) {
        super(new File(path), Files.FileType.absolute);
        this.path = path.replace('\\', '/');
        this.entry = null;
        this.zip = file;
    }

    @Override
    public boolean delete() {
        try {
            this.zip.close();
            return true;
        }
        catch (IOException e) {
            Log.err(e);
            return false;
        }
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public Fi child(String name) {
        for (ZipFi child : this.children) {
            if (!child.name().equals(name)) continue;
            return child;
        }
        return new Fi(new File(this.file, name)){

            @Override
            public boolean exists() {
                return false;
            }
        };
    }

    @Override
    public String name() {
        return this.file.getName();
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Fi parent() {
        return this.parent;
    }

    @Override
    public Fi[] list() {
        return this.children;
    }

    @Override
    public boolean isDirectory() {
        return this.entry == null || this.entry.isDirectory();
    }

    @Override
    public InputStream read() {
        if (this.entry == null) {
            throw new RuntimeException("Not permitted.");
        }
        try {
            return this.zip.getInputStream(this.entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long length() {
        return this.isDirectory() ? 0L : this.entry.getSize();
    }

    @Override
    public String toString() {
        return this.path();
    }
}

