/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.fx.FxFilter;
import arc.fx.filters.CopyFilter;
import arc.fx.filters.GaussianBlurFilter;
import arc.fx.util.PingPongBuffer;
import arc.graphics.Blending;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.gl.FrameBuffer;

public class BlurFilter
extends FxFilter {
    public final GaussianBlurFilter blur;
    private final PingPongBuffer pingPongBuffer;
    private final CopyFilter copy;
    public Blending blending = Blending.disabled;
    private boolean firstRender = true;

    public BlurFilter() {
        this(8, GaussianBlurFilter.BlurType.gaussian5x5);
    }

    public BlurFilter(int blurPasses, GaussianBlurFilter.BlurType blurType) {
        this.pingPongBuffer = new PingPongBuffer(Pixmap.Format.rgba8888);
        this.copy = new CopyFilter();
        this.blur = new GaussianBlurFilter();
        this.blur.setPasses(blurPasses);
        this.blur.setType(blurType);
    }

    @Override
    public void dispose() {
        this.pingPongBuffer.dispose();
        this.blur.dispose();
        this.copy.dispose();
    }

    @Override
    public void resize(int width, int height) {
        this.pingPongBuffer.resize(width, height);
        this.blur.resize(width, height);
        this.copy.resize(width, height);
    }

    @Override
    public void rebind() {
        this.pingPongBuffer.rebind();
        this.blur.setParams();
        this.copy.rebind();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dst) {
        if (this.blur.getPasses() < 1) {
            this.copy.setInput(src).setOutput(dst).render();
            return;
        }
        Gl.disable(3042);
        this.pingPongBuffer.begin();
        this.copy.setInput(src).setOutput(this.pingPongBuffer.getDstBuffer()).render();
        this.pingPongBuffer.swap();
        if (this.firstRender) {
            this.firstRender = false;
            this.copy.setInput(src).setOutput(this.pingPongBuffer.getDstBuffer()).render();
            this.pingPongBuffer.swap();
        }
        this.blur.render(this.pingPongBuffer);
        this.pingPongBuffer.end();
        if (this.blending != Blending.disabled) {
            Gl.enable(3042);
            Gl.blendFunc(this.blending.src, this.blending.dst);
        }
        this.copy.setInput(this.pingPongBuffer.getDstTexture()).setOutput(dst).render();
    }
}

