/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.Core;
import arc.fx.FxFilter;
import arc.math.geom.Vec2;
import arc.util.Tmp;

public class CrtFilter
extends FxFilter {
    public final Vec2 viewportSize = new Vec2();
    public SizeSource sizeSource = SizeSource.VIEWPORT;

    public CrtFilter() {
        this(LineStyle.HORIZONTAL_HARD, 1.3f, 0.5f);
    }

    public CrtFilter(LineStyle lineStyle, float brightnessMin, float brightnessMax) {
        super(CrtFilter.compileShader(Core.files.classpath("shaders/screenspace.vert"), Core.files.classpath("shaders/crt.frag"), "#define SL_BRIGHTNESS_MIN " + brightnessMin + "\n#define SL_BRIGHTNESS_MAX " + brightnessMax + "\n#define LINE_TYPE " + lineStyle.ordinal()));
        this.rebind();
    }

    @Override
    public void resize(int width, int height) {
        this.viewportSize.set(width, height);
        this.rebind();
    }

    @Override
    public void setParams() {
        this.shader.setUniformi("u_texture0", 0);
        this.shader.setUniformf("u_resolution", this.sizeSource == SizeSource.SCREEN ? Tmp.v1.set(Core.graphics.getWidth(), Core.graphics.getHeight()) : this.viewportSize);
    }

    public static enum LineStyle {
        CROSSLINE_HARD,
        VERTICAL_HARD,
        HORIZONTAL_HARD,
        VERTICAL_SMOOTH,
        HORIZONTAL_SMOOTH;

    }

    public static enum SizeSource {
        VIEWPORT,
        SCREEN;

    }
}

