/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.Core;
import arc.fx.FxFilter;
import arc.math.geom.Vec2;

public final class FxaaFilter
extends FxFilter {
    public final Vec2 viewportInverse = new Vec2();
    public float fxaaReduceMin;
    public float fxaaReduceMul;
    public float fxaaSpanMax;

    public FxaaFilter() {
        this(0.0078125f, 0.125f, 8.0f, true);
    }

    public FxaaFilter(float fxaaReduceMin, float fxaaReduceMul, float fxaaSpanMax, boolean supportAlpha) {
        super(FxaaFilter.compileShader(Core.files.classpath("shaders/screenspace.vert"), Core.files.classpath("shaders/fxaa.frag"), supportAlpha ? "#define SUPPORT_ALPHA" : ""));
        this.fxaaReduceMin = fxaaReduceMin;
        this.fxaaReduceMul = fxaaReduceMul;
        this.fxaaSpanMax = fxaaSpanMax;
        this.rebind();
    }

    @Override
    public void resize(int width, int height) {
        this.viewportInverse.set(1.0f / (float)width, 1.0f / (float)height);
        this.rebind();
    }

    @Override
    public void setParams() {
        this.shader.setUniformi("u_texture0", 0);
        this.shader.setUniformf("u_viewportInverse", this.viewportInverse);
        this.shader.setUniformf("u_fxaaReduceMin", this.fxaaReduceMin);
        this.shader.setUniformf("u_fxaaReduceMul", this.fxaaReduceMul);
        this.shader.setUniformf("u_fxaaSpanMax", this.fxaaSpanMax);
    }
}

