/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.Core;
import arc.fx.FxFilter;

public final class RadialBlurFilter
extends FxFilter {
    public final int passes;
    public float strength = 0.2f;
    public float originX = 0.5f;
    public float originY = 0.5f;
    public float zoom = 1.0f;

    public RadialBlurFilter(int passes) {
        super(RadialBlurFilter.compileShader(Core.files.classpath("shaders/radial-blur.vert"), Core.files.classpath("shaders/radial-blur.frag"), "#define PASSES " + passes));
        this.passes = passes;
        this.rebind();
    }

    public float getOriginX() {
        return this.originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public void setOrigin(int align) {
        float originX = (align & 8) != 0 ? 0.0f : ((align & 0x10) != 0 ? 1.0f : 0.5f);
        float originY = (align & 4) != 0 ? 0.0f : ((align & 2) != 0 ? 1.0f : 0.5f);
        this.setOrigin(originX, originY);
    }

    public void setOrigin(float originX, float originY) {
        this.originX = originX;
        this.originY = originY;
    }

    @Override
    public void setParams() {
        this.shader.setUniformi("u_texture0", 0);
        this.shader.setUniformf("u_blurDiv", this.strength / (float)this.passes);
        this.shader.setUniformf("u_offsetX", this.originX);
        this.shader.setUniformf("u_offsetY", this.originY);
        this.shader.setUniformf("u_zoom", this.zoom);
    }
}

