/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics;

import arc.Core;
import arc.graphics.VertexAttribute;
import arc.graphics.gl.IndexArray;
import arc.graphics.gl.IndexBufferObject;
import arc.graphics.gl.IndexBufferObjectSubData;
import arc.graphics.gl.IndexData;
import arc.graphics.gl.Shader;
import arc.graphics.gl.VertexArray;
import arc.graphics.gl.VertexBufferObject;
import arc.graphics.gl.VertexBufferObjectWithVAO;
import arc.graphics.gl.VertexData;
import arc.util.Disposable;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class Mesh
implements Disposable {
    public final int vertexSize;
    public final VertexAttribute[] attributes;
    public final VertexData vertices;
    public final IndexData indices;
    boolean autoBind = true;

    public Mesh(boolean isStatic, int maxVertices, int maxIndices, VertexAttribute ... attributes) {
        this(false, isStatic, maxVertices, maxIndices, attributes);
    }

    public Mesh(boolean useVertexArray, boolean isStatic, int maxVertices, int maxIndices, VertexAttribute ... attributes) {
        int count = 0;
        for (VertexAttribute attribute : attributes) {
            count += attribute.size;
        }
        this.vertexSize = count;
        this.attributes = attributes;
        if (useVertexArray && Core.gl30 == null) {
            this.vertices = new VertexArray(maxVertices, this);
            this.indices = new IndexArray(maxIndices);
        } else if (Core.gl30 != null) {
            this.vertices = new VertexBufferObjectWithVAO(isStatic, maxVertices, this);
            this.indices = new IndexBufferObjectSubData(isStatic, maxIndices);
        } else {
            this.vertices = new VertexBufferObject(isStatic, maxVertices, this);
            this.indices = new IndexBufferObject(isStatic, maxIndices);
        }
    }

    public Mesh setVertices(float[] vertices) {
        this.vertices.set(vertices, 0, vertices.length);
        return this;
    }

    public Mesh setVertices(float[] vertices, int offset, int count) {
        this.vertices.set(vertices, offset, count);
        return this;
    }

    public Mesh updateVertices(int targetOffset, float[] source) {
        return this.updateVertices(targetOffset, source, 0, source.length);
    }

    public Mesh updateVertices(int targetOffset, float[] source, int sourceOffset, int count) {
        this.vertices.update(targetOffset, source, sourceOffset, count);
        return this;
    }

    public Mesh setIndices(short[] indices) {
        this.indices.set(indices, 0, indices.length);
        return this;
    }

    public Mesh setIndices(short[] indices, int offset, int count) {
        this.indices.set(indices, offset, count);
        return this;
    }

    public void getIndices(short[] indices) {
        this.getIndices(indices, 0);
    }

    public void getIndices(short[] indices, int destOffset) {
        this.getIndices(0, indices, destOffset);
    }

    public void getIndices(int srcOffset, short[] indices, int destOffset) {
        this.getIndices(srcOffset, -1, indices, destOffset);
    }

    public void getIndices(int srcOffset, int count, short[] indices, int destOffset) {
        int max = this.getNumIndices();
        if (count < 0) {
            count = max - srcOffset;
        }
        if (srcOffset < 0 || srcOffset >= max || srcOffset + count > max) {
            throw new IllegalArgumentException("Invalid range specified, offset: " + srcOffset + ", count: " + count + ", max: " + max);
        }
        if (indices.length - destOffset < count) {
            throw new IllegalArgumentException("not enough room in indices array, has " + indices.length + " shorts, needs " + count);
        }
        int pos = this.getIndicesBuffer().position();
        this.getIndicesBuffer().position(srcOffset);
        this.getIndicesBuffer().get(indices, destOffset, count);
        this.getIndicesBuffer().position(pos);
    }

    public int getNumIndices() {
        return this.indices.size();
    }

    public int getNumVertices() {
        return this.vertices.size();
    }

    public int getMaxVertices() {
        return this.vertices.max();
    }

    public int getMaxIndices() {
        return this.indices.max();
    }

    public int getVertexSize() {
        return this.vertexSize;
    }

    public void setAutoBind(boolean autoBind) {
        this.autoBind = autoBind;
    }

    public void bind(Shader shader) {
        this.vertices.bind(shader);
        if (this.indices.size() > 0) {
            this.indices.bind();
        }
    }

    public void unbind(Shader shader) {
        this.vertices.unbind(shader);
        if (this.indices.size() > 0) {
            this.indices.unbind();
        }
    }

    public void render(Shader shader, int primitiveType) {
        this.render(shader, primitiveType, 0, this.indices.max() > 0 ? this.getNumIndices() : this.getNumVertices(), this.autoBind);
    }

    public void render(Shader shader, int primitiveType, int offset, int count) {
        this.render(shader, primitiveType, offset, count, this.autoBind);
    }

    public void render(Shader shader, int primitiveType, int offset, int count, boolean autoBind) {
        if (count == 0) {
            return;
        }
        if (autoBind) {
            this.bind(shader);
        }
        this.vertices.render(this.indices, primitiveType, offset, count);
        if (autoBind) {
            this.unbind(shader);
        }
    }

    @Override
    public void dispose() {
        this.vertices.dispose();
        this.indices.dispose();
    }

    public FloatBuffer getVerticesBuffer() {
        return this.vertices.buffer();
    }

    public ShortBuffer getIndicesBuffer() {
        return this.indices.buffer();
    }
}

