/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics;

import arc.Core;
import arc.files.Fi;
import arc.func.Intc2;
import arc.graphics.Color;
import arc.graphics.g2d.PixmapRegion;
import arc.util.ArcRuntimeException;
import arc.util.Disposable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Pixmap
implements Disposable {
    static final int pixmapFormatAlpha = 1;
    static final int pixmapFormatLuminanceAlpha = 2;
    static final int pixmapFormatRGB888 = 3;
    static final int pixmapFormatRGBA8888 = 4;
    static final int pixmapFormatRGB565 = 5;
    static final int pixmapFormatRGBA4444 = 6;
    static final int pixmapScaleNearest = 0;
    static final int pixmapScaleLinear = 1;
    final NativePixmap pixmap;
    int color = 0;
    private Blending blending = Blending.sourceOver;
    private PixmapFilter filter = PixmapFilter.bilinear;
    private boolean disposed;

    public Pixmap(int width, int height) {
        this(width, height, Format.rgba8888);
    }

    public Pixmap(int width, int height, Format format) {
        this.pixmap = new NativePixmap(width, height, format.toPixmapFormat());
        this.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.fill();
    }

    public Pixmap(byte[] encodedData) {
        this(encodedData, 0, encodedData.length);
    }

    public Pixmap(byte[] encodedData, int offset, int len) {
        try {
            this.pixmap = new NativePixmap(encodedData, offset, len, 0);
        }
        catch (IOException e) {
            throw new ArcRuntimeException("Couldn't load pixmap from image data", e);
        }
    }

    public Pixmap(String file) {
        this(Core.files.internal(file));
    }

    public Pixmap(Fi file) {
        try {
            byte[] bytes = file.readBytes();
            this.pixmap = new NativePixmap(bytes, 0, bytes.length, 0);
        }
        catch (Exception e) {
            throw new ArcRuntimeException("Couldn't load file: " + file, e);
        }
    }

    public Pixmap(NativePixmap pixmap) {
        this.pixmap = pixmap;
    }

    public void each(Intc2 cons) {
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                cons.get(x, y);
            }
        }
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColor(float r, float g, float b, float a) {
        this.color = Color.rgba8888(r, g, b, a);
    }

    public void setColor(Color color) {
        this.color = Color.rgba8888(color.r, color.g, color.b, color.a);
    }

    public void fill() {
        Pixmap.clear(this.pixmap.basePtr, this.color);
    }

    public void drawLine(int x, int y, int x2, int y2) {
        Pixmap.drawLine(this.pixmap.basePtr, x, y, x2, y2, this.color);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        Pixmap.drawRect(this.pixmap.basePtr, x, y, width, height, this.color);
    }

    public void draw(PixmapRegion region) {
        this.drawPixmap(region.pixmap, region.x, region.y, region.width, region.height, 0, 0, region.width, region.height);
    }

    public void draw(PixmapRegion region, int x, int y) {
        this.drawPixmap(region.pixmap, region.x, region.y, region.width, region.height, x, y, region.width, region.height);
    }

    public void draw(PixmapRegion region, int x, int y, int width, int height) {
        this.drawPixmap(region.pixmap, region.x, region.y, region.width, region.height, x, y, width, height);
    }

    public void draw(PixmapRegion region, int x, int y, int srcx, int srcy, int srcWidth, int srcHeight) {
        this.drawPixmap(region.pixmap, x, y, region.x + srcx, region.y + srcy, srcWidth, srcHeight);
    }

    public void draw(PixmapRegion region, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight) {
        this.drawPixmap(region.pixmap, region.x + srcx, region.y + srcy, srcWidth, srcHeight, dstx, dsty, dstWidth, dstHeight);
    }

    public void drawPixmap(Pixmap pixmap) {
        this.drawPixmap(pixmap, 0, 0);
    }

    public void drawPixmap(Pixmap pixmap, int x, int y) {
        this.drawPixmap(pixmap, x, y, 0, 0, pixmap.getWidth(), pixmap.getHeight());
    }

    public void drawPixmap(Pixmap pixmap, int x, int y, int srcx, int srcy, int srcWidth, int srcHeight) {
        Pixmap.drawPixmap(pixmap.pixmap.basePtr, this.pixmap.basePtr, srcx, srcy, srcWidth, srcHeight, x, y, srcWidth, srcHeight);
    }

    public void drawPixmap(Pixmap pixmap, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight) {
        Pixmap.drawPixmap(pixmap.pixmap.basePtr, this.pixmap.basePtr, srcx, srcy, srcWidth, srcHeight, dstx, dsty, dstWidth, dstHeight);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        Pixmap.fillRect(this.pixmap.basePtr, x, y, width, height, this.color);
    }

    public void drawCircle(int x, int y, int radius) {
        Pixmap.drawCircle(this.pixmap.basePtr, x, y, radius, this.color);
    }

    public void fillCircle(int x, int y, int radius) {
        Pixmap.fillCircle(this.pixmap.basePtr, x, y, radius, this.color);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        Pixmap.fillTriangle(this.pixmap.basePtr, x1, y1, x2, y2, x3, y3, this.color);
    }

    public int getPixel(int x, int y) {
        return Pixmap.getPixel(this.pixmap.basePtr, x, y);
    }

    public int getWidth() {
        return this.pixmap.width;
    }

    public int getHeight() {
        return this.pixmap.height;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            throw new ArcRuntimeException("Pixmap already disposed!");
        }
        Pixmap.free(this.pixmap.basePtr);
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    public void draw(int x, int y, Color color) {
        this.draw(x, y, color.rgba());
    }

    public void draw(int x, int y) {
        Pixmap.setPixel(this.pixmap.basePtr, x, y, this.color);
    }

    public void draw(int x, int y, int color) {
        Pixmap.setPixel(this.pixmap.basePtr, x, y, color);
    }

    public int getGLFormat() {
        return Pixmap.toGlFormat(this.pixmap.format);
    }

    public int getGLInternalFormat() {
        return Pixmap.toGlFormat(this.pixmap.format);
    }

    public int getGLType() {
        return Pixmap.toGlType(this.pixmap.format);
    }

    public ByteBuffer getPixels() {
        if (this.disposed) {
            throw new ArcRuntimeException("Pixmap already disposed");
        }
        return this.pixmap.pixelPtr;
    }

    public Format getFormat() {
        return Format.fromPixmapFormat(this.pixmap.format);
    }

    public Blending getBlending() {
        return this.blending;
    }

    public void setBlending(Blending blending) {
        this.blending = blending;
        int blend = blending == Blending.none ? 0 : 1;
        Pixmap.setBlend(this.pixmap.basePtr, blend);
    }

    public PixmapFilter getFilter() {
        return this.filter;
    }

    public void setFilter(PixmapFilter filter) {
        this.filter = filter;
        int scale = filter == PixmapFilter.nearestNeighbour ? 0 : 1;
        Pixmap.setScale(this.pixmap.basePtr, scale);
    }

    public static int toGlFormat(int format) {
        switch (format) {
            case 1: {
                return 6406;
            }
            case 2: {
                return 6410;
            }
            case 3: 
            case 5: {
                return 6407;
            }
            case 4: 
            case 6: {
                return 6408;
            }
        }
        throw new ArcRuntimeException("unknown format: " + format);
    }

    public static int toGlType(int format) {
        switch (format) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 5121;
            }
            case 5: {
                return 33635;
            }
            case 6: {
                return 32819;
            }
        }
        throw new ArcRuntimeException("unknown format: " + format);
    }

    static native ByteBuffer load(long[] var0, byte[] var1, int var2, int var3);

    static native ByteBuffer newPixmap(long[] var0, int var1, int var2, int var3);

    static native void free(long var0);

    private static native void clear(long var0, int var2);

    private static native void setPixel(long var0, int var2, int var3, int var4);

    private static native int getPixel(long var0, int var2, int var3);

    private static native void drawLine(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void drawRect(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void drawCircle(long var0, int var2, int var3, int var4, int var5);

    private static native void fillRect(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void fillCircle(long var0, int var2, int var3, int var4, int var5);

    private static native void fillTriangle(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    static native void drawPixmap(long var0, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private static native void setBlend(long var0, int var2);

    private static native void setScale(long var0, int var2);

    public static native String getFailureReason();

    public static enum Format {
        alpha,
        intensity,
        luminanceAlpha,
        rgb565,
        rgba4444,
        rgb888,
        rgba8888;


        public int toPixmapFormat() {
            switch (this) {
                case alpha: 
                case intensity: {
                    return 1;
                }
                case luminanceAlpha: {
                    return 2;
                }
                case rgb565: {
                    return 5;
                }
                case rgba4444: {
                    return 6;
                }
                case rgb888: {
                    return 3;
                }
                case rgba8888: {
                    return 4;
                }
            }
            throw new ArcRuntimeException("Unknown Format: " + (Object)((Object)this));
        }

        public static Format fromPixmapFormat(int format) {
            switch (format) {
                case 1: {
                    return alpha;
                }
                case 2: {
                    return luminanceAlpha;
                }
                case 5: {
                    return rgb565;
                }
                case 6: {
                    return rgba4444;
                }
                case 3: {
                    return rgb888;
                }
                case 4: {
                    return rgba8888;
                }
            }
            throw new ArcRuntimeException("Unknown Pixmap Format: " + format);
        }

        public int toGlFormat() {
            return Pixmap.toGlFormat(this.toPixmapFormat());
        }

        public int toGlType() {
            return Pixmap.toGlType(this.toPixmapFormat());
        }
    }

    public static enum Blending {
        none,
        sourceOver;

    }

    public static enum PixmapFilter {
        nearestNeighbour,
        bilinear;

    }

    private static class NativePixmap {
        long basePtr;
        int width;
        int height;
        int format;
        ByteBuffer pixelPtr;
        long[] nativeData = new long[4];

        public NativePixmap(byte[] encodedData, int offset, int len, int requestedFormat) throws IOException {
            this.pixelPtr = Pixmap.load(this.nativeData, encodedData, offset, len);
            if (this.pixelPtr == null) {
                throw new IOException("Error loading pixmap: " + Pixmap.getFailureReason());
            }
            this.basePtr = this.nativeData[0];
            this.width = (int)this.nativeData[1];
            this.height = (int)this.nativeData[2];
            this.format = (int)this.nativeData[3];
            if (requestedFormat != 0 && requestedFormat != this.format) {
                this.convert(requestedFormat);
            }
        }

        public NativePixmap(int width, int height, int format) throws ArcRuntimeException {
            this.pixelPtr = Pixmap.newPixmap(this.nativeData, width, height, format);
            if (this.pixelPtr == null) {
                throw new ArcRuntimeException("Error loading pixmap.");
            }
            this.basePtr = this.nativeData[0];
            this.width = (int)this.nativeData[1];
            this.height = (int)this.nativeData[2];
            this.format = (int)this.nativeData[3];
        }

        private void convert(int requestedFormat) {
            NativePixmap pixmap = new NativePixmap(this.width, this.height, requestedFormat);
            Pixmap.drawPixmap(this.basePtr, pixmap.basePtr, 0, 0, this.width, this.height, 0, 0, this.width, this.height);
            Pixmap.free(this.basePtr);
            this.basePtr = pixmap.basePtr;
            this.format = pixmap.format;
            this.height = pixmap.height;
            this.nativeData = pixmap.nativeData;
            this.pixelPtr = pixmap.pixelPtr;
            this.width = pixmap.width;
        }
    }
}

