/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics;

import arc.files.Fi;
import arc.graphics.Pixmap;
import arc.graphics.gl.FileTextureData;

public interface TextureData {
    public boolean isCustom();

    public boolean isPrepared();

    public void prepare();

    public Pixmap consumePixmap();

    default public Pixmap getPixmap() {
        if (!this.isPrepared()) {
            this.prepare();
        }
        return this.consumePixmap();
    }

    public boolean disposePixmap();

    public void consumeCustomData(int var1);

    public int getWidth();

    public int getHeight();

    public Pixmap.Format getFormat();

    public boolean useMipMaps();

    public static TextureData load(Fi file, boolean useMipMaps) {
        return TextureData.load(file, null, useMipMaps);
    }

    public static TextureData load(Fi file, Pixmap.Format format, boolean useMipMaps) {
        if (file == null) {
            return null;
        }
        return new FileTextureData(file, new Pixmap(file), format, useMipMaps);
    }
}

