/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.math.Mathf;
import arc.struct.Seq;
import java.lang.reflect.Array;

public class Animation<T> {
    T[] keyFrames;
    private float frameDuration;
    private float animationDuration;
    private int lastFrameNumber;
    private float lastStateTime;
    private PlayMode playMode = PlayMode.normal;

    public Animation(float frameDuration, Seq<? extends T> keyFrames) {
        this.frameDuration = frameDuration;
        Class<?> arrayType = keyFrames.items.getClass().getComponentType();
        Object[] frames = (Object[])Array.newInstance(arrayType, keyFrames.size);
        int n = keyFrames.size;
        for (int i = 0; i < n; ++i) {
            frames[i] = keyFrames.get(i);
        }
        this.setKeyFrames(frames);
    }

    public Animation(float frameDuration, Seq<? extends T> keyFrames, PlayMode playMode) {
        this(frameDuration, keyFrames);
        this.setPlayMode(playMode);
    }

    public Animation(float frameDuration, T ... keyFrames) {
        this.frameDuration = frameDuration;
        this.setKeyFrames(keyFrames);
    }

    public T getKeyFrame(float stateTime, boolean looping) {
        PlayMode oldPlayMode = this.playMode;
        if (looping && (this.playMode == PlayMode.normal || this.playMode == PlayMode.reversed)) {
            this.playMode = this.playMode == PlayMode.normal ? PlayMode.loop : PlayMode.loopReversed;
        } else if (!looping && this.playMode != PlayMode.normal && this.playMode != PlayMode.reversed) {
            this.playMode = this.playMode == PlayMode.loopReversed ? PlayMode.reversed : PlayMode.loop;
        }
        T frame = this.getKeyFrame(stateTime);
        this.playMode = oldPlayMode;
        return frame;
    }

    public T getKeyFrame(float stateTime) {
        int frameNumber = this.getKeyFrameIndex(stateTime);
        return this.keyFrames[frameNumber];
    }

    public int getKeyFrameIndex(float stateTime) {
        if (this.keyFrames.length == 1) {
            return 0;
        }
        int frameNumber = (int)(stateTime / this.frameDuration);
        switch (this.playMode) {
            case normal: {
                frameNumber = Math.min(this.keyFrames.length - 1, frameNumber);
                break;
            }
            case loop: {
                frameNumber %= this.keyFrames.length;
                break;
            }
            case loopPingPong: {
                if ((frameNumber %= this.keyFrames.length * 2 - 2) < this.keyFrames.length) break;
                frameNumber = this.keyFrames.length - 2 - (frameNumber - this.keyFrames.length);
                break;
            }
            case loopRandom: {
                int lastFrameNumber = (int)(this.lastStateTime / this.frameDuration);
                if (lastFrameNumber != frameNumber) {
                    frameNumber = Mathf.random(this.keyFrames.length - 1);
                    break;
                }
                frameNumber = this.lastFrameNumber;
                break;
            }
            case reversed: {
                frameNumber = Math.max(this.keyFrames.length - frameNumber - 1, 0);
                break;
            }
            case loopReversed: {
                frameNumber %= this.keyFrames.length;
                frameNumber = this.keyFrames.length - frameNumber - 1;
            }
        }
        this.lastFrameNumber = frameNumber;
        this.lastStateTime = stateTime;
        return frameNumber;
    }

    public T[] getKeyFrames() {
        return this.keyFrames;
    }

    protected void setKeyFrames(T ... keyFrames) {
        this.keyFrames = keyFrames;
        this.animationDuration = (float)keyFrames.length * this.frameDuration;
    }

    public PlayMode getPlayMode() {
        return this.playMode;
    }

    public void setPlayMode(PlayMode playMode) {
        this.playMode = playMode;
    }

    public boolean isAnimationFinished(float stateTime) {
        int frameNumber = (int)(stateTime / this.frameDuration);
        return this.keyFrames.length - 1 < frameNumber;
    }

    public float getFrameDuration() {
        return this.frameDuration;
    }

    public void setFrameDuration(float frameDuration) {
        this.frameDuration = frameDuration;
        this.animationDuration = (float)this.keyFrames.length * frameDuration;
    }

    public float getAnimationDuration() {
        return this.animationDuration;
    }

    public static enum PlayMode {
        normal,
        reversed,
        loop,
        loopReversed,
        loopPingPong,
        loopRandom;

    }
}

