/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.files.Fi;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.FontCache;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.struct.Seq;

public class DistanceFieldFont
extends Font {
    private float distanceFieldSmoothing;

    public DistanceFieldFont(Font.FontData data, Seq<TextureRegion> pageRegions, boolean integer) {
        super(data, pageRegions, integer);
    }

    public DistanceFieldFont(Font.FontData data, TextureRegion region, boolean integer) {
        super(data, region, integer);
    }

    public DistanceFieldFont(Fi fontFile, boolean flip) {
        super(fontFile, flip);
    }

    public DistanceFieldFont(Fi fontFile, Fi imageFile, boolean flip, boolean integer) {
        super(fontFile, imageFile, flip, integer);
    }

    public DistanceFieldFont(Fi fontFile, Fi imageFile, boolean flip) {
        super(fontFile, imageFile, flip);
    }

    public DistanceFieldFont(Fi fontFile, TextureRegion region, boolean flip) {
        super(fontFile, region, flip);
    }

    public DistanceFieldFont(Fi fontFile, TextureRegion region) {
        super(fontFile, region);
    }

    public DistanceFieldFont(Fi fontFile) {
        super(fontFile);
    }

    public static Shader createDistanceFieldShader() {
        String vertexShader = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main(){\n\tv_color = a_color;\n\tv_color.a = v_color.a * (255.0/254.0);\n\tv_texCoords = a_texCoord0;\n\tgl_Position =  u_projTrans * a_position;\n}\n";
        String fragmentShader = "uniform sampler2D u_texture;\nuniform float u_smoothing;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main(){\n\tif (u_smoothing > 0.0) {\n\t\tfloat smoothing = 0.25 / u_smoothing;\n\t\tfloat distance = texture2D(u_texture, v_texCoords).a;\n\t\tfloat alpha = smoothstep(0.5 - smoothing, 0.5 + smoothing, distance);\n\t\tgl_FragColor = vec4(v_color.rgb, alpha * v_color.a);\n\t} else {\n\t\tgl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n\t}\n}\n";
        return new Shader(vertexShader, fragmentShader);
    }

    @Override
    protected void load(Font.FontData data) {
        super.load(data);
        Seq<TextureRegion> regions = this.getRegions();
        for (TextureRegion region : regions) {
            region.texture.setFilter(Texture.TextureFilter.linear, Texture.TextureFilter.linear);
        }
    }

    @Override
    public FontCache newFontCache() {
        return new DistanceFieldFontCache(this, this.integer);
    }

    public float getDistanceFieldSmoothing() {
        return this.distanceFieldSmoothing;
    }

    public void setDistanceFieldSmoothing(float distanceFieldSmoothing) {
        this.distanceFieldSmoothing = distanceFieldSmoothing;
    }

    private static class DistanceFieldFontCache
    extends FontCache {
        public DistanceFieldFontCache(DistanceFieldFont font) {
            super(font, font.usesIntegerPositions());
        }

        public DistanceFieldFontCache(DistanceFieldFont font, boolean integer) {
            super(font, integer);
        }

        private float getSmoothingFactor() {
            DistanceFieldFont font = (DistanceFieldFont)super.getFont();
            return font.getDistanceFieldSmoothing() * font.getScaleX();
        }

        private void setSmoothingUniform(float smoothing) {
            Draw.flush();
            Draw.getShader().setUniformf("u_smoothing", smoothing);
        }

        @Override
        public void draw() {
            this.setSmoothingUniform(this.getSmoothingFactor());
            super.draw();
            this.setSmoothingUniform(0.0f);
        }

        @Override
        public void draw(int start, int end) {
            this.setSmoothingUniform(this.getSmoothingFactor());
            super.draw(start, end);
            this.setSmoothingUniform(0.0f);
        }
    }
}

