/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;

public class Lines {
    public static boolean useLegacyLine = false;
    private static float stroke = 1.0f;
    private static Vec2 vector = new Vec2();
    private static Vec2 u = new Vec2();
    private static Vec2 v = new Vec2();
    private static Vec2 inner = new Vec2();
    private static Vec2 outer = new Vec2();
    private static FloatSeq floats = new FloatSeq(20);
    private static FloatSeq floatBuilder = new FloatSeq(20);
    private static boolean building;
    private static float circlePrecision;

    public static void setCirclePrecision(float amount) {
        circlePrecision = amount;
    }

    public static int circleVertices(float rad) {
        return 11 + (int)(rad * circlePrecision);
    }

    public static void lineAngle(float x, float y, float angle, float length, boolean cap) {
        vector.set(1.0f, 1.0f).setLength(length).setAngle(angle);
        Lines.line(x, y, x + Lines.vector.x, y + Lines.vector.y, cap);
    }

    public static void lineAngle(float x, float y, float angle, float length) {
        vector.set(1.0f, 1.0f).setLength(length).setAngle(angle);
        Lines.line(x, y, x + Lines.vector.x, y + Lines.vector.y);
    }

    public static void lineAngle(float x, float y, float offset, float angle, float length) {
        vector.set(1.0f, 1.0f).setLength(length + offset).setAngle(angle);
        Lines.line(x, y, x + Lines.vector.x, y + Lines.vector.y);
    }

    public static void lineAngleCenter(float x, float y, float angle, float length) {
        vector.trns(angle, length);
        Lines.line(x - Lines.vector.x / 2.0f, y - Lines.vector.y / 2.0f, x + Lines.vector.x / 2.0f, y + Lines.vector.y / 2.0f);
    }

    public static void line(float x, float y, float x2, float y2) {
        Lines.line(x, y, x2, y2, true);
    }

    public static void line(float x, float y, float x2, float y2, boolean cap) {
        Lines.line(Core.atlas.white(), x, y, x2, y2, cap);
    }

    public static void line(TextureRegion region, float x, float y, float x2, float y2, boolean cap) {
        if (useLegacyLine) {
            float length = Mathf.dst(x, y, x2, y2) + (!cap ? 0.0f : stroke);
            float angle = Mathf.atan2(x2 - x, y2 - y) * 57.295776f;
            if (cap) {
                Draw.rect(region, x - stroke / 2.0f + length / 2.0f, y, length, stroke, stroke / 2.0f, stroke / 2.0f, angle);
            } else {
                Draw.rect(region, x + length / 2.0f, y, length, stroke, 0.0f, stroke / 2.0f, angle);
            }
        } else {
            float hstroke = stroke / 2.0f;
            float len = Mathf.len(x2 - x, y2 - y);
            float diffx = (x2 - x) / len * hstroke;
            float diffy = (y2 - y) / len * hstroke;
            if (cap) {
                Fill.quad(region, x - diffx - diffy, y - diffy + diffx, x - diffx + diffy, y - diffy - diffx, x2 + diffx + diffy, y2 + diffy - diffx, x2 + diffx - diffy, y2 + diffy + diffx);
            } else {
                Fill.quad(region, x - diffy, y + diffx, x + diffy, y - diffx, x2 + diffy, y2 - diffx, x2 - diffy, y2 + diffx);
            }
        }
    }

    public static void linePoint(Position p) {
        Lines.linePoint(p.getX(), p.getY());
    }

    public static void linePoint(float x, float y) {
        if (!building) {
            throw new IllegalStateException("Not building");
        }
        floatBuilder.add(x, y);
    }

    public static void beginLine() {
        if (building) {
            throw new IllegalStateException("Already building");
        }
        floatBuilder.clear();
        building = true;
    }

    public static void endLine() {
        Lines.endLine(false);
    }

    public static void endLine(boolean wrap) {
        if (!building) {
            throw new IllegalStateException("Not building");
        }
        Lines.polyline(floatBuilder, wrap);
        building = false;
    }

    public static void polyline(FloatSeq points, boolean wrap) {
        Lines.polyline(points.items, points.size, wrap);
    }

    public static void polyline(float[] points, int length, boolean wrap) {
        if (length < 4) {
            return;
        }
        if (!wrap) {
            for (int i = 0; i < length - 2; i += 2) {
                float cx = points[i];
                float cy = points[i + 1];
                float cx2 = points[i + 2];
                float cy2 = points[i + 3];
                Lines.line(cx, cy, cx2, cy2);
            }
        } else {
            int i;
            floats.clear();
            for (i = 0; i < length; i += 2) {
                float x0 = points[Mathf.mod(i - 2, length)];
                float y0 = points[Mathf.mod(i - 1, length)];
                float x1 = points[i];
                float y1 = points[i + 1];
                float x2 = points[(i + 2) % length];
                float y2 = points[(i + 3) % length];
                float ang0 = Angles.angle(x0, y0, x1, y1);
                float ang1 = Angles.angle(x1, y1, x2, y2);
                float beta = Mathf.sinDeg(ang1 - ang0);
                u.set(x0, y0).sub(x1, y1).scl(1.0f / Mathf.dst(x0, y0, x1, y1)).scl(stroke / (2.0f * beta));
                v.set(x2, y2).sub(x1, y1).scl(1.0f / Mathf.dst(x2, y2, x1, y1)).scl(stroke / (2.0f * beta));
                inner.set(x1, y1).add(u).add(v);
                outer.set(x1, y1).sub(u).sub(v);
                floats.add(Lines.inner.x, Lines.inner.y, Lines.outer.x, Lines.outer.y);
            }
            for (i = 0; i < Lines.floats.size; i += 4) {
                float x1 = Lines.floats.items[i];
                float y1 = Lines.floats.items[i + 1];
                float x2 = Lines.floats.items[(i + 2) % Lines.floats.size];
                float y2 = Lines.floats.items[(i + 3) % Lines.floats.size];
                float x3 = Lines.floats.items[(i + 4) % Lines.floats.size];
                float y3 = Lines.floats.items[(i + 5) % Lines.floats.size];
                float x4 = Lines.floats.items[(i + 6) % Lines.floats.size];
                float y4 = Lines.floats.items[(i + 7) % Lines.floats.size];
                Fill.quad(x1, y1, x3, y3, x4, y4, x2, y2);
            }
        }
    }

    public static void dashLine(float x1, float y1, float x2, float y2, int divisions) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        for (int i = 0; i < divisions; ++i) {
            if (i % 2 != 0) continue;
            Lines.line(x1 + (float)i / (float)divisions * dx, y1 + (float)i / (float)divisions * dy, x1 + ((float)i + 1.0f) / (float)divisions * dx, y1 + ((float)i + 1.0f) / (float)divisions * dy);
        }
    }

    public static void circle(float x, float y, float rad) {
        Lines.poly(x, y, Lines.circleVertices(rad), rad);
    }

    public static void dashCircle(float x, float y, float radius) {
        float scaleFactor = 0.6f;
        int sides = 10 + (int)(radius * scaleFactor);
        if (sides % 2 == 1) {
            ++sides;
        }
        vector.set(0.0f, 0.0f);
        for (int i = 0; i < sides; ++i) {
            if (i % 2 == 0) continue;
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)i + 90.0f);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)(i + 1) + 90.0f);
            Lines.line(x1 + x, y1 + y, Lines.vector.x + x, Lines.vector.y + y);
        }
    }

    public static void spikes(float x, float y, float radius, float length, int spikes, float rot) {
        vector.set(0.0f, 1.0f);
        float step = 360.0f / (float)spikes;
        for (int i = 0; i < spikes; ++i) {
            vector.setAngle((float)i * step + rot);
            vector.setLength(radius);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.setLength(radius + length);
            Lines.line(x + x1, y + y1, x + Lines.vector.x, y + Lines.vector.y);
        }
    }

    public static void spikes(float x, float y, float rad, float length, int spikes) {
        Lines.spikes(x, y, rad, length, spikes, 0.0f);
    }

    public static void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        floatBuilder.clear();
        floatBuilder.add(x1, y1, x2, y2);
        floatBuilder.add(x3, y3, x4, y4);
        Lines.polyline(floatBuilder, true);
    }

    public static void poly(float x, float y, int sides, float radius, float angle) {
        float space = 360.0f / (float)sides;
        float hstep = stroke / 2.0f / Mathf.cosDeg(space / 2.0f);
        float r1 = radius - hstep;
        float r2 = radius + hstep;
        for (int i = 0; i < sides; ++i) {
            float a = space * (float)i + angle;
            float cos = Mathf.cosDeg(a);
            float sin = Mathf.sinDeg(a);
            float cos2 = Mathf.cosDeg(a + space);
            float sin2 = Mathf.sinDeg(a + space);
            Fill.quad(x + r1 * cos, y + r1 * sin, x + r1 * cos2, y + r1 * sin2, x + r2 * cos2, y + r2 * sin2, x + r2 * cos, y + r2 * sin);
        }
    }

    public static void poly(float x, float y, int sides, float radius) {
        Lines.poly(x, y, sides, radius, 0.0f);
    }

    public static void poly(Vec2[] vertices, float offsetx, float offsety, float scl) {
        for (int i = 0; i < vertices.length; ++i) {
            Vec2 current = vertices[i];
            Vec2 next = i == vertices.length - 1 ? vertices[0] : vertices[i + 1];
            Lines.line(current.x * scl + offsetx, current.y * scl + offsety, next.x * scl + offsetx, next.y * scl + offsety);
        }
    }

    public static void polySeg(int sides, int from, int to, float x, float y, float radius, float angle) {
        vector.set(0.0f, 0.0f);
        for (int i = from; i < to; ++i) {
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)i + angle + 90.0f);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)(i + 1) + angle + 90.0f);
            Lines.line(x1 + x, y1 + y, Lines.vector.x + x, Lines.vector.y + y);
        }
    }

    public static void curve(float x1, float y1, float cx1, float cy1, float cx2, float cy2, float x2, float y2, int segments) {
        float subdiv_step = 1.0f / (float)segments;
        float subdiv_step2 = subdiv_step * subdiv_step;
        float subdiv_step3 = subdiv_step * subdiv_step * subdiv_step;
        float pre1 = 3.0f * subdiv_step;
        float pre2 = 3.0f * subdiv_step2;
        float pre4 = 6.0f * subdiv_step2;
        float pre5 = 6.0f * subdiv_step3;
        float tmp1x = x1 - cx1 * 2.0f + cx2;
        float tmp1y = y1 - cy1 * 2.0f + cy2;
        float tmp2x = (cx1 - cx2) * 3.0f - x1 + x2;
        float tmp2y = (cy1 - cy2) * 3.0f - y1 + y2;
        float fx = x1;
        float fy = y1;
        float dfx = (cx1 - x1) * pre1 + tmp1x * pre2 + tmp2x * subdiv_step3;
        float dfy = (cy1 - y1) * pre1 + tmp1y * pre2 + tmp2y * subdiv_step3;
        float ddfx = tmp1x * pre4 + tmp2x * pre5;
        float ddfy = tmp1y * pre4 + tmp2y * pre5;
        float dddfx = tmp2x * pre5;
        float dddfy = tmp2y * pre5;
        while (segments-- > 0) {
            float fxold = fx;
            float fyold = fy;
            dfx += ddfx;
            ddfx += dddfx;
            ddfy += dddfy;
            Lines.line(fxold, fyold, fx += dfx, fy += (dfy += ddfy));
        }
        Lines.line(fx, fy, x2, y2);
    }

    public static void swirl(float x, float y, float radius, float finion) {
        Lines.swirl(x, y, radius, finion, 0.0f);
    }

    public static void swirl(float x, float y, float radius, float finion, float angle) {
        int sides = 50;
        int max = (int)((float)sides * (finion + 0.001f));
        vector.set(0.0f, 0.0f);
        floats.clear();
        for (int i = 0; i < max; ++i) {
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)i + angle);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)(i + 1) + angle);
            floats.add(x1 + x, y1 + y);
        }
        Lines.polyline(floats, false);
    }

    public static void square(float x, float y, float rad) {
        Lines.rect(x - rad, y - rad, rad * 2.0f, rad * 2.0f);
    }

    public static void square(float x, float y, float rad, float rot) {
        Lines.poly(x, y, 4, rad, rot - 45.0f);
    }

    public static void rect(float x, float y, float width, float height, float xspace, float yspace) {
        Fill.crect(x -= xspace, y -= yspace, width += xspace * 2.0f, stroke);
        Fill.crect(x, y + (height += yspace * 2.0f), width, -stroke);
        Fill.crect(x + width, y, -stroke, height);
        Fill.crect(x, y, stroke, height);
    }

    public static void rect(float x, float y, float width, float height) {
        Lines.rect(x, y, width, height, 0);
    }

    public static void rect(Rect rect) {
        Lines.rect(rect.x, rect.y, rect.width, rect.height, 0);
    }

    public static void rect(float x, float y, float width, float height, int space) {
        Lines.rect(x, y, width, height, space, space);
    }

    public static void stroke(float thick) {
        stroke = thick;
    }

    public static void stroke(float thick, Color color) {
        stroke = thick;
        Draw.color(color);
    }

    public static float getStroke() {
        return stroke;
    }

    static {
        circlePrecision = 0.4f;
    }
}

