/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Batch;
import arc.graphics.g2d.SpriteCache;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.math.Mat;
import arc.struct.Seq;
import arc.util.Pack;

public class MultiCacheBatch
extends Batch {
    private static final int maxSpritesPerCache = 102000;
    Seq<SpriteCache> caches = new Seq();
    Shader shader = SpriteCache.createDefaultShader();
    int currentid = -1;
    int maxCacheSize;
    int offset;
    boolean recaching = false;

    public MultiCacheBatch(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    SpriteCache currentCache() {
        int needed;
        int n = needed = this.currentid == -1 ? this.offset / 102000 : this.currentid;
        if (needed >= this.caches.size) {
            this.caches.add(new SpriteCache(102000, 16, this.shader, false));
        }
        return this.caches.get(needed);
    }

    @Override
    public void flush() {
    }

    @Override
    public void setColor(Color tint) {
        this.currentCache().setColor(tint);
    }

    @Override
    public void setColor(float r, float g, float b, float a) {
        this.currentCache().setColor(r, g, b, a);
    }

    @Override
    public void setPackedColor(float color) {
        this.currentCache().setPackedColor(color);
    }

    @Override
    public Color getColor() {
        return this.currentCache().getColor();
    }

    @Override
    public float getPackedColor() {
        return this.currentCache().getPackedColor();
    }

    @Override
    public void setProjection(Mat projection) {
        this.currentid = 0;
        this.currentCache().setProjectionMatrix(projection);
    }

    public void reserve(int amount) {
        this.offset += this.currentCache().reserve(amount);
    }

    public void beginCache(int id) {
        short cacheID = Pack.leftShort(id);
        short batch = Pack.rightShort(id);
        this.caches.get(batch).beginCache(cacheID);
        this.currentid = batch;
        this.recaching = true;
    }

    public void beginCache() {
        this.currentid = this.offset / 102000;
        if (this.currentid < (this.offset + this.maxCacheSize) / 102000) {
            this.offset += this.maxCacheSize - this.offset % this.maxCacheSize + 2;
            this.currentid = this.offset / 102000;
        }
        this.currentCache().beginCache();
        this.recaching = false;
    }

    public int endCache() {
        int id = Pack.shortInt((short)this.currentCache().endCache(), (short)this.currentid);
        this.currentid = -1;
        this.recaching = false;
        return id;
    }

    @Override
    protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
    }

    @Override
    protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        this.currentCache().add(region, x, y, originX, originY, width, height, 1.0f, 1.0f, rotation);
        if (!this.recaching) {
            ++this.offset;
        }
    }

    @Override
    public void setShader(Shader shader, boolean apply) {
        boolean drawing = this.currentCache().isDrawing();
        if (drawing) {
            this.currentCache().end();
        }
        this.currentCache().setShader(shader);
        if (drawing) {
            this.currentCache().begin();
        }
        if (apply && shader != null) {
            shader.apply();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SpriteCache cache : this.caches) {
            cache.dispose();
        }
        this.shader.dispose();
    }

    public void beginDraw() {
        this.currentid = 0;
        this.currentCache().begin();
    }

    public void endDraw() {
        this.currentCache().end();
        this.currentid = -1;
    }

    public void drawCache(int id) {
        short cacheID = Pack.leftShort(id);
        short batch = Pack.rightShort(id);
        if (this.currentid != batch) {
            SpriteCache prev = this.currentCache();
            prev.end();
            this.currentid = batch;
            this.currentCache().setProjectionMatrix(prev.getProjectionMatrix());
            this.currentCache().begin();
        }
        this.currentCache().draw(cacheID);
    }
}

