/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.graphics.Blending;
import arc.graphics.Texture;
import arc.graphics.g2d.DrawRequest;
import arc.graphics.g2d.SpriteBatch;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.struct.Seq;

public class SortedSpriteBatch
extends SpriteBatch {
    protected Seq<DrawRequest> requestPool = new Seq(10000);
    protected Seq<DrawRequest> requests = new Seq(DrawRequest.class);
    protected boolean sort;
    protected boolean flushing;

    @Override
    protected void setSort(boolean sort) {
        if (this.sort != sort) {
            this.flush();
        }
        this.sort = sort;
    }

    @Override
    protected void setShader(Shader shader, boolean apply) {
        if (!this.flushing && this.sort) {
            throw new IllegalArgumentException("Shaders cannot be set while sorting is enabled. Set shaders inside Draw.run(...).");
        }
        super.setShader(shader, apply);
    }

    @Override
    protected void setBlending(Blending blending) {
        this.blending = blending;
    }

    @Override
    protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        if (this.sort && !this.flushing) {
            for (int i = offset; i < count; i += 24) {
                DrawRequest req = this.obtain();
                req.z = this.z;
                System.arraycopy(spriteVertices, i, req.vertices, 0, req.vertices.length);
                req.texture = texture;
                req.blending = this.blending;
                req.run = null;
                this.requests.add(req);
            }
        } else {
            super.draw(texture, spriteVertices, offset, count);
        }
    }

    @Override
    protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        if (this.sort && !this.flushing) {
            DrawRequest req = this.obtain();
            req.x = x;
            req.y = y;
            req.z = this.z;
            req.originX = originX;
            req.originY = originY;
            req.width = width;
            req.height = height;
            req.color = this.colorPacked;
            req.rotation = rotation;
            req.region.set(region);
            req.mixColor = this.mixColorPacked;
            req.blending = this.blending;
            req.texture = null;
            req.run = null;
            this.requests.add(req);
        } else {
            super.draw(region, x, y, originX, originY, width, height, rotation);
        }
    }

    @Override
    protected void draw(Runnable request) {
        if (this.sort && !this.flushing) {
            DrawRequest req = this.obtain();
            req.run = request;
            req.blending = this.blending;
            req.mixColor = this.mixColorPacked;
            req.color = this.colorPacked;
            req.z = this.z;
            req.texture = null;
            this.requests.add(req);
        } else {
            super.draw(request);
        }
    }

    protected DrawRequest obtain() {
        return this.requestPool.size > 0 ? this.requestPool.pop() : new DrawRequest();
    }

    @Override
    protected void flush() {
        this.flushRequests();
        super.flush();
    }

    protected void flushRequests() {
        if (!this.flushing && !this.requests.isEmpty()) {
            this.flushing = true;
            this.sortRequests();
            float preColor = this.colorPacked;
            float preMixColor = this.mixColorPacked;
            Blending preBlending = this.blending;
            for (int j = 0; j < this.requests.size; ++j) {
                DrawRequest req = ((DrawRequest[])this.requests.items)[j];
                this.colorPacked = req.color;
                this.mixColorPacked = req.mixColor;
                super.setBlending(req.blending);
                if (req.run != null) {
                    req.run.run();
                    continue;
                }
                if (req.texture != null) {
                    super.draw(req.texture, req.vertices, 0, req.vertices.length);
                    continue;
                }
                super.draw(req.region, req.x, req.y, req.originX, req.originY, req.width, req.height, req.rotation);
            }
            this.colorPacked = preColor;
            this.mixColorPacked = preMixColor;
            this.color.abgr8888(this.colorPacked);
            this.mixColor.abgr8888(this.mixColorPacked);
            this.blending = preBlending;
            this.requestPool.addAll(this.requests);
            this.requests.size = 0;
            this.flushing = false;
        }
    }

    protected void sortRequests() {
        this.requests.sort();
    }
}

