/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.Texture;
import arc.graphics.VertexAttribute;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.math.Mat;
import arc.math.Mathf;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Disposable;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class SpriteCache
implements Disposable {
    static final int VERTEX_SIZE = 5;
    private static final float[] tempVertices = new float[30];
    private final Mesh mesh;
    private final Mat transformMatrix = new Mat();
    private final Mat projectionMatrix = new Mat();
    private final Mat combinedMatrix = new Mat();
    private final Shader shader;
    private final Seq<Texture> textures = new Seq(8);
    private final IntSeq counts = new IntSeq(8);
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public int renderCalls = 0;
    public int totalRenderCalls = 0;
    private boolean drawing;
    private Seq<Cache> caches;
    private Cache currentCache;
    private float colorPacked = Color.whiteFloatBits;
    private Shader customShader = null;

    public SpriteCache() {
        this(1000, false);
    }

    public SpriteCache(int size, boolean useIndices) {
        this(size, 16, SpriteCache.createDefaultShader(), useIndices);
    }

    public SpriteCache(int size, int cacheSize, boolean useIndices) {
        this(size, cacheSize, SpriteCache.createDefaultShader(), useIndices);
    }

    public SpriteCache(int size, int cacheSize, Shader shader, boolean useIndices) {
        this.shader = shader;
        if (useIndices && size > 8191) {
            throw new IllegalArgumentException("Can't have more than 8191 sprites per batch: " + size);
        }
        this.mesh = new Mesh(true, size * (useIndices ? 4 : 6), useIndices ? size * 6 : 0, VertexAttribute.position, VertexAttribute.color, VertexAttribute.texCoords);
        this.mesh.setAutoBind(false);
        this.caches = new Seq(cacheSize);
        if (useIndices) {
            int length = size * 6;
            short[] indices = new short[length];
            short j = 0;
            int i = 0;
            while (i < length) {
                indices[i] = j;
                indices[i + 1] = (short)(j + 1);
                indices[i + 2] = (short)(j + 2);
                indices[i + 3] = (short)(j + 2);
                indices[i + 4] = (short)(j + 3);
                indices[i + 5] = j;
                i += 6;
                j = (short)(j + 4);
            }
            this.mesh.setIndices(indices);
        }
        this.projectionMatrix.setOrtho(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
    }

    public static Shader createDefaultShader() {
        String vertexShader = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projectionViewMatrix;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main(){\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projectionViewMatrix * a_position;\n}\n";
        String fragmentShader = "varying vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nvoid main(){\n  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}";
        return new Shader(vertexShader, fragmentShader);
    }

    public Seq<Cache> getCaches() {
        return this.caches;
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
        this.colorPacked = this.color.toFloatBits();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color tint) {
        this.color.set(tint);
        this.colorPacked = tint.toFloatBits();
    }

    public float getPackedColor() {
        return this.colorPacked;
    }

    public void setPackedColor(float packedColor) {
        this.color.abgr8888(packedColor);
        this.colorPacked = packedColor;
    }

    public void beginCache() {
        if (this.drawing) {
            throw new IllegalStateException("end must be called before beginCache");
        }
        if (this.currentCache != null) {
            throw new IllegalStateException("endCache must be called before begin.");
        }
        this.mesh.getVerticesBuffer().position(this.caches.isEmpty() ? 0 : this.caches.peek().offset + this.caches.peek().maxCount);
        this.currentCache = new Cache(this.caches.size, this.mesh.getVerticesBuffer().position());
        this.caches.add(this.currentCache);
        this.mesh.getVerticesBuffer().limit(this.mesh.getVerticesBuffer().capacity());
    }

    public void beginCache(int cacheID) {
        if (this.drawing) {
            throw new IllegalStateException("end must be called before beginCache");
        }
        if (this.currentCache != null) {
            throw new IllegalStateException("endCache must be called before begin.");
        }
        this.currentCache = this.caches.get(cacheID);
        Arrays.fill(this.currentCache.counts, 0);
        this.mesh.getVerticesBuffer().position(this.currentCache.offset);
    }

    public int endCache() {
        if (this.currentCache == null) {
            throw new IllegalStateException("beginCache must be called before endCache.");
        }
        Cache cache = this.currentCache;
        int cacheCount = this.mesh.getVerticesBuffer().position() - cache.offset;
        if (cache.textures == null) {
            cache.maxCount = cacheCount;
            cache.textureCount = this.textures.size;
            cache.textures = (Texture[])this.textures.toArray(Texture.class);
            cache.counts = new int[cache.textureCount];
            int n = this.counts.size;
            for (int i = 0; i < n; ++i) {
                cache.counts[i] = this.counts.get(i);
            }
        } else {
            int i;
            if (cacheCount > cache.maxCount) {
                throw new ArcRuntimeException("If a cache is not the last created, it cannot be redefined with more entries than when it was first created: " + cacheCount + " (" + cache.maxCount + " max)");
            }
            cache.textureCount = this.textures.size;
            if (cache.textures.length < cache.textureCount) {
                cache.textures = new Texture[cache.textureCount];
            }
            int n = cache.textureCount;
            for (i = 0; i < n; ++i) {
                cache.textures[i] = this.textures.get(i);
            }
            if (cache.counts.length < cache.textureCount) {
                cache.counts = new int[cache.textureCount];
            }
            n = cache.textureCount;
            for (i = 0; i < n; ++i) {
                cache.counts[i] = this.counts.get(i);
            }
            FloatBuffer vertices = this.mesh.getVerticesBuffer();
            vertices.position(0);
            Cache lastCache = this.caches.get(this.caches.size - 1);
            vertices.limit(lastCache.offset + lastCache.maxCount);
        }
        this.currentCache = null;
        this.textures.clear();
        this.counts.clear();
        if (Core.app.isWeb()) {
            this.mesh.getVerticesBuffer().position(0);
        }
        return cache.id;
    }

    public void clear() {
        this.caches.clear();
        this.mesh.getVerticesBuffer().clear().flip();
    }

    public int reserve(int sprites) {
        int currentUsed;
        if (this.currentCache == null) {
            throw new IllegalStateException("beginCache must be called before ensureSize.");
        }
        int spriteSize = 5 * (this.mesh.getNumIndices() > 0 ? 4 : 6);
        int required = sprites * spriteSize;
        int toAdd = required - (currentUsed = this.currentCache.maxCount);
        if (toAdd > 0) {
            this.currentCache.maxCount += toAdd;
            this.mesh.getVerticesBuffer().position(this.currentCache.offset + this.currentCache.maxCount);
            return toAdd / spriteSize;
        }
        return 0;
    }

    public void add(Texture texture, float[] vertices, int offset, int length) {
        if (this.currentCache == null) {
            throw new IllegalStateException("beginCache must be called before add.");
        }
        if (this.mesh.getVerticesBuffer().position() + length >= this.mesh.getVerticesBuffer().limit()) {
            throw new IllegalStateException("Out of vertex space! Size: " + this.mesh.getVerticesBuffer().capacity() + " Required: " + (this.mesh.getVerticesBuffer().position() + length));
        }
        int verticesPerImage = this.mesh.getNumIndices() > 0 ? 4 : 6;
        int count = length / (verticesPerImage * 5) * 6;
        int lastIndex = this.textures.size - 1;
        if (lastIndex < 0 || this.textures.get(lastIndex) != texture) {
            this.textures.add(texture);
            this.counts.add(count);
        } else {
            this.counts.incr(lastIndex, count);
        }
        this.mesh.getVerticesBuffer().put(vertices, offset, length);
    }

    public void add(TextureRegion region, float x, float y) {
        this.add(region, x, y, region.width, region.height);
    }

    public void add(TextureRegion region, float x, float y, float width, float height) {
        float fx2 = x + width;
        float fy2 = y + height;
        float u = region.u;
        float v = region.v2;
        float u2 = region.u2;
        float v2 = region.v;
        SpriteCache.tempVertices[0] = x;
        SpriteCache.tempVertices[1] = y;
        SpriteCache.tempVertices[2] = this.colorPacked;
        SpriteCache.tempVertices[3] = u;
        SpriteCache.tempVertices[4] = v;
        SpriteCache.tempVertices[5] = x;
        SpriteCache.tempVertices[6] = fy2;
        SpriteCache.tempVertices[7] = this.colorPacked;
        SpriteCache.tempVertices[8] = u;
        SpriteCache.tempVertices[9] = v2;
        SpriteCache.tempVertices[10] = fx2;
        SpriteCache.tempVertices[11] = fy2;
        SpriteCache.tempVertices[12] = this.colorPacked;
        SpriteCache.tempVertices[13] = u2;
        SpriteCache.tempVertices[14] = v2;
        if (this.mesh.getNumIndices() > 0) {
            SpriteCache.tempVertices[15] = fx2;
            SpriteCache.tempVertices[16] = y;
            SpriteCache.tempVertices[17] = this.colorPacked;
            SpriteCache.tempVertices[18] = u2;
            SpriteCache.tempVertices[19] = v;
            this.add(region.texture, tempVertices, 0, 20);
        } else {
            SpriteCache.tempVertices[15] = fx2;
            SpriteCache.tempVertices[16] = fy2;
            SpriteCache.tempVertices[17] = this.colorPacked;
            SpriteCache.tempVertices[18] = u2;
            SpriteCache.tempVertices[19] = v2;
            SpriteCache.tempVertices[20] = fx2;
            SpriteCache.tempVertices[21] = y;
            SpriteCache.tempVertices[22] = this.colorPacked;
            SpriteCache.tempVertices[23] = u2;
            SpriteCache.tempVertices[24] = v;
            SpriteCache.tempVertices[25] = x;
            SpriteCache.tempVertices[26] = y;
            SpriteCache.tempVertices[27] = this.colorPacked;
            SpriteCache.tempVertices[28] = u;
            SpriteCache.tempVertices[29] = v;
            this.add(region.texture, tempVertices, 0, 30);
        }
    }

    public void add(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        float y4;
        float x4;
        float y3;
        float x3;
        float y2;
        float x2;
        float y1;
        float x1;
        float worldOriginX = x + originX;
        float worldOriginY = y + originY;
        float fx = -originX;
        float fy = -originY;
        float fx2 = width - originX;
        float fy2 = height - originY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            fx *= scaleX;
            fy *= scaleY;
            fx2 *= scaleX;
            fy2 *= scaleY;
        }
        float p1x = fx;
        float p1y = fy;
        float p2x = fx;
        float p2y = fy2;
        float p3x = fx2;
        float p3y = fy2;
        float p4x = fx2;
        float p4y = fy;
        if (rotation != 0.0f) {
            float cos = Mathf.cosDeg(rotation);
            float sin = Mathf.sinDeg(rotation);
            x1 = cos * p1x - sin * p1y;
            y1 = sin * p1x + cos * p1y;
            x2 = cos * p2x - sin * p2y;
            y2 = sin * p2x + cos * p2y;
            x3 = cos * p3x - sin * p3y;
            y3 = sin * p3x + cos * p3y;
            x4 = x1 + (x3 - x2);
            y4 = y3 - (y2 - y1);
        } else {
            x1 = p1x;
            y1 = p1y;
            x2 = p2x;
            y2 = p2y;
            x3 = p3x;
            y3 = p3y;
            x4 = p4x;
            y4 = p4y;
        }
        x1 += worldOriginX;
        y1 += worldOriginY;
        x2 += worldOriginX;
        y2 += worldOriginY;
        x3 += worldOriginX;
        y3 += worldOriginY;
        x4 += worldOriginX;
        y4 += worldOriginY;
        float u = region.u;
        float v = region.v2;
        float u2 = region.u2;
        float v2 = region.v;
        SpriteCache.tempVertices[0] = x1;
        SpriteCache.tempVertices[1] = y1;
        SpriteCache.tempVertices[2] = this.colorPacked;
        SpriteCache.tempVertices[3] = u;
        SpriteCache.tempVertices[4] = v;
        SpriteCache.tempVertices[5] = x2;
        SpriteCache.tempVertices[6] = y2;
        SpriteCache.tempVertices[7] = this.colorPacked;
        SpriteCache.tempVertices[8] = u;
        SpriteCache.tempVertices[9] = v2;
        SpriteCache.tempVertices[10] = x3;
        SpriteCache.tempVertices[11] = y3;
        SpriteCache.tempVertices[12] = this.colorPacked;
        SpriteCache.tempVertices[13] = u2;
        SpriteCache.tempVertices[14] = v2;
        if (this.mesh.getNumIndices() > 0) {
            SpriteCache.tempVertices[15] = x4;
            SpriteCache.tempVertices[16] = y4;
            SpriteCache.tempVertices[17] = this.colorPacked;
            SpriteCache.tempVertices[18] = u2;
            SpriteCache.tempVertices[19] = v;
            this.add(region.texture, tempVertices, 0, 20);
        } else {
            SpriteCache.tempVertices[15] = x3;
            SpriteCache.tempVertices[16] = y3;
            SpriteCache.tempVertices[17] = this.colorPacked;
            SpriteCache.tempVertices[18] = u2;
            SpriteCache.tempVertices[19] = v2;
            SpriteCache.tempVertices[20] = x4;
            SpriteCache.tempVertices[21] = y4;
            SpriteCache.tempVertices[22] = this.colorPacked;
            SpriteCache.tempVertices[23] = u2;
            SpriteCache.tempVertices[24] = v;
            SpriteCache.tempVertices[25] = x1;
            SpriteCache.tempVertices[26] = y1;
            SpriteCache.tempVertices[27] = this.colorPacked;
            SpriteCache.tempVertices[28] = u;
            SpriteCache.tempVertices[29] = v;
            this.add(region.texture, tempVertices, 0, 30);
        }
    }

    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("end must be called before begin.");
        }
        if (this.currentCache != null) {
            throw new IllegalStateException("endCache must be called before begin");
        }
        this.renderCalls = 0;
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        Shader shader = this.customShader != null ? this.customShader : this.shader;
        shader.bind();
        shader.setUniformMatrix4("u_projectionViewMatrix", this.combinedMatrix);
        shader.setUniformi("u_texture", 0);
        this.mesh.bind(shader);
        this.drawing = true;
    }

    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before end.");
        }
        this.drawing = false;
        Gl.depthMask(true);
        if (this.customShader != null) {
            this.mesh.unbind(this.customShader);
        } else {
            this.mesh.unbind(this.shader);
        }
    }

    public void draw(int cacheID) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteCache.begin must be called before draw.");
        }
        Cache cache = this.caches.get(cacheID);
        int verticesPerImage = this.mesh.getNumIndices() > 0 ? 4 : 6;
        int offset = cache.offset / (verticesPerImage * 5) * 6;
        Texture[] textures = cache.textures;
        int[] counts = cache.counts;
        int textureCount = cache.textureCount;
        Shader shader = this.customShader != null ? this.customShader : this.shader;
        for (int i = 0; i < textureCount; ++i) {
            int count = counts[i];
            textures[i].bind();
            this.mesh.render(shader, 4, offset, count);
            offset += count;
        }
        this.renderCalls += textureCount;
        this.totalRenderCalls += textureCount;
    }

    public void draw(int cacheID, int offset, int length) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteCache.begin must be called before draw.");
        }
        Cache cache = this.caches.get(cacheID);
        offset = offset * 6 + cache.offset;
        length *= 6;
        Texture[] textures = cache.textures;
        int[] counts = cache.counts;
        int textureCount = cache.textureCount;
        for (int i = 0; i < textureCount; ++i) {
            textures[i].bind();
            int count = counts[i];
            if (count > length) {
                i = textureCount;
                count = length;
            } else {
                length -= count;
            }
            if (this.customShader != null) {
                this.mesh.render(this.customShader, 4, offset, count);
            } else {
                this.mesh.render(this.shader, 4, offset, count);
            }
            offset += count;
        }
        this.renderCalls += cache.textureCount;
        this.totalRenderCalls += textureCount;
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        if (this.shader != null) {
            this.shader.dispose();
        }
    }

    public Mat getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public void setProjectionMatrix(Mat projection) {
        if (this.drawing) {
            throw new IllegalStateException("Can't set the matrix within begin/end.");
        }
        this.projectionMatrix.set(projection);
    }

    public Mat getTransformMatrix() {
        return this.transformMatrix;
    }

    public void setTransformMatrix(Mat transform) {
        if (this.drawing) {
            throw new IllegalStateException("Can't set the matrix within begin/end.");
        }
        this.transformMatrix.set(transform);
    }

    public void setShader(Shader shader) {
        this.customShader = shader;
    }

    public boolean isDrawing() {
        return this.drawing;
    }

    private static class Cache {
        final int id;
        final int offset;
        int maxCount;
        int textureCount;
        Texture[] textures;
        int[] counts;

        public Cache(int id, int offset) {
            this.id = id;
            this.offset = offset;
        }
    }
}

