/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.files.Fi;
import arc.func.Prov;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.NinePatch;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.BaseDrawable;
import arc.scene.style.Drawable;
import arc.scene.style.ScaledNinePatchDrawable;
import arc.scene.style.TextureRegionDrawable;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Disposable;
import arc.util.io.Streams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Comparator;

public class TextureAtlas
implements Disposable {
    static final String[] tuple = new String[4];
    static final Comparator<TextureAtlasData.Region> indexComparator = (region1, region2) -> {
        int i2;
        int i1 = region1.index;
        if (i1 == -1) {
            i1 = Integer.MAX_VALUE;
        }
        if ((i2 = region2.index) == -1) {
            i2 = Integer.MAX_VALUE;
        }
        return i1 - i2;
    };
    private final ObjectSet<Texture> textures = new ObjectSet(4);
    private final Seq<AtlasRegion> regions = new Seq();
    private final ObjectMap<String, Drawable> drawables = new ObjectMap();
    private final ObjectMap<String, AtlasRegion> regionmap = new ObjectMap();
    private final ObjectMap<Texture, Pixmap> pixmaps = new ObjectMap();
    protected float drawableScale = 1.0f;
    protected AtlasRegion error;
    protected AtlasRegion white;

    public static TextureAtlas blankAtlas() {
        TextureAtlas a = new TextureAtlas();
        a.white = new AtlasRegion(Pixmaps.blankTextureRegion());
        return a;
    }

    public TextureAtlas() {
    }

    public TextureAtlas(String internalPackFile) {
        this(Core.files.internal(internalPackFile));
    }

    public TextureAtlas(Fi packFile) {
        this(packFile, packFile.parent());
    }

    public TextureAtlas(Fi packFile, boolean flip) {
        this(packFile, packFile.parent(), flip);
    }

    public TextureAtlas(Fi packFile, Fi imagesDir) {
        this(packFile, imagesDir, false);
    }

    public TextureAtlas(Fi packFile, Fi imagesDir, boolean flip) {
        this(new TextureAtlasData(packFile, imagesDir, flip));
    }

    public TextureAtlas(TextureAtlasData data) {
        if (data != null) {
            this.load(data);
        }
    }

    public void setDrawableScale(float scale) {
        this.drawableScale = scale;
    }

    static String readValue(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        int colon = line.indexOf(58);
        if (colon == -1) {
            throw new ArcRuntimeException("Invalid line: " + line);
        }
        return line.substring(colon + 1).trim();
    }

    static int readTuple(BufferedReader reader) throws IOException {
        int comma;
        String line = reader.readLine();
        int colon = line.indexOf(58);
        if (colon == -1) {
            throw new ArcRuntimeException("Invalid line: " + line);
        }
        int i = 0;
        int lastMatch = colon + 1;
        for (i = 0; i < 3 && (comma = line.indexOf(44, lastMatch)) != -1; ++i) {
            TextureAtlas.tuple[i] = line.substring(lastMatch, comma).trim();
            lastMatch = comma + 1;
        }
        TextureAtlas.tuple[i] = line.substring(lastMatch).trim();
        return i + 1;
    }

    private void load(TextureAtlasData data) {
        ObjectMap<TextureAtlasData.AtlasPage, Texture> pageToTexture = new ObjectMap<TextureAtlasData.AtlasPage, Texture>();
        for (TextureAtlasData.AtlasPage page : data.pages) {
            Texture texture = null;
            if (page.texture == null) {
                texture = new Texture(page.textureFile, page.format, page.useMipMaps);
                texture.setFilter(page.minFilter, page.magFilter);
                texture.setWrap(page.uWrap, page.vWrap);
            } else {
                texture = page.texture;
                texture.setFilter(page.minFilter, page.magFilter);
                texture.setWrap(page.uWrap, page.vWrap);
            }
            this.textures.add(texture);
            pageToTexture.put(page, texture);
        }
        for (TextureAtlasData.Region region : data.regions) {
            int width = region.width;
            int height = region.height;
            AtlasRegion atlasRegion = new AtlasRegion((Texture)pageToTexture.get(region.page), region.left, region.top, region.rotate ? height : width, region.rotate ? width : height);
            atlasRegion.index = region.index;
            atlasRegion.name = region.name;
            atlasRegion.offsetX = region.offsetX;
            atlasRegion.offsetY = region.offsetY;
            atlasRegion.originalHeight = region.originalHeight;
            atlasRegion.originalWidth = region.originalWidth;
            atlasRegion.rotate = region.rotate;
            atlasRegion.splits = region.splits;
            atlasRegion.pads = region.pads;
            if (region.flip) {
                atlasRegion.flip(false, true);
            }
            this.regions.add(atlasRegion);
            this.regionmap.put(atlasRegion.name, atlasRegion);
        }
        this.error = this.find("error");
    }

    public PixmapRegion getPixmap(String name) {
        return this.getPixmap(this.find(name));
    }

    public PixmapRegion getPixmap(AtlasRegion region) {
        if (region.pixmapRegion == null) {
            Pixmap pix = (Pixmap)((Object)this.pixmaps.get(region.texture, (Pixmap)((Object)((Prov<Pixmap>)() -> region.texture.getTextureData().getPixmap()))));
            region.pixmapRegion = new PixmapRegion(pix, region.getX(), region.getY(), region.width, region.height);
        }
        return region.pixmapRegion;
    }

    public void disposePixmap(Texture texture) {
        if (this.pixmaps.containsKey(texture)) {
            this.pixmaps.get(texture).dispose();
            this.pixmaps.remove(texture);
        }
    }

    public PixmapRegion getPixmap(TextureRegion region) {
        return this.getPixmap((AtlasRegion)region);
    }

    public AtlasRegion addRegion(String name, Texture texture, int x, int y, int width, int height) {
        this.textures.add(texture);
        AtlasRegion region = new AtlasRegion(texture, x, y, width, height);
        region.name = name;
        region.originalWidth = width;
        region.originalHeight = height;
        region.index = -1;
        this.regions.add(region);
        this.regionmap.put(name, region);
        return region;
    }

    public AtlasRegion addRegion(String name, TextureRegion textureRegion) {
        return this.addRegion(name, textureRegion.texture, textureRegion.getX(), textureRegion.getY(), textureRegion.width, textureRegion.height);
    }

    public Seq<AtlasRegion> getRegions() {
        return this.regions;
    }

    public ObjectMap<String, AtlasRegion> getRegionMap() {
        return this.regionmap;
    }

    public AtlasRegion white() {
        if (this.white == null) {
            this.white = this.find("white");
        }
        return this.white;
    }

    public boolean setErrorRegion(String name) {
        if (this.error != null || !this.has(name)) {
            return false;
        }
        this.error = this.find(name);
        return true;
    }

    public boolean isFound(TextureRegion region) {
        return region != this.error;
    }

    public AtlasRegion find(String name) {
        AtlasRegion r = this.regionmap.get(name);
        if (r == null && this.error == null && !name.equals("error")) {
            throw new IllegalArgumentException("The region \"" + name + "\" does not exist!");
        }
        if (r == null) {
            return this.error;
        }
        return r;
    }

    public TextureRegion find(String name, String def) {
        return this.find(name, this.find(def));
    }

    public TextureRegion find(String name, TextureRegion def) {
        TextureRegion region = this.regionmap.get(name);
        return region == null || region == this.error ? def : region;
    }

    public boolean has(String s) {
        return this.regionmap.containsKey(s);
    }

    public <T extends Drawable> T getDrawable(String name) {
        return (T)this.drawable(name);
    }

    public Drawable drawable(String name) {
        if (this.drawables.containsKey(name)) {
            return this.drawables.get(name);
        }
        BaseDrawable out = null;
        if (this.has(name)) {
            AtlasRegion region = this.find(name);
            if (region.splits != null) {
                int[] splits = region.splits;
                NinePatch patch = new NinePatch((TextureRegion)region, splits[0], splits[1], splits[2], splits[3]);
                int[] pads = region.pads;
                if (pads != null) {
                    patch.setPadding(pads[0], pads[1], pads[2], pads[3]);
                }
                out = new ScaledNinePatchDrawable(patch, this.drawableScale);
            } else {
                out = new TextureRegionDrawable(region, this.drawableScale);
            }
        }
        if (this.error == null && out == null) {
            throw new IllegalArgumentException("No drawable '" + name + "' found.");
        }
        if (out == null) {
            out = new TextureRegionDrawable(this.error);
        }
        this.drawables.put(name, out);
        return out;
    }

    public Seq<AtlasRegion> findRegions(String name) {
        Seq<AtlasRegion> matched = new Seq<AtlasRegion>(AtlasRegion.class);
        int n = this.regions.size;
        for (int i = 0; i < n; ++i) {
            AtlasRegion region = this.regions.get(i);
            if (!region.name.equals(name)) continue;
            matched.add(new AtlasRegion(region));
        }
        return matched;
    }

    public NinePatch createPatch(String name) {
        int n = this.regions.size;
        for (int i = 0; i < n; ++i) {
            AtlasRegion region = this.regions.get(i);
            if (!region.name.equals(name)) continue;
            int[] splits = region.splits;
            if (splits == null) {
                throw new IllegalArgumentException("Region does not have ninepatch splits: " + name);
            }
            NinePatch patch = new NinePatch((TextureRegion)region, splits[0], splits[1], splits[2], splits[3]);
            if (region.pads != null) {
                patch.setPadding(region.pads[0], region.pads[1], region.pads[2], region.pads[3]);
            }
            return patch;
        }
        return null;
    }

    public ObjectSet<Texture> getTextures() {
        return this.textures;
    }

    public Texture texture() {
        return this.textures.first();
    }

    @Override
    public void dispose() {
        for (Texture texture : this.textures) {
            texture.dispose();
        }
        for (Pixmap pixmap : this.pixmaps.values()) {
            if (pixmap.isDisposed()) continue;
            pixmap.dispose();
        }
        this.textures.clear();
        this.pixmaps.clear();
    }

    public static class AtlasRegion
    extends TextureRegion {
        PixmapRegion pixmapRegion;
        public int index;
        public String name;
        public float offsetX;
        public float offsetY;
        public int packedWidth;
        public int packedHeight;
        public int originalWidth;
        public int originalHeight;
        public boolean rotate;
        public int[] splits;
        public int[] pads;

        public AtlasRegion(Texture texture, int x, int y, int width, int height) {
            super(texture, x, y, width, height);
            this.originalWidth = width;
            this.originalHeight = height;
            this.packedWidth = width;
            this.packedHeight = height;
        }

        public AtlasRegion() {
        }

        public AtlasRegion(AtlasRegion region) {
            this.set(region);
            this.index = region.index;
            this.name = region.name;
            this.offsetX = region.offsetX;
            this.offsetY = region.offsetY;
            this.packedWidth = region.packedWidth;
            this.packedHeight = region.packedHeight;
            this.originalWidth = region.originalWidth;
            this.originalHeight = region.originalHeight;
            this.rotate = region.rotate;
            this.splits = region.splits;
        }

        public AtlasRegion(TextureRegion region) {
            this.set(region);
            this.name = "unknown";
        }

        @Override
        public void flip(boolean x, boolean y) {
            super.flip(x, y);
            if (x) {
                this.offsetX = (float)this.originalWidth - this.offsetX - this.getRotatedPackedWidth();
            }
            if (y) {
                this.offsetY = (float)this.originalHeight - this.offsetY - this.getRotatedPackedHeight();
            }
        }

        public float getRotatedPackedWidth() {
            return this.rotate ? (float)this.packedHeight : (float)this.packedWidth;
        }

        public float getRotatedPackedHeight() {
            return this.rotate ? (float)this.packedWidth : (float)this.packedHeight;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static class TextureAtlasData {
        final Seq<AtlasPage> pages = new Seq();
        final Seq<Region> regions = new Seq();

        public TextureAtlasData(Fi packFile, Fi imagesDir, boolean flip) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(packFile.read()), 64);
            try {
                String line;
                AtlasPage pageImage = null;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() == 0) {
                        pageImage = null;
                        continue;
                    }
                    if (pageImage == null) {
                        Fi file = imagesDir.child(line);
                        float width = 0.0f;
                        float height = 0.0f;
                        if (TextureAtlas.readTuple(reader) == 2) {
                            width = Integer.parseInt(tuple[0]);
                            height = Integer.parseInt(tuple[1]);
                            TextureAtlas.readTuple(reader);
                        }
                        Pixmap.Format format = Pixmap.Format.valueOf(tuple[0]);
                        TextureAtlas.readTuple(reader);
                        Texture.TextureFilter min = Texture.TextureFilter.valueOf(tuple[0]);
                        Texture.TextureFilter max = Texture.TextureFilter.valueOf(tuple[1]);
                        String direction = TextureAtlas.readValue(reader);
                        Texture.TextureWrap repeatX = Texture.TextureWrap.clampToEdge;
                        Texture.TextureWrap repeatY = Texture.TextureWrap.clampToEdge;
                        if (direction.equals("x")) {
                            repeatX = Texture.TextureWrap.repeat;
                        } else if (direction.equals("y")) {
                            repeatY = Texture.TextureWrap.repeat;
                        } else if (direction.equals("xy")) {
                            repeatX = Texture.TextureWrap.repeat;
                            repeatY = Texture.TextureWrap.repeat;
                        }
                        pageImage = new AtlasPage(file, width, height, min.isMipMap(), format, min, max, repeatX, repeatY);
                        this.pages.add(pageImage);
                        continue;
                    }
                    boolean rotate = Boolean.valueOf(TextureAtlas.readValue(reader));
                    TextureAtlas.readTuple(reader);
                    int left = Integer.parseInt(tuple[0]);
                    int top = Integer.parseInt(tuple[1]);
                    TextureAtlas.readTuple(reader);
                    int width = Integer.parseInt(tuple[0]);
                    int height = Integer.parseInt(tuple[1]);
                    Region region = new Region();
                    region.page = pageImage;
                    region.left = left;
                    region.top = top;
                    region.width = width;
                    region.height = height;
                    region.name = line;
                    region.rotate = rotate;
                    if (TextureAtlas.readTuple(reader) == 4) {
                        region.splits = new int[]{Integer.parseInt(tuple[0]), Integer.parseInt(tuple[1]), Integer.parseInt(tuple[2]), Integer.parseInt(tuple[3])};
                        if (TextureAtlas.readTuple(reader) == 4) {
                            region.pads = new int[]{Integer.parseInt(tuple[0]), Integer.parseInt(tuple[1]), Integer.parseInt(tuple[2]), Integer.parseInt(tuple[3])};
                            TextureAtlas.readTuple(reader);
                        }
                    }
                    region.originalWidth = Integer.parseInt(tuple[0]);
                    region.originalHeight = Integer.parseInt(tuple[1]);
                    TextureAtlas.readTuple(reader);
                    region.offsetX = Integer.parseInt(tuple[0]);
                    region.offsetY = Integer.parseInt(tuple[1]);
                    region.index = Integer.parseInt(TextureAtlas.readValue(reader));
                    if (flip) {
                        region.flip = true;
                    }
                    this.regions.add(region);
                }
            }
            catch (Exception ex) {
                throw new ArcRuntimeException("Error reading pack file: " + packFile, ex);
            }
            finally {
                Streams.close(reader);
            }
            this.regions.sort(indexComparator);
        }

        public Seq<AtlasPage> getPages() {
            return this.pages;
        }

        public Seq<Region> getRegions() {
            return this.regions;
        }

        public static class AtlasPage {
            public final Fi textureFile;
            public final float width;
            public final float height;
            public final boolean useMipMaps;
            public final Pixmap.Format format;
            public final Texture.TextureFilter minFilter;
            public final Texture.TextureFilter magFilter;
            public final Texture.TextureWrap uWrap;
            public final Texture.TextureWrap vWrap;
            public Texture texture;

            public AtlasPage(Fi handle, float width, float height, boolean useMipMaps, Pixmap.Format format, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, Texture.TextureWrap uWrap, Texture.TextureWrap vWrap) {
                this.width = width;
                this.height = height;
                this.textureFile = handle;
                this.useMipMaps = useMipMaps;
                this.format = format;
                this.minFilter = minFilter;
                this.magFilter = magFilter;
                this.uWrap = uWrap;
                this.vWrap = vWrap;
            }
        }

        public static class Region {
            public AtlasPage page;
            public int index;
            public String name;
            public float offsetX;
            public float offsetY;
            public int originalWidth;
            public int originalHeight;
            public boolean rotate;
            public int left;
            public int top;
            public int width;
            public int height;
            public boolean flip;
            public int[] splits;
            public int[] pads;
        }
    }
}

