/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g3d;

import arc.Core;
import arc.math.geom.Mat3D;
import arc.math.geom.Ray;
import arc.math.geom.Vec3;

public class Camera3D {
    public float fov = 67.0f;
    public float near = 1.0f;
    public float far = 100.0f;
    public boolean perspective = true;
    public float width;
    public float height;
    public final Vec3 position = new Vec3();
    public final Vec3 direction = new Vec3(0.0f, 0.0f, -1.0f);
    public final Vec3 up = new Vec3(0.0f, 1.0f, 0.0f);
    public final Mat3D combined = new Mat3D();
    public final Mat3D projection = new Mat3D();
    public final Mat3D view = new Mat3D();
    public final Mat3D invProjectionView = new Mat3D();
    private final Vec3 tmpVec = new Vec3();
    private final Ray ray = new Ray(new Vec3(), new Vec3());

    public void update() {
        if (this.perspective) {
            this.projection.setToProjection(Math.abs(this.near), Math.abs(this.far), this.fov, this.width / this.height);
        } else {
            this.projection.setToOrtho(-this.width / 2.0f, this.width / 2.0f, -this.height / 2.0f, this.height / 2.0f, this.near, this.far);
        }
        this.view.setToLookAt(this.position, this.tmpVec.set(this.position).add(this.direction), this.up);
        this.combined.set(this.projection).mul(this.view);
        this.invProjectionView.set(this.combined).inv();
    }

    public void resize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public void lookAt(float x, float y, float z) {
        this.tmpVec.set(x, y, z).sub(this.position).nor();
        if (!this.tmpVec.isZero()) {
            float dot = this.tmpVec.dot(this.up);
            if (Math.abs(dot - 1.0f) < 1.0E-9f) {
                this.up.set(this.direction).scl(-1.0f);
            } else if (Math.abs(dot + 1.0f) < 1.0E-9f) {
                this.up.set(this.direction);
            }
            this.direction.set(this.tmpVec);
            this.normalizeUp();
        }
    }

    public void lookAt(Vec3 target) {
        this.lookAt(target.x, target.y, target.z);
    }

    public void normalizeUp() {
        this.tmpVec.set(this.direction).crs(this.up);
        this.up.set(this.tmpVec).crs(this.direction).nor();
    }

    public Vec3 unproject(Vec3 screenCoords, float viewportX, float viewportY, float viewportWidth, float viewportHeight) {
        float x = screenCoords.x;
        float y = screenCoords.y;
        screenCoords.x = 2.0f * (x -= viewportX) / viewportWidth - 1.0f;
        screenCoords.y = 2.0f * (y -= viewportY) / viewportHeight - 1.0f;
        screenCoords.z = 2.0f * screenCoords.z - 1.0f;
        Mat3D.prj(screenCoords, this.invProjectionView);
        return screenCoords;
    }

    public Vec3 unproject(Vec3 screenCoords) {
        this.unproject(screenCoords, 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        return screenCoords;
    }

    public Vec3 project(Vec3 worldCoords) {
        this.project(worldCoords, 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        return worldCoords;
    }

    public Vec3 project(Vec3 worldCoords, float viewportX, float viewportY, float viewportWidth, float viewportHeight) {
        Mat3D.prj(worldCoords, this.combined);
        worldCoords.x = viewportWidth * (worldCoords.x + 1.0f) / 2.0f + viewportX;
        worldCoords.y = viewportHeight * (worldCoords.y + 1.0f) / 2.0f + viewportY;
        worldCoords.z = (worldCoords.z + 1.0f) / 2.0f;
        return worldCoords;
    }

    public Ray getMouseRay() {
        return this.getPickRay(Core.input.mouseX(), Core.input.mouseY());
    }

    public Ray getPickRay(float screenX, float screenY, float viewportX, float viewportY, float viewportWidth, float viewportHeight) {
        this.unproject(this.ray.origin.set(screenX, screenY, 0.0f), viewportX, viewportY, viewportWidth, viewportHeight);
        this.unproject(this.ray.direction.set(screenX, screenY, 1.0f), viewportX, viewportY, viewportWidth, viewportHeight);
        this.ray.direction.sub(this.ray.origin).nor();
        return this.ray;
    }

    public Ray getPickRay(float screenX, float screenY) {
        return this.getPickRay(screenX, screenY, 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
    }
}

