/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.files.Fi;
import arc.graphics.Pixmap;
import arc.graphics.TextureData;
import arc.util.ArcRuntimeException;

public class FileTextureData
implements TextureData {
    final Fi file;
    int width = 0;
    int height = 0;
    Pixmap.Format format;
    Pixmap pixmap;
    boolean useMipMaps;
    boolean isPrepared = false;

    public FileTextureData(Fi file, Pixmap preloadedPixmap, Pixmap.Format format, boolean useMipMaps) {
        this.file = file;
        this.pixmap = preloadedPixmap;
        this.format = format;
        this.useMipMaps = useMipMaps;
        if (this.pixmap != null) {
            this.width = this.pixmap.getWidth();
            this.height = this.pixmap.getHeight();
            if (format == null) {
                this.format = this.pixmap.getFormat();
            }
        }
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            throw new ArcRuntimeException("Already prepared");
        }
        if (this.pixmap == null) {
            this.pixmap = new Pixmap(this.file);
            this.width = this.pixmap.getWidth();
            this.height = this.pixmap.getHeight();
            if (this.format == null) {
                this.format = this.pixmap.getFormat();
            }
        }
        this.isPrepared = true;
    }

    @Override
    public Pixmap consumePixmap() {
        if (!this.isPrepared) {
            throw new ArcRuntimeException("Call prepare() before calling getPixmap()");
        }
        this.isPrepared = false;
        Pixmap pixmap = this.pixmap;
        this.pixmap = null;
        return pixmap;
    }

    @Override
    public boolean disposePixmap() {
        return true;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Pixmap.Format getFormat() {
        return this.format;
    }

    @Override
    public boolean useMipMaps() {
        return this.useMipMaps;
    }

    public Fi getFileHandle() {
        return this.file;
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public void consumeCustomData(int target) {
        throw new ArcRuntimeException("This TextureData implementation does not upload data itself");
    }

    public String toString() {
        return this.file.toString();
    }
}

