/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.Core;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.gl.FloatTextureData;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.GLFrameBuffer;

public class FloatFrameBuffer
extends FrameBuffer {
    FloatFrameBuffer() {
    }

    protected FloatFrameBuffer(GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>> bufferBuilder) {
        super(bufferBuilder);
    }

    public FloatFrameBuffer(int width, int height, boolean hasDepth) {
        GLFrameBuffer.FloatFrameBufferBuilder bufferBuilder = new GLFrameBuffer.FloatFrameBufferBuilder(width, height);
        bufferBuilder.addFloatAttachment(34836, 6408, 5126, false);
        if (hasDepth) {
            bufferBuilder.addBasicDepthRenderBuffer();
        }
        this.bufferBuilder = bufferBuilder;
        this.build();
    }

    @Override
    protected void create(Pixmap.Format format, int width, int height, boolean hasDepth, boolean hasStencil) {
    }

    @Override
    public void resize(int width, int height) {
        throw new IllegalArgumentException("resize() is currently unsupported here.");
    }

    @Override
    protected Texture createTexture(GLFrameBuffer.FrameBufferTextureAttachmentSpec attachmentSpec) {
        FloatTextureData data = new FloatTextureData(this.bufferBuilder.width, this.bufferBuilder.height, attachmentSpec.internalFormat, attachmentSpec.format, attachmentSpec.type, attachmentSpec.isGpuOnly);
        Texture result = new Texture(data);
        if (Core.app.isDesktop()) {
            result.setFilter(Texture.TextureFilter.linear, Texture.TextureFilter.linear);
        } else {
            result.setFilter(Texture.TextureFilter.nearest, Texture.TextureFilter.nearest);
        }
        result.setWrap(Texture.TextureWrap.clampToEdge, Texture.TextureWrap.clampToEdge);
        return result;
    }
}

