/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.Core;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.TextureData;
import arc.graphics.gl.GLVersion;
import arc.util.ArcRuntimeException;
import arc.util.Buffers;
import java.nio.FloatBuffer;

public class FloatTextureData
implements TextureData {
    int width;
    int height;
    int internalFormat;
    int format;
    int type;
    boolean isGpuOnly;
    boolean isPrepared = false;
    FloatBuffer buffer;

    public FloatTextureData(int w, int h, int internalFormat, int format, int type, boolean isGpuOnly) {
        this.width = w;
        this.height = h;
        this.internalFormat = internalFormat;
        this.format = format;
        this.type = type;
        this.isGpuOnly = isGpuOnly;
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            throw new ArcRuntimeException("Already prepared");
        }
        if (!this.isGpuOnly) {
            int amountOfFloats = 4;
            if (Core.graphics.getGLVersion().type.equals((Object)GLVersion.GlType.OpenGL)) {
                if (this.internalFormat == 34842 || this.internalFormat == 34836) {
                    amountOfFloats = 4;
                }
                if (this.internalFormat == 34843 || this.internalFormat == 34837) {
                    amountOfFloats = 3;
                }
                if (this.internalFormat == 33327 || this.internalFormat == 33328) {
                    amountOfFloats = 2;
                }
                if (this.internalFormat == 33325 || this.internalFormat == 33326) {
                    amountOfFloats = 1;
                }
            }
            this.buffer = Buffers.newFloatBuffer(this.width * this.height * amountOfFloats);
        }
        this.isPrepared = true;
    }

    @Override
    public void consumeCustomData(int target) {
        if (Core.app.isAndroid() || Core.app.isIOS() || Core.app.isWeb()) {
            if (!Core.graphics.supportsExtension("OES_texture_float")) {
                throw new ArcRuntimeException("Extension OES_texture_float not supported!");
            }
            Gl.texImage2D(target, 0, 6408, this.width, this.height, 0, 6408, 5126, this.buffer);
        } else {
            if (!Core.graphics.isGL30Available() && !Core.graphics.supportsExtension("GL_ARB_texture_float")) {
                throw new ArcRuntimeException("Extension GL_ARB_texture_float not supported!");
            }
            Gl.texImage2D(target, 0, this.internalFormat, this.width, this.height, 0, this.format, 5126, this.buffer);
        }
    }

    @Override
    public Pixmap consumePixmap() {
        throw new ArcRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    @Override
    public boolean disposePixmap() {
        throw new ArcRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Pixmap.Format getFormat() {
        return Pixmap.Format.rgba8888;
    }

    @Override
    public boolean useMipMaps() {
        return false;
    }

    public FloatBuffer getBuffer() {
        return this.buffer;
    }
}

