/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.TextureData;
import arc.util.ArcRuntimeException;

public class GLOnlyTextureData
implements TextureData {
    int width = 0;
    int height = 0;
    boolean isPrepared = false;
    int mipLevel = 0;
    int internalFormat;
    int format;
    int type;

    public GLOnlyTextureData(int width, int height, int mipMapLevel, int internalFormat, int format, int type) {
        this.width = width;
        this.height = height;
        this.mipLevel = mipMapLevel;
        this.internalFormat = internalFormat;
        this.format = format;
        this.type = type;
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            throw new ArcRuntimeException("Already prepared");
        }
        this.isPrepared = true;
    }

    @Override
    public void consumeCustomData(int target) {
        Gl.texImage2D(target, this.mipLevel, this.internalFormat, this.width, this.height, 0, this.format, this.type, null);
    }

    @Override
    public Pixmap consumePixmap() {
        throw new ArcRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    @Override
    public boolean disposePixmap() {
        throw new ArcRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Pixmap.Format getFormat() {
        return Pixmap.Format.rgba8888;
    }

    @Override
    public boolean useMipMaps() {
        return false;
    }
}

