/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.graphics.Pixmap;
import arc.graphics.TextureData;
import arc.util.ArcRuntimeException;

public class PixmapTextureData
implements TextureData {
    final Pixmap pixmap;
    final Pixmap.Format format;
    final boolean useMipMaps;
    final boolean disposePixmap;

    public PixmapTextureData(Pixmap pixmap, Pixmap.Format format, boolean useMipMaps, boolean disposePixmap) {
        this.pixmap = pixmap;
        this.format = format == null ? pixmap.getFormat() : format;
        this.useMipMaps = useMipMaps;
        this.disposePixmap = disposePixmap;
    }

    @Override
    public boolean disposePixmap() {
        return this.disposePixmap;
    }

    @Override
    public Pixmap consumePixmap() {
        return this.pixmap;
    }

    @Override
    public int getWidth() {
        return this.pixmap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.pixmap.getHeight();
    }

    @Override
    public Pixmap.Format getFormat() {
        return this.format;
    }

    @Override
    public boolean useMipMaps() {
        return this.useMipMaps;
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public void consumeCustomData(int target) {
        throw new ArcRuntimeException("This TextureData implementation does not upload data itself");
    }

    @Override
    public boolean isPrepared() {
        return true;
    }

    @Override
    public void prepare() {
        throw new ArcRuntimeException("prepare() must not be called on a PixmapTextureData instance as it is already prepared.");
    }
}

