/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.profiling;

import arc.graphics.profiling.GLInterceptor;
import arc.util.ArcRuntimeException;
import arc.util.Log;
import arc.util.Strings;

public interface GLErrorListener {
    public static final GLErrorListener LOGGING_LISTENER = error -> {
        String place = null;
        try {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                if (!"check".equals(stack[i].getMethodName())) continue;
                if (i + 1 < stack.length) {
                    StackTraceElement glMethod = stack[i + 1];
                    place = glMethod.getMethodName();
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (place != null) {
            Log.err("[GLProfiler] Error @ from @", GLInterceptor.resolveErrorNumber(error), place);
            throw new RuntimeException(Strings.format("[GLProfiler] Error @ from @", GLInterceptor.resolveErrorNumber(error), place));
        }
        Log.err("[GLProfiler] Error @ at: @", GLInterceptor.resolveErrorNumber(error), new Exception());
        throw new RuntimeException(Strings.format("[GLProfiler] Error @", GLInterceptor.resolveErrorNumber(error)));
    };
    public static final GLErrorListener THROWING_LISTENER = error -> {
        throw new ArcRuntimeException("GLProfiler: Got GL error " + GLInterceptor.resolveErrorNumber(error));
    };

    public void onError(int var1);
}

