/*
 * Decompiled with CFR 0.152.
 */
package arc.math;

import arc.math.Interp;

public interface Scaled {
    public float fin();

    default public float fout() {
        return 1.0f - this.fin();
    }

    default public float fout(Interp i) {
        return i.apply(this.fout());
    }

    default public float fout(float margin) {
        float f = this.fin();
        if (f >= 1.0f - margin) {
            return 1.0f - (f - (1.0f - margin)) / margin;
        }
        return 1.0f;
    }

    default public float fin(Interp i) {
        return i.apply(this.fin());
    }

    default public float finpow() {
        return Interp.pow3Out.apply(this.fin());
    }

    default public float fslope() {
        return (0.5f - Math.abs(this.fin() - 0.5f)) * 2.0f;
    }
}

