/*
 * Decompiled with CFR 0.152.
 */
package arc.math;

import arc.math.Mathf;
import java.util.Arrays;

public final class WindowedMean {
    float[] values;
    int addedValues = 0;
    int lastValue;
    float mean = 0.0f;
    boolean dirty = true;

    public WindowedMean(int windowSize) {
        this.values = new float[windowSize];
    }

    public void reset() {
        this.addedValues = 0;
        this.lastValue = 0;
        this.mean = 0.0f;
    }

    public float get(int index) {
        return this.values[Mathf.mod(index + this.lastValue, this.values.length)];
    }

    public boolean hasEnoughData() {
        return this.addedValues >= this.values.length;
    }

    public void clear() {
        this.addedValues = 0;
        this.lastValue = 0;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = 0.0f;
        }
        this.dirty = true;
    }

    public void fill(float value) {
        this.dirty = true;
        Arrays.fill(this.values, value);
    }

    public void add(float value) {
        if (this.addedValues < this.values.length) {
            ++this.addedValues;
        }
        this.values[this.lastValue++] = value;
        if (this.lastValue > this.values.length - 1) {
            this.lastValue = 0;
        }
        this.dirty = true;
    }

    public float mean() {
        if (this.hasEnoughData()) {
            if (this.dirty) {
                float mean = 0.0f;
                for (int i = 0; i < this.values.length; ++i) {
                    mean += this.values[i];
                }
                this.mean = mean / (float)this.values.length;
                this.dirty = false;
            }
            return this.mean;
        }
        return 0.0f;
    }

    public float rawMean() {
        if (this.dirty) {
            float mean = 0.0f;
            for (int i = 0; i < this.values.length; ++i) {
                mean += this.values[i];
            }
            this.mean = mean / (float)this.values.length;
            this.dirty = false;
        }
        return this.mean;
    }

    public float oldest() {
        return this.addedValues < this.values.length ? this.values[0] : this.values[this.lastValue];
    }

    public float latest() {
        return this.values[this.lastValue - 1 == -1 ? this.values.length - 1 : this.lastValue - 1];
    }

    public float standardDeviation() {
        if (!this.hasEnoughData()) {
            return 0.0f;
        }
        float mean = this.mean();
        float sum = 0.0f;
        for (int i = 0; i < this.values.length; ++i) {
            sum += (this.values[i] - mean) * (this.values[i] - mean);
        }
        return (float)Math.sqrt(sum / (float)this.values.length);
    }

    public float lowest() {
        float lowest = Float.MAX_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            lowest = Math.min(lowest, this.values[i]);
        }
        return lowest;
    }

    public float highest() {
        float lowest = Float.MIN_NORMAL;
        for (int i = 0; i < this.values.length; ++i) {
            lowest = Math.max(lowest, this.values[i]);
        }
        return lowest;
    }

    public int getCount() {
        return this.addedValues;
    }

    public int getWindowSize() {
        return this.values.length;
    }

    public float[] getWindowValues() {
        float[] windowValues = new float[this.addedValues];
        if (this.hasEnoughData()) {
            for (int i = 0; i < windowValues.length; ++i) {
                windowValues[i] = this.values[(i + this.lastValue) % this.values.length];
            }
        } else {
            System.arraycopy(this.values, 0, windowValues, 0, this.addedValues);
        }
        return windowValues;
    }
}

