/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.math.Mathf;
import arc.math.geom.BoundingBox;
import arc.math.geom.Intersector;
import arc.math.geom.Plane;
import arc.math.geom.Ray;
import arc.math.geom.Vec3;
import java.util.Arrays;
import java.util.List;

public class Intersector3D {
    private static final Vec3 v0 = new Vec3();
    private static final Vec3 v1 = new Vec3();
    private static final Vec3 v2 = new Vec3();
    private static final Plane p = new Plane(new Vec3(), 0.0f);
    private static final Vec3 i = new Vec3();
    static Vec3 best = new Vec3();
    static Vec3 tmp = new Vec3();
    static Vec3 tmp1 = new Vec3();
    static Vec3 tmp2 = new Vec3();
    static Vec3 tmp3 = new Vec3();
    static Vec3 intersection = new Vec3();

    public static boolean intersectRayPlane(Ray ray, Plane plane, Vec3 intersection) {
        float denom = ray.direction.dot(plane.getNormal());
        if (denom != 0.0f) {
            float t = -(ray.origin.dot(plane.getNormal()) + plane.getD()) / denom;
            if (t < 0.0f) {
                return false;
            }
            if (intersection != null) {
                intersection.set(ray.origin).add(v0.set(ray.direction).scl(t));
            }
            return true;
        }
        if (plane.testPoint(ray.origin) == Plane.PlaneSide.onPlane) {
            if (intersection != null) {
                intersection.set(ray.origin);
            }
            return true;
        }
        return false;
    }

    public static float intersectLinePlane(float x, float y, float z, float x2, float y2, float z2, Plane plane, Vec3 intersection) {
        Vec3 direction = tmp.set(x2, y2, z2).sub(x, y, z);
        Vec3 origin = tmp2.set(x, y, z);
        float denom = direction.dot(plane.getNormal());
        if (denom != 0.0f) {
            float t = -(origin.dot(plane.getNormal()) + plane.getD()) / denom;
            if (intersection != null) {
                intersection.set(origin).add(direction.scl(t));
            }
            return t;
        }
        if (plane.testPoint(origin) == Plane.PlaneSide.onPlane) {
            if (intersection != null) {
                intersection.set(origin);
            }
            return 0.0f;
        }
        return -1.0f;
    }

    public static boolean intersectRayTriangle(Ray ray, Vec3 t1, Vec3 t2, Vec3 t3, Vec3 intersection) {
        Vec3 edge1 = v0.set(t2).sub(t1);
        Vec3 edge2 = v1.set(t3).sub(t1);
        Vec3 pvec = v2.set(ray.direction).crs(edge2);
        float det = edge1.dot(pvec);
        if (Mathf.zero(det)) {
            p.set(t1, t2, t3);
            if (p.testPoint(ray.origin) == Plane.PlaneSide.onPlane && Intersector.isInTriangle(ray.origin, t1, t2, t3)) {
                if (intersection != null) {
                    intersection.set(ray.origin);
                }
                return true;
            }
            return false;
        }
        det = 1.0f / det;
        Vec3 tvec = i.set(ray.origin).sub(t1);
        float u = tvec.dot(pvec) * det;
        if (u < 0.0f || u > 1.0f) {
            return false;
        }
        Vec3 qvec = tvec.crs(edge1);
        float v = ray.direction.dot(qvec) * det;
        if (v < 0.0f || u + v > 1.0f) {
            return false;
        }
        float t = edge2.dot(qvec) * det;
        if (t < 0.0f) {
            return false;
        }
        if (intersection != null) {
            if (t <= 1.0E-6f) {
                intersection.set(ray.origin);
            } else {
                ray.getEndPoint(intersection, t);
            }
        }
        return true;
    }

    public static boolean intersectRaySphere(Ray ray, Vec3 center, float radius, Vec3 intersection) {
        float r2;
        float len = ray.direction.dot(center.x - ray.origin.x, center.y - ray.origin.y, center.z - ray.origin.z);
        if (len < 0.0f) {
            return false;
        }
        float dst2 = center.dst2(ray.origin.x + ray.direction.x * len, ray.origin.y + ray.direction.y * len, ray.origin.z + ray.direction.z * len);
        if (dst2 > (r2 = radius * radius)) {
            return false;
        }
        if (intersection != null) {
            intersection.set(ray.direction).scl(len - (float)Math.sqrt(r2 - dst2)).add(ray.origin);
        }
        return true;
    }

    public static boolean intersectRayBounds(Ray ray, BoundingBox box, Vec3 intersection) {
        float t;
        if (box.contains(ray.origin)) {
            if (intersection != null) {
                intersection.set(ray.origin);
            }
            return true;
        }
        float lowest = 0.0f;
        boolean hit = false;
        if (ray.origin.x <= box.min.x && ray.direction.x > 0.0f && (t = (box.min.x - ray.origin.x) / ray.direction.x) >= 0.0f) {
            v2.set(ray.direction).scl(t).add(ray.origin);
            if (Intersector3D.v2.y >= box.min.y && Intersector3D.v2.y <= box.max.y && Intersector3D.v2.z >= box.min.z && Intersector3D.v2.z <= box.max.z && (!hit || t < lowest)) {
                hit = true;
                lowest = t;
            }
        }
        if (ray.origin.x >= box.max.x && ray.direction.x < 0.0f && (t = (box.max.x - ray.origin.x) / ray.direction.x) >= 0.0f) {
            v2.set(ray.direction).scl(t).add(ray.origin);
            if (Intersector3D.v2.y >= box.min.y && Intersector3D.v2.y <= box.max.y && Intersector3D.v2.z >= box.min.z && Intersector3D.v2.z <= box.max.z && (!hit || t < lowest)) {
                hit = true;
                lowest = t;
            }
        }
        if (ray.origin.y <= box.min.y && ray.direction.y > 0.0f && (t = (box.min.y - ray.origin.y) / ray.direction.y) >= 0.0f) {
            v2.set(ray.direction).scl(t).add(ray.origin);
            if (Intersector3D.v2.x >= box.min.x && Intersector3D.v2.x <= box.max.x && Intersector3D.v2.z >= box.min.z && Intersector3D.v2.z <= box.max.z && (!hit || t < lowest)) {
                hit = true;
                lowest = t;
            }
        }
        if (ray.origin.y >= box.max.y && ray.direction.y < 0.0f && (t = (box.max.y - ray.origin.y) / ray.direction.y) >= 0.0f) {
            v2.set(ray.direction).scl(t).add(ray.origin);
            if (Intersector3D.v2.x >= box.min.x && Intersector3D.v2.x <= box.max.x && Intersector3D.v2.z >= box.min.z && Intersector3D.v2.z <= box.max.z && (!hit || t < lowest)) {
                hit = true;
                lowest = t;
            }
        }
        if (ray.origin.z <= box.min.z && ray.direction.z > 0.0f && (t = (box.min.z - ray.origin.z) / ray.direction.z) >= 0.0f) {
            v2.set(ray.direction).scl(t).add(ray.origin);
            if (Intersector3D.v2.x >= box.min.x && Intersector3D.v2.x <= box.max.x && Intersector3D.v2.y >= box.min.y && Intersector3D.v2.y <= box.max.y && (!hit || t < lowest)) {
                hit = true;
                lowest = t;
            }
        }
        if (ray.origin.z >= box.max.z && ray.direction.z < 0.0f && (t = (box.max.z - ray.origin.z) / ray.direction.z) >= 0.0f) {
            v2.set(ray.direction).scl(t).add(ray.origin);
            if (Intersector3D.v2.x >= box.min.x && Intersector3D.v2.x <= box.max.x && Intersector3D.v2.y >= box.min.y && Intersector3D.v2.y <= box.max.y && (!hit || t < lowest)) {
                hit = true;
                lowest = t;
            }
        }
        if (hit && intersection != null) {
            intersection.set(ray.direction).scl(lowest).add(ray.origin);
            if (intersection.x < box.min.x) {
                intersection.x = box.min.x;
            } else if (intersection.x > box.max.x) {
                intersection.x = box.max.x;
            }
            if (intersection.y < box.min.y) {
                intersection.y = box.min.y;
            } else if (intersection.y > box.max.y) {
                intersection.y = box.max.y;
            }
            if (intersection.z < box.min.z) {
                intersection.z = box.min.z;
            } else if (intersection.z > box.max.z) {
                intersection.z = box.max.z;
            }
        }
        return hit;
    }

    public static boolean intersectRayBoundsFast(Ray ray, BoundingBox box) {
        return Intersector3D.intersectRayBoundsFast(ray, box.getCenter(tmp1), box.getDimensions(tmp2));
    }

    public static boolean intersectRayBoundsFast(Ray ray, Vec3 center, Vec3 dimensions) {
        float maxz;
        float minz;
        float maxy;
        float miny;
        float divX = 1.0f / ray.direction.x;
        float divY = 1.0f / ray.direction.y;
        float divZ = 1.0f / ray.direction.z;
        float minx = (center.x - dimensions.x * 0.5f - ray.origin.x) * divX;
        float maxx = (center.x + dimensions.x * 0.5f - ray.origin.x) * divX;
        if (minx > maxx) {
            float t = minx;
            minx = maxx;
            maxx = t;
        }
        if ((miny = (center.y - dimensions.y * 0.5f - ray.origin.y) * divY) > (maxy = (center.y + dimensions.y * 0.5f - ray.origin.y) * divY)) {
            float t = miny;
            miny = maxy;
            maxy = t;
        }
        if ((minz = (center.z - dimensions.z * 0.5f - ray.origin.z) * divZ) > (maxz = (center.z + dimensions.z * 0.5f - ray.origin.z) * divZ)) {
            float t = minz;
            minz = maxz;
            maxz = t;
        }
        float min = Math.max(Math.max(minx, miny), minz);
        float max = Math.min(Math.min(maxx, maxy), maxz);
        return max >= 0.0f && max >= min;
    }

    public static boolean intersectSegmentPlane(Vec3 start, Vec3 end, Plane plane, Vec3 intersection) {
        Vec3 dir = v0.set(end).sub(start);
        float denom = dir.dot(plane.getNormal());
        if (denom == 0.0f) {
            return false;
        }
        float t = -(start.dot(plane.getNormal()) + plane.getD()) / denom;
        if (t < 0.0f || t > 1.0f) {
            return false;
        }
        intersection.set(start).add(dir.scl(t));
        return true;
    }

    public static boolean intersectRayTriangles(Ray ray, float[] triangles, Vec3 intersection) {
        float min_dist = Float.MAX_VALUE;
        boolean hit = false;
        if (triangles.length / 3 % 3 != 0) {
            throw new RuntimeException("triangle list size is not a multiple of 3");
        }
        for (int i = 0; i < triangles.length - 6; i += 9) {
            float dist;
            boolean result = Intersector3D.intersectRayTriangle(ray, tmp1.set(triangles[i], triangles[i + 1], triangles[i + 2]), tmp2.set(triangles[i + 3], triangles[i + 4], triangles[i + 5]), tmp3.set(triangles[i + 6], triangles[i + 7], triangles[i + 8]), tmp);
            if (!result || !((dist = ray.origin.dst2(tmp)) < min_dist)) continue;
            min_dist = dist;
            best.set(tmp);
            hit = true;
        }
        if (!hit) {
            return false;
        }
        if (intersection != null) {
            intersection.set(best);
        }
        return true;
    }

    public static boolean intersectRayTriangles(Ray ray, float[] vertices, short[] indices, int vertexSize, Vec3 intersection) {
        float min_dist = Float.MAX_VALUE;
        boolean hit = false;
        if (indices.length % 3 != 0) {
            throw new RuntimeException("triangle list size is not a multiple of 3");
        }
        for (int i = 0; i < indices.length; i += 3) {
            float dist;
            int i1 = indices[i] * vertexSize;
            int i2 = indices[i + 1] * vertexSize;
            int i3 = indices[i + 2] * vertexSize;
            boolean result = Intersector3D.intersectRayTriangle(ray, tmp1.set(vertices[i1], vertices[i1 + 1], vertices[i1 + 2]), tmp2.set(vertices[i2], vertices[i2 + 1], vertices[i2 + 2]), tmp3.set(vertices[i3], vertices[i3 + 1], vertices[i3 + 2]), tmp);
            if (!result || !((dist = ray.origin.dst2(tmp)) < min_dist)) continue;
            min_dist = dist;
            best.set(tmp);
            hit = true;
        }
        if (!hit) {
            return false;
        }
        if (intersection != null) {
            intersection.set(best);
        }
        return true;
    }

    public static boolean intersectRayTriangles(Ray ray, List<Vec3> triangles, Vec3 intersection) {
        float min_dist = Float.MAX_VALUE;
        boolean hit = false;
        if (triangles.size() % 3 != 0) {
            throw new RuntimeException("triangle list size is not a multiple of 3");
        }
        for (int i = 0; i < triangles.size() - 2; i += 3) {
            float dist;
            boolean result = Intersector3D.intersectRayTriangle(ray, triangles.get(i), triangles.get(i + 1), triangles.get(i + 2), tmp);
            if (!result || !((dist = ray.origin.dst2(tmp)) < min_dist)) continue;
            min_dist = dist;
            best.set(tmp);
            hit = true;
        }
        if (!hit) {
            return false;
        }
        if (intersection != null) {
            intersection.set(best);
        }
        return true;
    }

    public static void splitTriangle(float[] triangle, Plane plane, SplitTriangle split) {
        int stride = triangle.length / 3;
        boolean r1 = plane.testPoint(triangle[0], triangle[1], triangle[2]) == Plane.PlaneSide.back;
        boolean r2 = plane.testPoint(triangle[stride], triangle[1 + stride], triangle[2 + stride]) == Plane.PlaneSide.back;
        boolean r3 = plane.testPoint(triangle[stride * 2], triangle[1 + stride * 2], triangle[2 + stride * 2]) == Plane.PlaneSide.back;
        split.reset();
        if (r1 == r2 && r2 == r3) {
            split.total = 1;
            if (r1) {
                split.numBack = 1;
                System.arraycopy(triangle, 0, split.back, 0, triangle.length);
            } else {
                split.numFront = 1;
                System.arraycopy(triangle, 0, split.front, 0, triangle.length);
            }
            return;
        }
        split.total = 3;
        split.numFront = (r1 ? 0 : 1) + (r2 ? 0 : 1) + (r3 ? 0 : 1);
        split.numBack = split.total - split.numFront;
        split.setSide(!r1);
        int first = 0;
        int second = stride;
        if (r1 != r2) {
            Intersector3D.splitEdge(triangle, first, second, stride, plane, split.edgeSplit, 0);
            split.add(triangle, first, stride);
            split.add(split.edgeSplit, 0, stride);
            split.setSide(!split.getSide());
            split.add(split.edgeSplit, 0, stride);
        } else {
            split.add(triangle, first, stride);
        }
        first = stride;
        second = stride + stride;
        if (r2 != r3) {
            Intersector3D.splitEdge(triangle, first, second, stride, plane, split.edgeSplit, 0);
            split.add(triangle, first, stride);
            split.add(split.edgeSplit, 0, stride);
            split.setSide(!split.getSide());
            split.add(split.edgeSplit, 0, stride);
        } else {
            split.add(triangle, first, stride);
        }
        first = stride + stride;
        second = 0;
        if (r3 != r1) {
            Intersector3D.splitEdge(triangle, first, second, stride, plane, split.edgeSplit, 0);
            split.add(triangle, first, stride);
            split.add(split.edgeSplit, 0, stride);
            split.setSide(!split.getSide());
            split.add(split.edgeSplit, 0, stride);
        } else {
            split.add(triangle, first, stride);
        }
        if (split.numFront == 2) {
            System.arraycopy(split.front, stride * 2, split.front, stride * 3, stride * 2);
            System.arraycopy(split.front, 0, split.front, stride * 5, stride);
        } else {
            System.arraycopy(split.back, stride * 2, split.back, stride * 3, stride * 2);
            System.arraycopy(split.back, 0, split.back, stride * 5, stride);
        }
    }

    private static void splitEdge(float[] vertices, int s, int e, int stride, Plane plane, float[] split, int offset) {
        float t = Intersector3D.intersectLinePlane(vertices[s], vertices[s + 1], vertices[s + 2], vertices[e], vertices[e + 1], vertices[e + 2], plane, intersection);
        split[offset] = Intersector3D.intersection.x;
        split[offset + 1] = Intersector3D.intersection.y;
        split[offset + 2] = Intersector3D.intersection.z;
        for (int i = 3; i < stride; ++i) {
            float a = vertices[s + i];
            float b = vertices[e + i];
            split[offset + i] = a + t * (b - a);
        }
    }

    public static class SplitTriangle {
        public float[] front;
        public float[] back;
        public int numFront;
        public int numBack;
        public int total;
        float[] edgeSplit;
        boolean frontCurrent = false;
        int frontOffset = 0;
        int backOffset = 0;

        public SplitTriangle(int numAttributes) {
            this.front = new float[numAttributes * 3 * 2];
            this.back = new float[numAttributes * 3 * 2];
            this.edgeSplit = new float[numAttributes];
        }

        public String toString() {
            return "SplitTriangle [front=" + Arrays.toString(this.front) + ", back=" + Arrays.toString(this.back) + ", numFront=" + this.numFront + ", numBack=" + this.numBack + ", total=" + this.total + "]";
        }

        boolean getSide() {
            return this.frontCurrent;
        }

        void setSide(boolean front) {
            this.frontCurrent = front;
        }

        void add(float[] vertex, int offset, int stride) {
            if (this.frontCurrent) {
                System.arraycopy(vertex, offset, this.front, this.frontOffset, stride);
                this.frontOffset += stride;
            } else {
                System.arraycopy(vertex, offset, this.back, this.backOffset, stride);
                this.backOffset += stride;
            }
        }

        void reset() {
            this.frontCurrent = false;
            this.frontOffset = 0;
            this.backOffset = 0;
            this.numFront = 0;
            this.numBack = 0;
            this.total = 0;
        }
    }
}

