/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.math.Affine2;
import arc.math.Mat;
import arc.math.Mathf;
import arc.math.geom.Quat;
import arc.math.geom.Vec3;

public class Mat3D {
    public static final int M00 = 0;
    public static final int M01 = 4;
    public static final int M02 = 8;
    public static final int M03 = 12;
    public static final int M10 = 1;
    public static final int M11 = 5;
    public static final int M12 = 9;
    public static final int M13 = 13;
    public static final int M20 = 2;
    public static final int M21 = 6;
    public static final int M22 = 10;
    public static final int M23 = 14;
    public static final int M30 = 3;
    public static final int M31 = 7;
    public static final int M32 = 11;
    public static final int M33 = 15;
    private static final float[] tmp = new float[16];
    public final float[] val = new float[16];
    static Quat quat = new Quat();
    static Quat quat2 = new Quat();
    static final Vec3 l_vez = new Vec3();
    static final Vec3 l_vex = new Vec3();
    static final Vec3 l_vey = new Vec3();
    static final Vec3 tmpVec = new Vec3();
    static final Mat3D tmpMat = new Mat3D();
    static final Vec3 right = new Vec3();
    static final Vec3 tmpForward = new Vec3();
    static final Vec3 tmpUp = new Vec3();

    public Mat3D() {
        this.val[0] = 1.0f;
        this.val[5] = 1.0f;
        this.val[10] = 1.0f;
        this.val[15] = 1.0f;
    }

    public Mat3D(Mat3D matrix) {
        this.set(matrix);
    }

    public Mat3D(float[] values) {
        this.set(values);
    }

    public Mat3D(Quat quat) {
        this.set(quat);
    }

    public Mat3D(Vec3 position, Quat rotation, Vec3 scale) {
        this.set(position, rotation, scale);
    }

    public Mat3D set(Mat3D matrix) {
        return this.set(matrix.val);
    }

    public Mat3D set(float[] values) {
        System.arraycopy(values, 0, this.val, 0, this.val.length);
        return this;
    }

    public Mat3D set(Quat quat) {
        return this.set(quat.x, quat.y, quat.z, quat.w);
    }

    public Mat3D set(float quaternionX, float quaternionY, float quaternionZ, float quaternionW) {
        return this.set(0.0f, 0.0f, 0.0f, quaternionX, quaternionY, quaternionZ, quaternionW);
    }

    public Mat3D set(Vec3 position, Quat orientation) {
        return this.set(position.x, position.y, position.z, orientation.x, orientation.y, orientation.z, orientation.w);
    }

    public Mat3D set(float translationX, float translationY, float translationZ, float quaternionX, float quaternionY, float quaternionZ, float quaternionW) {
        float xs = quaternionX * 2.0f;
        float ys = quaternionY * 2.0f;
        float zs = quaternionZ * 2.0f;
        float wx = quaternionW * xs;
        float wy = quaternionW * ys;
        float wz = quaternionW * zs;
        float xx = quaternionX * xs;
        float xy = quaternionX * ys;
        float xz = quaternionX * zs;
        float yy = quaternionY * ys;
        float yz = quaternionY * zs;
        float zz = quaternionZ * zs;
        this.val[0] = 1.0f - (yy + zz);
        this.val[4] = xy - wz;
        this.val[8] = xz + wy;
        this.val[12] = translationX;
        this.val[1] = xy + wz;
        this.val[5] = 1.0f - (xx + zz);
        this.val[9] = yz - wx;
        this.val[13] = translationY;
        this.val[2] = xz - wy;
        this.val[6] = yz + wx;
        this.val[10] = 1.0f - (xx + yy);
        this.val[14] = translationZ;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public Mat3D set(Vec3 position, Quat orientation, Vec3 scale) {
        return this.set(position.x, position.y, position.z, orientation.x, orientation.y, orientation.z, orientation.w, scale.x, scale.y, scale.z);
    }

    public Mat3D set(float translationX, float translationY, float translationZ, float quaternionX, float quaternionY, float quaternionZ, float quaternionW, float scaleX, float scaleY, float scaleZ) {
        float xs = quaternionX * 2.0f;
        float ys = quaternionY * 2.0f;
        float zs = quaternionZ * 2.0f;
        float wx = quaternionW * xs;
        float wy = quaternionW * ys;
        float wz = quaternionW * zs;
        float xx = quaternionX * xs;
        float xy = quaternionX * ys;
        float xz = quaternionX * zs;
        float yy = quaternionY * ys;
        float yz = quaternionY * zs;
        float zz = quaternionZ * zs;
        this.val[0] = scaleX * (1.0f - (yy + zz));
        this.val[4] = scaleY * (xy - wz);
        this.val[8] = scaleZ * (xz + wy);
        this.val[12] = translationX;
        this.val[1] = scaleX * (xy + wz);
        this.val[5] = scaleY * (1.0f - (xx + zz));
        this.val[9] = scaleZ * (yz - wx);
        this.val[13] = translationY;
        this.val[2] = scaleX * (xz - wy);
        this.val[6] = scaleY * (yz + wx);
        this.val[10] = scaleZ * (1.0f - (xx + yy));
        this.val[14] = translationZ;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public Mat3D set(Vec3 xAxis, Vec3 yAxis, Vec3 zAxis, Vec3 pos) {
        this.val[0] = xAxis.x;
        this.val[4] = xAxis.y;
        this.val[8] = xAxis.z;
        this.val[1] = yAxis.x;
        this.val[5] = yAxis.y;
        this.val[9] = yAxis.z;
        this.val[2] = zAxis.x;
        this.val[6] = zAxis.y;
        this.val[10] = zAxis.z;
        this.val[12] = pos.x;
        this.val[13] = pos.y;
        this.val[14] = pos.z;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public Mat3D cpy() {
        return new Mat3D(this);
    }

    public Mat3D trn(Vec3 vector) {
        this.val[12] = this.val[12] + vector.x;
        this.val[13] = this.val[13] + vector.y;
        this.val[14] = this.val[14] + vector.z;
        return this;
    }

    public Mat3D trn(float x, float y, float z) {
        this.val[12] = this.val[12] + x;
        this.val[13] = this.val[13] + y;
        this.val[14] = this.val[14] + z;
        return this;
    }

    public float[] getValues() {
        return this.val;
    }

    public Mat3D mul(Mat3D matrix) {
        Mat3D.mul(this.val, matrix.val);
        return this;
    }

    public Mat3D mulLeft(Mat3D matrix) {
        tmpMat.set(matrix);
        Mat3D.mul(Mat3D.tmpMat.val, this.val);
        return this.set(tmpMat);
    }

    public Mat3D tra() {
        Mat3D.tmp[0] = this.val[0];
        Mat3D.tmp[4] = this.val[1];
        Mat3D.tmp[8] = this.val[2];
        Mat3D.tmp[12] = this.val[3];
        Mat3D.tmp[1] = this.val[4];
        Mat3D.tmp[5] = this.val[5];
        Mat3D.tmp[9] = this.val[6];
        Mat3D.tmp[13] = this.val[7];
        Mat3D.tmp[2] = this.val[8];
        Mat3D.tmp[6] = this.val[9];
        Mat3D.tmp[10] = this.val[10];
        Mat3D.tmp[14] = this.val[11];
        Mat3D.tmp[3] = this.val[12];
        Mat3D.tmp[7] = this.val[13];
        Mat3D.tmp[11] = this.val[14];
        Mat3D.tmp[15] = this.val[15];
        return this.set(tmp);
    }

    public Mat3D idt() {
        this.val[0] = 1.0f;
        this.val[4] = 0.0f;
        this.val[8] = 0.0f;
        this.val[12] = 0.0f;
        this.val[1] = 0.0f;
        this.val[5] = 1.0f;
        this.val[9] = 0.0f;
        this.val[13] = 0.0f;
        this.val[2] = 0.0f;
        this.val[6] = 0.0f;
        this.val[10] = 1.0f;
        this.val[14] = 0.0f;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public Mat3D inv() {
        float l_det = this.val[3] * this.val[6] * this.val[9] * this.val[12] - this.val[2] * this.val[7] * this.val[9] * this.val[12] - this.val[3] * this.val[5] * this.val[10] * this.val[12] + this.val[1] * this.val[7] * this.val[10] * this.val[12] + this.val[2] * this.val[5] * this.val[11] * this.val[12] - this.val[1] * this.val[6] * this.val[11] * this.val[12] - this.val[3] * this.val[6] * this.val[8] * this.val[13] + this.val[2] * this.val[7] * this.val[8] * this.val[13] + this.val[3] * this.val[4] * this.val[10] * this.val[13] - this.val[0] * this.val[7] * this.val[10] * this.val[13] - this.val[2] * this.val[4] * this.val[11] * this.val[13] + this.val[0] * this.val[6] * this.val[11] * this.val[13] + this.val[3] * this.val[5] * this.val[8] * this.val[14] - this.val[1] * this.val[7] * this.val[8] * this.val[14] - this.val[3] * this.val[4] * this.val[9] * this.val[14] + this.val[0] * this.val[7] * this.val[9] * this.val[14] + this.val[1] * this.val[4] * this.val[11] * this.val[14] - this.val[0] * this.val[5] * this.val[11] * this.val[14] - this.val[2] * this.val[5] * this.val[8] * this.val[15] + this.val[1] * this.val[6] * this.val[8] * this.val[15] + this.val[2] * this.val[4] * this.val[9] * this.val[15] - this.val[0] * this.val[6] * this.val[9] * this.val[15] - this.val[1] * this.val[4] * this.val[10] * this.val[15] + this.val[0] * this.val[5] * this.val[10] * this.val[15];
        if (l_det == 0.0f) {
            throw new RuntimeException("non-invertible matrix");
        }
        float inv_det = 1.0f / l_det;
        Mat3D.tmp[0] = this.val[9] * this.val[14] * this.val[7] - this.val[13] * this.val[10] * this.val[7] + this.val[13] * this.val[6] * this.val[11] - this.val[5] * this.val[14] * this.val[11] - this.val[9] * this.val[6] * this.val[15] + this.val[5] * this.val[10] * this.val[15];
        Mat3D.tmp[4] = this.val[12] * this.val[10] * this.val[7] - this.val[8] * this.val[14] * this.val[7] - this.val[12] * this.val[6] * this.val[11] + this.val[4] * this.val[14] * this.val[11] + this.val[8] * this.val[6] * this.val[15] - this.val[4] * this.val[10] * this.val[15];
        Mat3D.tmp[8] = this.val[8] * this.val[13] * this.val[7] - this.val[12] * this.val[9] * this.val[7] + this.val[12] * this.val[5] * this.val[11] - this.val[4] * this.val[13] * this.val[11] - this.val[8] * this.val[5] * this.val[15] + this.val[4] * this.val[9] * this.val[15];
        Mat3D.tmp[12] = this.val[12] * this.val[9] * this.val[6] - this.val[8] * this.val[13] * this.val[6] - this.val[12] * this.val[5] * this.val[10] + this.val[4] * this.val[13] * this.val[10] + this.val[8] * this.val[5] * this.val[14] - this.val[4] * this.val[9] * this.val[14];
        Mat3D.tmp[1] = this.val[13] * this.val[10] * this.val[3] - this.val[9] * this.val[14] * this.val[3] - this.val[13] * this.val[2] * this.val[11] + this.val[1] * this.val[14] * this.val[11] + this.val[9] * this.val[2] * this.val[15] - this.val[1] * this.val[10] * this.val[15];
        Mat3D.tmp[5] = this.val[8] * this.val[14] * this.val[3] - this.val[12] * this.val[10] * this.val[3] + this.val[12] * this.val[2] * this.val[11] - this.val[0] * this.val[14] * this.val[11] - this.val[8] * this.val[2] * this.val[15] + this.val[0] * this.val[10] * this.val[15];
        Mat3D.tmp[9] = this.val[12] * this.val[9] * this.val[3] - this.val[8] * this.val[13] * this.val[3] - this.val[12] * this.val[1] * this.val[11] + this.val[0] * this.val[13] * this.val[11] + this.val[8] * this.val[1] * this.val[15] - this.val[0] * this.val[9] * this.val[15];
        Mat3D.tmp[13] = this.val[8] * this.val[13] * this.val[2] - this.val[12] * this.val[9] * this.val[2] + this.val[12] * this.val[1] * this.val[10] - this.val[0] * this.val[13] * this.val[10] - this.val[8] * this.val[1] * this.val[14] + this.val[0] * this.val[9] * this.val[14];
        Mat3D.tmp[2] = this.val[5] * this.val[14] * this.val[3] - this.val[13] * this.val[6] * this.val[3] + this.val[13] * this.val[2] * this.val[7] - this.val[1] * this.val[14] * this.val[7] - this.val[5] * this.val[2] * this.val[15] + this.val[1] * this.val[6] * this.val[15];
        Mat3D.tmp[6] = this.val[12] * this.val[6] * this.val[3] - this.val[4] * this.val[14] * this.val[3] - this.val[12] * this.val[2] * this.val[7] + this.val[0] * this.val[14] * this.val[7] + this.val[4] * this.val[2] * this.val[15] - this.val[0] * this.val[6] * this.val[15];
        Mat3D.tmp[10] = this.val[4] * this.val[13] * this.val[3] - this.val[12] * this.val[5] * this.val[3] + this.val[12] * this.val[1] * this.val[7] - this.val[0] * this.val[13] * this.val[7] - this.val[4] * this.val[1] * this.val[15] + this.val[0] * this.val[5] * this.val[15];
        Mat3D.tmp[14] = this.val[12] * this.val[5] * this.val[2] - this.val[4] * this.val[13] * this.val[2] - this.val[12] * this.val[1] * this.val[6] + this.val[0] * this.val[13] * this.val[6] + this.val[4] * this.val[1] * this.val[14] - this.val[0] * this.val[5] * this.val[14];
        Mat3D.tmp[3] = this.val[9] * this.val[6] * this.val[3] - this.val[5] * this.val[10] * this.val[3] - this.val[9] * this.val[2] * this.val[7] + this.val[1] * this.val[10] * this.val[7] + this.val[5] * this.val[2] * this.val[11] - this.val[1] * this.val[6] * this.val[11];
        Mat3D.tmp[7] = this.val[4] * this.val[10] * this.val[3] - this.val[8] * this.val[6] * this.val[3] + this.val[8] * this.val[2] * this.val[7] - this.val[0] * this.val[10] * this.val[7] - this.val[4] * this.val[2] * this.val[11] + this.val[0] * this.val[6] * this.val[11];
        Mat3D.tmp[11] = this.val[8] * this.val[5] * this.val[3] - this.val[4] * this.val[9] * this.val[3] - this.val[8] * this.val[1] * this.val[7] + this.val[0] * this.val[9] * this.val[7] + this.val[4] * this.val[1] * this.val[11] - this.val[0] * this.val[5] * this.val[11];
        Mat3D.tmp[15] = this.val[4] * this.val[9] * this.val[2] - this.val[8] * this.val[5] * this.val[2] + this.val[8] * this.val[1] * this.val[6] - this.val[0] * this.val[9] * this.val[6] - this.val[4] * this.val[1] * this.val[10] + this.val[0] * this.val[5] * this.val[10];
        this.val[0] = tmp[0] * inv_det;
        this.val[4] = tmp[4] * inv_det;
        this.val[8] = tmp[8] * inv_det;
        this.val[12] = tmp[12] * inv_det;
        this.val[1] = tmp[1] * inv_det;
        this.val[5] = tmp[5] * inv_det;
        this.val[9] = tmp[9] * inv_det;
        this.val[13] = tmp[13] * inv_det;
        this.val[2] = tmp[2] * inv_det;
        this.val[6] = tmp[6] * inv_det;
        this.val[10] = tmp[10] * inv_det;
        this.val[14] = tmp[14] * inv_det;
        this.val[3] = tmp[3] * inv_det;
        this.val[7] = tmp[7] * inv_det;
        this.val[11] = tmp[11] * inv_det;
        this.val[15] = tmp[15] * inv_det;
        return this;
    }

    public float det() {
        return this.val[3] * this.val[6] * this.val[9] * this.val[12] - this.val[2] * this.val[7] * this.val[9] * this.val[12] - this.val[3] * this.val[5] * this.val[10] * this.val[12] + this.val[1] * this.val[7] * this.val[10] * this.val[12] + this.val[2] * this.val[5] * this.val[11] * this.val[12] - this.val[1] * this.val[6] * this.val[11] * this.val[12] - this.val[3] * this.val[6] * this.val[8] * this.val[13] + this.val[2] * this.val[7] * this.val[8] * this.val[13] + this.val[3] * this.val[4] * this.val[10] * this.val[13] - this.val[0] * this.val[7] * this.val[10] * this.val[13] - this.val[2] * this.val[4] * this.val[11] * this.val[13] + this.val[0] * this.val[6] * this.val[11] * this.val[13] + this.val[3] * this.val[5] * this.val[8] * this.val[14] - this.val[1] * this.val[7] * this.val[8] * this.val[14] - this.val[3] * this.val[4] * this.val[9] * this.val[14] + this.val[0] * this.val[7] * this.val[9] * this.val[14] + this.val[1] * this.val[4] * this.val[11] * this.val[14] - this.val[0] * this.val[5] * this.val[11] * this.val[14] - this.val[2] * this.val[5] * this.val[8] * this.val[15] + this.val[1] * this.val[6] * this.val[8] * this.val[15] + this.val[2] * this.val[4] * this.val[9] * this.val[15] - this.val[0] * this.val[6] * this.val[9] * this.val[15] - this.val[1] * this.val[4] * this.val[10] * this.val[15] + this.val[0] * this.val[5] * this.val[10] * this.val[15];
    }

    public float det3x3() {
        return this.val[0] * this.val[5] * this.val[10] + this.val[4] * this.val[9] * this.val[2] + this.val[8] * this.val[1] * this.val[6] - this.val[0] * this.val[9] * this.val[6] - this.val[4] * this.val[1] * this.val[10] - this.val[8] * this.val[5] * this.val[2];
    }

    public Mat3D setToProjection(float near, float far, float fovy, float aspectRatio) {
        this.idt();
        float l_fd = (float)(1.0 / Math.tan((double)fovy * (Math.PI / 180) / 2.0));
        float l_a1 = (far + near) / (near - far);
        float l_a2 = 2.0f * far * near / (near - far);
        this.val[0] = l_fd / aspectRatio;
        this.val[1] = 0.0f;
        this.val[2] = 0.0f;
        this.val[3] = 0.0f;
        this.val[4] = 0.0f;
        this.val[5] = l_fd;
        this.val[6] = 0.0f;
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = l_a1;
        this.val[11] = -1.0f;
        this.val[12] = 0.0f;
        this.val[13] = 0.0f;
        this.val[14] = l_a2;
        this.val[15] = 0.0f;
        return this;
    }

    public Mat3D setToProjection(float left, float right, float bottom, float top, float near, float far) {
        float x = 2.0f * near / (right - left);
        float y = 2.0f * near / (top - bottom);
        float a = (right + left) / (right - left);
        float b = (top + bottom) / (top - bottom);
        float l_a1 = (far + near) / (near - far);
        float l_a2 = 2.0f * far * near / (near - far);
        this.val[0] = x;
        this.val[1] = 0.0f;
        this.val[2] = 0.0f;
        this.val[3] = 0.0f;
        this.val[4] = 0.0f;
        this.val[5] = y;
        this.val[6] = 0.0f;
        this.val[7] = 0.0f;
        this.val[8] = a;
        this.val[9] = b;
        this.val[10] = l_a1;
        this.val[11] = -1.0f;
        this.val[12] = 0.0f;
        this.val[13] = 0.0f;
        this.val[14] = l_a2;
        this.val[15] = 0.0f;
        return this;
    }

    public Mat3D setToOrtho2D(float x, float y, float width, float height) {
        this.setToOrtho(x, x + width, y, y + height, 0.0f, 1.0f);
        return this;
    }

    public Mat3D setToOrtho2D(float x, float y, float width, float height, float near, float far) {
        this.setToOrtho(x, x + width, y, y + height, near, far);
        return this;
    }

    public Mat3D setToOrtho(float left, float right, float bottom, float top, float near, float far) {
        this.idt();
        float x_orth = 2.0f / (right - left);
        float y_orth = 2.0f / (top - bottom);
        float z_orth = -2.0f / (far - near);
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        this.val[0] = x_orth;
        this.val[1] = 0.0f;
        this.val[2] = 0.0f;
        this.val[3] = 0.0f;
        this.val[4] = 0.0f;
        this.val[5] = y_orth;
        this.val[6] = 0.0f;
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = z_orth;
        this.val[11] = 0.0f;
        this.val[12] = tx;
        this.val[13] = ty;
        this.val[14] = tz;
        this.val[15] = 1.0f;
        return this;
    }

    public Mat3D setTranslation(Vec3 vector) {
        this.val[12] = vector.x;
        this.val[13] = vector.y;
        this.val[14] = vector.z;
        return this;
    }

    public Mat3D setTranslation(float x, float y, float z) {
        this.val[12] = x;
        this.val[13] = y;
        this.val[14] = z;
        return this;
    }

    public Mat3D setToTranslation(Vec3 vector) {
        this.idt();
        this.val[12] = vector.x;
        this.val[13] = vector.y;
        this.val[14] = vector.z;
        return this;
    }

    public Mat3D setToTranslation(float x, float y, float z) {
        this.idt();
        this.val[12] = x;
        this.val[13] = y;
        this.val[14] = z;
        return this;
    }

    public Mat3D setToTranslationAndScaling(Vec3 translation, Vec3 scaling) {
        this.idt();
        this.val[12] = translation.x;
        this.val[13] = translation.y;
        this.val[14] = translation.z;
        this.val[0] = scaling.x;
        this.val[5] = scaling.y;
        this.val[10] = scaling.z;
        return this;
    }

    public Mat3D setToTranslationAndScaling(float translationX, float translationY, float translationZ, float scalingX, float scalingY, float scalingZ) {
        this.idt();
        this.val[12] = translationX;
        this.val[13] = translationY;
        this.val[14] = translationZ;
        this.val[0] = scalingX;
        this.val[5] = scalingY;
        this.val[10] = scalingZ;
        return this;
    }

    public Mat3D setToRotation(Vec3 axis, float degrees) {
        if (degrees == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(quat.set(axis, degrees));
    }

    public Mat3D setToRotationRad(Vec3 axis, float radians) {
        if (radians == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(quat.setFromAxisRad(axis, radians));
    }

    public Mat3D setToRotation(float axisX, float axisY, float axisZ, float degrees) {
        if (degrees == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(quat.setFromAxis(axisX, axisY, axisZ, degrees));
    }

    public Mat3D setToRotationRad(float axisX, float axisY, float axisZ, float radians) {
        if (radians == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(quat.setFromAxisRad(axisX, axisY, axisZ, radians));
    }

    public Mat3D setToRotation(Vec3 v1, Vec3 v2) {
        return this.set(quat.setFromCross(v1, v2));
    }

    public Mat3D setToRotation(float x1, float y1, float z1, float x2, float y2, float z2) {
        return this.set(quat.setFromCross(x1, y1, z1, x2, y2, z2));
    }

    public Mat3D setFromEulerAngles(float yaw, float pitch, float roll) {
        quat.setEulerAngles(yaw, pitch, roll);
        return this.set(quat);
    }

    public Mat3D setFromEulerAnglesRad(float yaw, float pitch, float roll) {
        quat.setEulerAnglesRad(yaw, pitch, roll);
        return this.set(quat);
    }

    public Mat3D setToScaling(Vec3 vector) {
        this.idt();
        this.val[0] = vector.x;
        this.val[5] = vector.y;
        this.val[10] = vector.z;
        return this;
    }

    public Mat3D setToScaling(float x, float y, float z) {
        this.idt();
        this.val[0] = x;
        this.val[5] = y;
        this.val[10] = z;
        return this;
    }

    public Mat3D setToLookAt(Vec3 direction, Vec3 up) {
        l_vez.set(direction).nor();
        l_vex.set(direction).nor();
        l_vex.crs(up).nor();
        l_vey.set(l_vex).crs(l_vez).nor();
        this.idt();
        this.val[0] = Mat3D.l_vex.x;
        this.val[4] = Mat3D.l_vex.y;
        this.val[8] = Mat3D.l_vex.z;
        this.val[1] = Mat3D.l_vey.x;
        this.val[5] = Mat3D.l_vey.y;
        this.val[9] = Mat3D.l_vey.z;
        this.val[2] = -Mat3D.l_vez.x;
        this.val[6] = -Mat3D.l_vez.y;
        this.val[10] = -Mat3D.l_vez.z;
        return this;
    }

    public Mat3D setToLookAt(Vec3 position, Vec3 target, Vec3 up) {
        tmpVec.set(target).sub(position);
        this.setToLookAt(tmpVec, up);
        this.mul(tmpMat.setToTranslation(-position.x, -position.y, -position.z));
        return this;
    }

    public Mat3D setToWorld(Vec3 position, Vec3 forward, Vec3 up) {
        tmpForward.set(forward).nor();
        right.set(tmpForward).crs(up).nor();
        tmpUp.set(right).crs(tmpForward).nor();
        this.set(right, tmpUp, tmpForward.scl(-1.0f), position);
        return this;
    }

    public String toString() {
        return "[" + this.val[0] + "|" + this.val[4] + "|" + this.val[8] + "|" + this.val[12] + "]\n[" + this.val[1] + "|" + this.val[5] + "|" + this.val[9] + "|" + this.val[13] + "]\n[" + this.val[2] + "|" + this.val[6] + "|" + this.val[10] + "|" + this.val[14] + "]\n[" + this.val[3] + "|" + this.val[7] + "|" + this.val[11] + "|" + this.val[15] + "]\n";
    }

    public Mat3D lerp(Mat3D matrix, float alpha) {
        for (int i = 0; i < 16; ++i) {
            this.val[i] = this.val[i] * (1.0f - alpha) + matrix.val[i] * alpha;
        }
        return this;
    }

    public Mat3D avg(Mat3D other, float w) {
        this.getScale(tmpVec);
        other.getScale(tmpForward);
        this.getRotation(quat);
        other.getRotation(quat2);
        this.getTranslation(tmpUp);
        other.getTranslation(right);
        this.setToScaling(tmpVec.scl(w).add(tmpForward.scl(1.0f - w)));
        this.rotate(quat.slerp(quat2, 1.0f - w));
        this.setTranslation(tmpUp.scl(w).add(right.scl(1.0f - w)));
        return this;
    }

    public Mat3D avg(Mat3D[] t) {
        float w = 1.0f / (float)t.length;
        tmpVec.set(t[0].getScale(tmpUp).scl(w));
        quat.set(t[0].getRotation(quat2).exp(w));
        tmpForward.set(t[0].getTranslation(tmpUp).scl(w));
        for (int i = 1; i < t.length; ++i) {
            tmpVec.add(t[i].getScale(tmpUp).scl(w));
            quat.mul(t[i].getRotation(quat2).exp(w));
            tmpForward.add(t[i].getTranslation(tmpUp).scl(w));
        }
        quat.nor();
        this.setToScaling(tmpVec);
        this.rotate(quat);
        this.setTranslation(tmpForward);
        return this;
    }

    public Mat3D avg(Mat3D[] t, float[] w) {
        tmpVec.set(t[0].getScale(tmpUp).scl(w[0]));
        quat.set(t[0].getRotation(quat2).exp(w[0]));
        tmpForward.set(t[0].getTranslation(tmpUp).scl(w[0]));
        for (int i = 1; i < t.length; ++i) {
            tmpVec.add(t[i].getScale(tmpUp).scl(w[i]));
            quat.mul(t[i].getRotation(quat2).exp(w[i]));
            tmpForward.add(t[i].getTranslation(tmpUp).scl(w[i]));
        }
        quat.nor();
        this.setToScaling(tmpVec);
        this.rotate(quat);
        this.setTranslation(tmpForward);
        return this;
    }

    public Mat3D set(Mat mat) {
        this.val[0] = mat.val[0];
        this.val[1] = mat.val[1];
        this.val[2] = mat.val[2];
        this.val[3] = 0.0f;
        this.val[4] = mat.val[3];
        this.val[5] = mat.val[4];
        this.val[6] = mat.val[5];
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = 1.0f;
        this.val[11] = 0.0f;
        this.val[12] = mat.val[6];
        this.val[13] = mat.val[7];
        this.val[14] = 0.0f;
        this.val[15] = mat.val[8];
        return this;
    }

    public Mat3D set(Affine2 affine) {
        this.val[0] = affine.m00;
        this.val[1] = affine.m10;
        this.val[2] = 0.0f;
        this.val[3] = 0.0f;
        this.val[4] = affine.m01;
        this.val[5] = affine.m11;
        this.val[6] = 0.0f;
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = 1.0f;
        this.val[11] = 0.0f;
        this.val[12] = affine.m02;
        this.val[13] = affine.m12;
        this.val[14] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public Mat3D setAsAffine(Affine2 affine) {
        this.val[0] = affine.m00;
        this.val[1] = affine.m10;
        this.val[4] = affine.m01;
        this.val[5] = affine.m11;
        this.val[12] = affine.m02;
        this.val[13] = affine.m12;
        return this;
    }

    public Mat3D setAsAffine(Mat3D mat) {
        this.val[0] = mat.val[0];
        this.val[1] = mat.val[1];
        this.val[4] = mat.val[4];
        this.val[5] = mat.val[5];
        this.val[12] = mat.val[12];
        this.val[13] = mat.val[13];
        return this;
    }

    public Mat3D scl(Vec3 scale) {
        this.val[0] = this.val[0] * scale.x;
        this.val[5] = this.val[5] * scale.y;
        this.val[10] = this.val[10] * scale.z;
        return this;
    }

    public Mat3D scl(float x, float y, float z) {
        this.val[0] = this.val[0] * x;
        this.val[5] = this.val[5] * y;
        this.val[10] = this.val[10] * z;
        return this;
    }

    public Mat3D scl(float scale) {
        this.val[0] = this.val[0] * scale;
        this.val[5] = this.val[5] * scale;
        this.val[10] = this.val[10] * scale;
        return this;
    }

    public Vec3 getTranslation(Vec3 position) {
        position.x = this.val[12];
        position.y = this.val[13];
        position.z = this.val[14];
        return position;
    }

    public Quat getRotation(Quat rotation, boolean normalizeAxes) {
        return rotation.setFromMatrix(normalizeAxes, this);
    }

    public Quat getRotation(Quat rotation) {
        return rotation.setFromMatrix(this);
    }

    public float getScaleXSquared() {
        return this.val[0] * this.val[0] + this.val[4] * this.val[4] + this.val[8] * this.val[8];
    }

    public float getScaleYSquared() {
        return this.val[1] * this.val[1] + this.val[5] * this.val[5] + this.val[9] * this.val[9];
    }

    public float getScaleZSquared() {
        return this.val[2] * this.val[2] + this.val[6] * this.val[6] + this.val[10] * this.val[10];
    }

    public float getScaleX() {
        return Mathf.zero(this.val[4]) && Mathf.zero(this.val[8]) ? Math.abs(this.val[0]) : (float)Math.sqrt(this.getScaleXSquared());
    }

    public float getScaleY() {
        return Mathf.zero(this.val[1]) && Mathf.zero(this.val[9]) ? Math.abs(this.val[5]) : (float)Math.sqrt(this.getScaleYSquared());
    }

    public float getScaleZ() {
        return Mathf.zero(this.val[2]) && Mathf.zero(this.val[6]) ? Math.abs(this.val[10]) : (float)Math.sqrt(this.getScaleZSquared());
    }

    public Vec3 getScale(Vec3 scale) {
        return scale.set(this.getScaleX(), this.getScaleY(), this.getScaleZ());
    }

    public Mat3D toNormalMatrix() {
        this.val[12] = 0.0f;
        this.val[13] = 0.0f;
        this.val[14] = 0.0f;
        return this.inv().tra();
    }

    public static void mul(float[] mata, float[] matb) {
        Mat3D.tmp[0] = mata[0] * matb[0] + mata[4] * matb[1] + mata[8] * matb[2] + mata[12] * matb[3];
        Mat3D.tmp[4] = mata[0] * matb[4] + mata[4] * matb[5] + mata[8] * matb[6] + mata[12] * matb[7];
        Mat3D.tmp[8] = mata[0] * matb[8] + mata[4] * matb[9] + mata[8] * matb[10] + mata[12] * matb[11];
        Mat3D.tmp[12] = mata[0] * matb[12] + mata[4] * matb[13] + mata[8] * matb[14] + mata[12] * matb[15];
        Mat3D.tmp[1] = mata[1] * matb[0] + mata[5] * matb[1] + mata[9] * matb[2] + mata[13] * matb[3];
        Mat3D.tmp[5] = mata[1] * matb[4] + mata[5] * matb[5] + mata[9] * matb[6] + mata[13] * matb[7];
        Mat3D.tmp[9] = mata[1] * matb[8] + mata[5] * matb[9] + mata[9] * matb[10] + mata[13] * matb[11];
        Mat3D.tmp[13] = mata[1] * matb[12] + mata[5] * matb[13] + mata[9] * matb[14] + mata[13] * matb[15];
        Mat3D.tmp[2] = mata[2] * matb[0] + mata[6] * matb[1] + mata[10] * matb[2] + mata[14] * matb[3];
        Mat3D.tmp[6] = mata[2] * matb[4] + mata[6] * matb[5] + mata[10] * matb[6] + mata[14] * matb[7];
        Mat3D.tmp[10] = mata[2] * matb[8] + mata[6] * matb[9] + mata[10] * matb[10] + mata[14] * matb[11];
        Mat3D.tmp[14] = mata[2] * matb[12] + mata[6] * matb[13] + mata[10] * matb[14] + mata[14] * matb[15];
        Mat3D.tmp[3] = mata[3] * matb[0] + mata[7] * matb[1] + mata[11] * matb[2] + mata[15] * matb[3];
        Mat3D.tmp[7] = mata[3] * matb[4] + mata[7] * matb[5] + mata[11] * matb[6] + mata[15] * matb[7];
        Mat3D.tmp[11] = mata[3] * matb[8] + mata[7] * matb[9] + mata[11] * matb[10] + mata[15] * matb[11];
        Mat3D.tmp[15] = mata[3] * matb[12] + mata[7] * matb[13] + mata[11] * matb[14] + mata[15] * matb[15];
        System.arraycopy(tmp, 0, mata, 0, 16);
    }

    public static void mulVec(float[] mat, float[] vec) {
        float x = vec[0] * mat[0] + vec[1] * mat[4] + vec[2] * mat[8] + mat[12];
        float y = vec[0] * mat[1] + vec[1] * mat[5] + vec[2] * mat[9] + mat[13];
        float z = vec[0] * mat[2] + vec[1] * mat[6] + vec[2] * mat[10] + mat[14];
        vec[0] = x;
        vec[1] = y;
        vec[2] = z;
    }

    public static void prj(float[] mat, float[] vec) {
        float invw = 1.0f / (vec[0] * mat[3] + vec[1] * mat[7] + vec[2] * mat[11] + mat[15]);
        float x = (vec[0] * mat[0] + vec[1] * mat[4] + vec[2] * mat[8] + mat[12]) * invw;
        float y = (vec[0] * mat[1] + vec[1] * mat[5] + vec[2] * mat[9] + mat[13]) * invw;
        float z = (vec[0] * mat[2] + vec[1] * mat[6] + vec[2] * mat[10] + mat[14]) * invw;
        vec[0] = x;
        vec[1] = y;
        vec[2] = z;
    }

    public static void rot(float[] mat, float[] vec) {
        float x = vec[0] * mat[0] + vec[1] * mat[4] + vec[2] * mat[8];
        float y = vec[0] * mat[1] + vec[1] * mat[5] + vec[2] * mat[9];
        float z = vec[0] * mat[2] + vec[1] * mat[6] + vec[2] * mat[10];
        vec[0] = x;
        vec[1] = y;
        vec[2] = z;
    }

    public static boolean inv(float[] val) {
        float ldet = Mat3D.det(val);
        if (ldet == 0.0f) {
            return false;
        }
        Mat3D.tmp[0] = val[9] * val[14] * val[7] - val[13] * val[10] * val[7] + val[13] * val[6] * val[11] - val[5] * val[14] * val[11] - val[9] * val[6] * val[15] + val[5] * val[10] * val[15];
        Mat3D.tmp[4] = val[12] * val[10] * val[7] - val[8] * val[14] * val[7] - val[12] * val[6] * val[11] + val[4] * val[14] * val[11] + val[8] * val[6] * val[15] - val[4] * val[10] * val[15];
        Mat3D.tmp[8] = val[8] * val[13] * val[7] - val[12] * val[9] * val[7] + val[12] * val[5] * val[11] - val[4] * val[13] * val[11] - val[8] * val[5] * val[15] + val[4] * val[9] * val[15];
        Mat3D.tmp[12] = val[12] * val[9] * val[6] - val[8] * val[13] * val[6] - val[12] * val[5] * val[10] + val[4] * val[13] * val[10] + val[8] * val[5] * val[14] - val[4] * val[9] * val[14];
        Mat3D.tmp[1] = val[13] * val[10] * val[3] - val[9] * val[14] * val[3] - val[13] * val[2] * val[11] + val[1] * val[14] * val[11] + val[9] * val[2] * val[15] - val[1] * val[10] * val[15];
        Mat3D.tmp[5] = val[8] * val[14] * val[3] - val[12] * val[10] * val[3] + val[12] * val[2] * val[11] - val[0] * val[14] * val[11] - val[8] * val[2] * val[15] + val[0] * val[10] * val[15];
        Mat3D.tmp[9] = val[12] * val[9] * val[3] - val[8] * val[13] * val[3] - val[12] * val[1] * val[11] + val[0] * val[13] * val[11] + val[8] * val[1] * val[15] - val[0] * val[9] * val[15];
        Mat3D.tmp[13] = val[8] * val[13] * val[2] - val[12] * val[9] * val[2] + val[12] * val[1] * val[10] - val[0] * val[13] * val[10] - val[8] * val[1] * val[14] + val[0] * val[9] * val[14];
        Mat3D.tmp[2] = val[5] * val[14] * val[3] - val[13] * val[6] * val[3] + val[13] * val[2] * val[7] - val[1] * val[14] * val[7] - val[5] * val[2] * val[15] + val[1] * val[6] * val[15];
        Mat3D.tmp[6] = val[12] * val[6] * val[3] - val[4] * val[14] * val[3] - val[12] * val[2] * val[7] + val[0] * val[14] * val[7] + val[4] * val[2] * val[15] - val[0] * val[6] * val[15];
        Mat3D.tmp[10] = val[4] * val[13] * val[3] - val[12] * val[5] * val[3] + val[12] * val[1] * val[7] - val[0] * val[13] * val[7] - val[4] * val[1] * val[15] + val[0] * val[5] * val[15];
        Mat3D.tmp[14] = val[12] * val[5] * val[2] - val[4] * val[13] * val[2] - val[12] * val[1] * val[6] + val[0] * val[13] * val[6] + val[4] * val[1] * val[14] - val[0] * val[5] * val[14];
        Mat3D.tmp[3] = val[9] * val[6] * val[3] - val[5] * val[10] * val[3] - val[9] * val[2] * val[7] + val[1] * val[10] * val[7] + val[5] * val[2] * val[11] - val[1] * val[6] * val[11];
        Mat3D.tmp[7] = val[4] * val[10] * val[3] - val[8] * val[6] * val[3] + val[8] * val[2] * val[7] - val[0] * val[10] * val[7] - val[4] * val[2] * val[11] + val[0] * val[6] * val[11];
        Mat3D.tmp[11] = val[8] * val[5] * val[3] - val[4] * val[9] * val[3] - val[8] * val[1] * val[7] + val[0] * val[9] * val[7] + val[4] * val[1] * val[11] - val[0] * val[5] * val[11];
        Mat3D.tmp[15] = val[4] * val[9] * val[2] - val[8] * val[5] * val[2] + val[8] * val[1] * val[6] - val[0] * val[9] * val[6] - val[4] * val[1] * val[10] + val[0] * val[5] * val[10];
        float inv_det = 1.0f / ldet;
        val[0] = tmp[0] * inv_det;
        val[4] = tmp[4] * inv_det;
        val[8] = tmp[8] * inv_det;
        val[12] = tmp[12] * inv_det;
        val[1] = tmp[1] * inv_det;
        val[5] = tmp[5] * inv_det;
        val[9] = tmp[9] * inv_det;
        val[13] = tmp[13] * inv_det;
        val[2] = tmp[2] * inv_det;
        val[6] = tmp[6] * inv_det;
        val[10] = tmp[10] * inv_det;
        val[14] = tmp[14] * inv_det;
        val[3] = tmp[3] * inv_det;
        val[7] = tmp[7] * inv_det;
        val[11] = tmp[11] * inv_det;
        val[15] = tmp[15] * inv_det;
        return true;
    }

    public static float det(float[] val) {
        return val[3] * val[6] * val[9] * val[12] - val[2] * val[7] * val[9] * val[12] - val[3] * val[5] * val[10] * val[12] + val[1] * val[7] * val[10] * val[12] + val[2] * val[5] * val[11] * val[12] - val[1] * val[6] * val[11] * val[12] - val[3] * val[6] * val[8] * val[13] + val[2] * val[7] * val[8] * val[13] + val[3] * val[4] * val[10] * val[13] - val[0] * val[7] * val[10] * val[13] - val[2] * val[4] * val[11] * val[13] + val[0] * val[6] * val[11] * val[13] + val[3] * val[5] * val[8] * val[14] - val[1] * val[7] * val[8] * val[14] - val[3] * val[4] * val[9] * val[14] + val[0] * val[7] * val[9] * val[14] + val[1] * val[4] * val[11] * val[14] - val[0] * val[5] * val[11] * val[14] - val[2] * val[5] * val[8] * val[15] + val[1] * val[6] * val[8] * val[15] + val[2] * val[4] * val[9] * val[15] - val[0] * val[6] * val[9] * val[15] - val[1] * val[4] * val[10] * val[15] + val[0] * val[5] * val[10] * val[15];
    }

    public Mat3D translate(Vec3 translation) {
        return this.translate(translation.x, translation.y, translation.z);
    }

    public Mat3D translate(float x, float y, float z) {
        Mat3D.tmp[0] = 1.0f;
        Mat3D.tmp[4] = 0.0f;
        Mat3D.tmp[8] = 0.0f;
        Mat3D.tmp[12] = x;
        Mat3D.tmp[1] = 0.0f;
        Mat3D.tmp[5] = 1.0f;
        Mat3D.tmp[9] = 0.0f;
        Mat3D.tmp[13] = y;
        Mat3D.tmp[2] = 0.0f;
        Mat3D.tmp[6] = 0.0f;
        Mat3D.tmp[10] = 1.0f;
        Mat3D.tmp[14] = z;
        Mat3D.tmp[3] = 0.0f;
        Mat3D.tmp[7] = 0.0f;
        Mat3D.tmp[11] = 0.0f;
        Mat3D.tmp[15] = 1.0f;
        Mat3D.mul(this.val, tmp);
        return this;
    }

    public Mat3D rotate(Vec3 axis, float degrees) {
        if (degrees == 0.0f) {
            return this;
        }
        quat.set(axis, degrees);
        return this.rotate(quat);
    }

    public Mat3D rotateRad(Vec3 axis, float radians) {
        if (radians == 0.0f) {
            return this;
        }
        quat.setFromAxisRad(axis, radians);
        return this.rotate(quat);
    }

    public Mat3D rotate(float axisX, float axisY, float axisZ, float degrees) {
        if (degrees == 0.0f) {
            return this;
        }
        quat.setFromAxis(axisX, axisY, axisZ, degrees);
        return this.rotate(quat);
    }

    public Mat3D rotateRad(float axisX, float axisY, float axisZ, float radians) {
        if (radians == 0.0f) {
            return this;
        }
        quat.setFromAxisRad(axisX, axisY, axisZ, radians);
        return this.rotate(quat);
    }

    public Mat3D rotate(Quat rotation) {
        rotation.toMatrix(tmp);
        Mat3D.mul(this.val, tmp);
        return this;
    }

    public Mat3D rotate(Vec3 v1, Vec3 v2) {
        return this.rotate(quat.setFromCross(v1, v2));
    }

    public Mat3D scale(float scaleX, float scaleY, float scaleZ) {
        Mat3D.tmp[0] = scaleX;
        Mat3D.tmp[4] = 0.0f;
        Mat3D.tmp[8] = 0.0f;
        Mat3D.tmp[12] = 0.0f;
        Mat3D.tmp[1] = 0.0f;
        Mat3D.tmp[5] = scaleY;
        Mat3D.tmp[9] = 0.0f;
        Mat3D.tmp[13] = 0.0f;
        Mat3D.tmp[2] = 0.0f;
        Mat3D.tmp[6] = 0.0f;
        Mat3D.tmp[10] = scaleZ;
        Mat3D.tmp[14] = 0.0f;
        Mat3D.tmp[3] = 0.0f;
        Mat3D.tmp[7] = 0.0f;
        Mat3D.tmp[11] = 0.0f;
        Mat3D.tmp[15] = 1.0f;
        Mat3D.mul(this.val, tmp);
        return this;
    }

    public void extract4x3Matrix(float[] dst) {
        dst[0] = this.val[0];
        dst[1] = this.val[1];
        dst[2] = this.val[2];
        dst[3] = this.val[4];
        dst[4] = this.val[5];
        dst[5] = this.val[6];
        dst[6] = this.val[8];
        dst[7] = this.val[9];
        dst[8] = this.val[10];
        dst[9] = this.val[12];
        dst[10] = this.val[13];
        dst[11] = this.val[14];
    }

    public boolean hasRotationOrScaling() {
        return !Mathf.equal(this.val[0], 1.0f) || !Mathf.equal(this.val[5], 1.0f) || !Mathf.equal(this.val[10], 1.0f) || !Mathf.zero(this.val[4]) || !Mathf.zero(this.val[8]) || !Mathf.zero(this.val[1]) || !Mathf.zero(this.val[9]) || !Mathf.zero(this.val[2]) || !Mathf.zero(this.val[6]);
    }

    public static Vec3 prj(Vec3 v, Mat3D matrix) {
        float[] lmat = matrix.val;
        float lw = 1.0f / (v.x * lmat[3] + v.y * lmat[7] + v.z * lmat[11] + lmat[15]);
        return v.set((v.x * lmat[0] + v.y * lmat[4] + v.z * lmat[8] + lmat[12]) * lw, (v.x * lmat[1] + v.y * lmat[5] + v.z * lmat[9] + lmat[13]) * lw, (v.x * lmat[2] + v.y * lmat[6] + v.z * lmat[10] + lmat[14]) * lw);
    }

    public static Vec3 rot(Vec3 v, Mat3D matrix) {
        float[] lmat = matrix.val;
        return v.set(v.x * lmat[0] + v.y * lmat[4] + v.z * lmat[8], v.x * lmat[1] + v.y * lmat[5] + v.z * lmat[9], v.x * lmat[2] + v.y * lmat[6] + v.z * lmat[10]);
    }

    public static Vec3 unrotate(Vec3 v, Mat3D matrix) {
        float[] lmat = matrix.val;
        return v.set(v.x * lmat[0] + v.y * lmat[1] + v.z * lmat[2], v.x * lmat[4] + v.y * lmat[5] + v.z * lmat[6], v.x * lmat[8] + v.y * lmat[9] + v.z * lmat[10]);
    }

    public static Vec3 untransform(Vec3 v, Mat3D matrix) {
        float[] lmat = matrix.val;
        v.x -= lmat[12];
        v.y -= lmat[12];
        v.z -= lmat[12];
        return v.set(v.x * lmat[0] + v.y * lmat[1] + v.z * lmat[2], v.x * lmat[4] + v.y * lmat[5] + v.z * lmat[6], v.x * lmat[8] + v.y * lmat[9] + v.z * lmat[10]);
    }
}

