/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.func.Cons;
import arc.math.geom.Rect;
import arc.struct.Seq;
import java.util.Iterator;

public class QuadTree<T extends QuadTreeObject> {
    protected final Rect tmp = new Rect();
    protected static final int maxObjectsPerNode = 5;
    public Rect bounds;
    public Seq<T> objects = new Seq(false);
    public QuadTree<T> botLeft;
    public QuadTree<T> botRight;
    public QuadTree<T> topLeft;
    public QuadTree<T> topRight;
    public boolean leaf = true;

    public QuadTree(Rect bounds) {
        this.bounds = bounds;
    }

    private void split() {
        if (!this.leaf) {
            return;
        }
        float subW = this.bounds.width / 2.0f;
        float subH = this.bounds.height / 2.0f;
        if (this.botLeft == null) {
            this.botLeft = this.newChild(new Rect(this.bounds.x, this.bounds.y, subW, subH));
            this.botRight = this.newChild(new Rect(this.bounds.x + subW, this.bounds.y, subW, subH));
            this.topLeft = this.newChild(new Rect(this.bounds.x, this.bounds.y + subH, subW, subH));
            this.topRight = this.newChild(new Rect(this.bounds.x + subW, this.bounds.y + subH, subW, subH));
        }
        this.leaf = false;
        Iterator<T> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            QuadTreeObject obj = (QuadTreeObject)iterator.next();
            this.hitbox(obj);
            QuadTree<QuadTreeObject> child = this.getFittingChild(this.tmp);
            if (child == null) continue;
            child.insert(obj);
            iterator.remove();
        }
    }

    private void unsplit() {
        if (this.leaf) {
            return;
        }
        this.objects.addAll(this.botLeft.objects);
        this.objects.addAll(this.botRight.objects);
        this.objects.addAll(this.topLeft.objects);
        this.objects.addAll(this.topRight.objects);
        this.leaf = true;
    }

    public void insert(T obj) {
        this.hitbox(obj);
        if (!this.bounds.overlaps(this.tmp)) {
            return;
        }
        if (this.leaf && this.objects.size + 1 > 5) {
            this.split();
        }
        if (this.leaf) {
            this.objects.add(obj);
        } else {
            this.hitbox(obj);
            QuadTree<T> child = this.getFittingChild(this.tmp);
            if (child != null) {
                child.insert(obj);
            } else {
                this.objects.add(obj);
            }
        }
    }

    public void remove(T obj) {
        if (this.leaf) {
            this.objects.remove(obj, true);
        } else {
            this.hitbox(obj);
            QuadTree<T> child = this.getFittingChild(this.tmp);
            if (child != null) {
                child.remove(obj);
            } else {
                this.objects.remove(obj, true);
            }
            if (this.getTotalObjectCount() <= 5) {
                this.unsplit();
            }
        }
    }

    public void clear() {
        this.objects.clear();
        if (!this.leaf) {
            this.topLeft.clear();
            this.topRight.clear();
            this.botLeft.clear();
            this.botRight.clear();
        }
        this.leaf = true;
    }

    private QuadTree<T> getFittingChild(Rect boundingBox) {
        boolean bottomQuadrant;
        float verticalMidpoint = this.bounds.x + this.bounds.width / 2.0f;
        float horizontalMidpoint = this.bounds.y + this.bounds.height / 2.0f;
        boolean topQuadrant = boundingBox.y > horizontalMidpoint;
        boolean bl = bottomQuadrant = boundingBox.y < horizontalMidpoint && boundingBox.y + boundingBox.height < horizontalMidpoint;
        if (boundingBox.x < verticalMidpoint && boundingBox.x + boundingBox.width < verticalMidpoint) {
            if (topQuadrant) {
                return this.topLeft;
            }
            if (bottomQuadrant) {
                return this.botLeft;
            }
        } else if (boundingBox.x > verticalMidpoint) {
            if (topQuadrant) {
                return this.topRight;
            }
            if (bottomQuadrant) {
                return this.botRight;
            }
        }
        return null;
    }

    public void intersect(float x, float y, float width, float height, Cons<T> out) {
        if (!this.leaf) {
            if (this.topLeft.bounds.overlaps(x, y, width, height)) {
                this.topLeft.intersect(x, y, width, height, out);
            }
            if (this.topRight.bounds.overlaps(x, y, width, height)) {
                this.topRight.intersect(x, y, width, height, out);
            }
            if (this.botLeft.bounds.overlaps(x, y, width, height)) {
                this.botLeft.intersect(x, y, width, height, out);
            }
            if (this.botRight.bounds.overlaps(x, y, width, height)) {
                this.botRight.intersect(x, y, width, height, out);
            }
        }
        Seq<T> objects = this.objects;
        for (int i = 0; i < objects.size; ++i) {
            QuadTreeObject item = (QuadTreeObject)objects.items[i];
            this.hitbox(item);
            if (!this.tmp.overlaps(x, y, width, height)) continue;
            out.get(item);
        }
    }

    public void intersect(Rect rect, Cons<T> out) {
        this.intersect(rect.x, rect.y, rect.width, rect.height, out);
    }

    public void intersect(Rect toCheck, Seq<T> out) {
        if (!this.leaf) {
            if (this.topLeft.bounds.overlaps(toCheck)) {
                this.topLeft.intersect(toCheck, out);
            }
            if (this.topRight.bounds.overlaps(toCheck)) {
                this.topRight.intersect(toCheck, out);
            }
            if (this.botLeft.bounds.overlaps(toCheck)) {
                this.botLeft.intersect(toCheck, out);
            }
            if (this.botRight.bounds.overlaps(toCheck)) {
                this.botRight.intersect(toCheck, out);
            }
        }
        Seq<T> objects = this.objects;
        for (int i = 0; i < objects.size; ++i) {
            QuadTreeObject item = (QuadTreeObject)objects.items[i];
            this.hitbox(item);
            if (!this.tmp.overlaps(toCheck)) continue;
            out.add(item);
        }
    }

    public int getTotalObjectCount() {
        int count = this.objects.size;
        if (!this.leaf) {
            count += this.botLeft.getTotalObjectCount() + this.topRight.getTotalObjectCount() + this.topLeft.getTotalObjectCount() + this.botRight.getTotalObjectCount();
        }
        return count;
    }

    protected QuadTree<T> newChild(Rect rect) {
        return new QuadTree<T>(rect);
    }

    protected void hitbox(T t) {
        t.hitbox(this.tmp);
    }

    public static interface QuadTreeObject {
        public void hitbox(Rect var1);
    }
}

