/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.math.geom.Circle;
import arc.math.geom.Shape2D;
import arc.math.geom.Vec2;
import arc.util.ArcRuntimeException;

public class Rect
implements Shape2D {
    public static final Rect tmp = new Rect();
    public static final Rect tmp2 = new Rect();
    private static final long serialVersionUID = 5733252015138115702L;
    public float x;
    public float y;
    public float width;
    public float height;

    public Rect() {
    }

    public Rect(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rect(Rect rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public Rect setCentered(float x, float y, float size) {
        return this.set(x - size / 2.0f, y - size / 2.0f, size, size);
    }

    public Rect setCentered(float x, float y, float width, float height) {
        return this.set(x - width / 2.0f, y - height / 2.0f, width, height);
    }

    public Rect set(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public Rect setX(float x) {
        this.x = x;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Rect setY(float y) {
        this.y = y;
        return this;
    }

    public float getWidth() {
        return this.width;
    }

    public Rect setWidth(float width) {
        this.width = width;
        return this;
    }

    public float getHeight() {
        return this.height;
    }

    public Rect setHeight(float height) {
        this.height = height;
        return this;
    }

    public Vec2 getPosition(Vec2 position) {
        return position.set(this.x, this.y);
    }

    public Rect setPosition(Vec2 position) {
        this.x = position.x;
        this.y = position.y;
        return this;
    }

    public Rect setPosition(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Rect move(float cx, float cy) {
        this.x += cx;
        this.y += cy;
        return this;
    }

    public Rect setSize(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public Rect setSize(float sizeXY) {
        this.width = sizeXY;
        this.height = sizeXY;
        return this;
    }

    public Vec2 getSize(Vec2 size) {
        return size.set(this.width, this.height);
    }

    @Override
    public boolean contains(float x, float y) {
        return this.x <= x && this.x + this.width >= x && this.y <= y && this.y + this.height >= y;
    }

    @Override
    public boolean contains(Vec2 point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(Circle circle) {
        return circle.x - circle.radius >= this.x && circle.x + circle.radius <= this.x + this.width && circle.y - circle.radius >= this.y && circle.y + circle.radius <= this.y + this.height;
    }

    public boolean contains(Rect rect) {
        float xmin = rect.x;
        float xmax = xmin + rect.width;
        float ymin = rect.y;
        float ymax = ymin + rect.height;
        return xmin > this.x && xmin < this.x + this.width && xmax > this.x && xmax < this.x + this.width && ymin > this.y && ymin < this.y + this.height && ymax > this.y && ymax < this.y + this.height;
    }

    public boolean overlaps(Rect r) {
        return this.x < r.x + r.width && this.x + this.width > r.x && this.y < r.y + r.height && this.y + this.height > r.y;
    }

    public boolean overlaps(float rx, float ry, float rwidth, float rheight) {
        return this.x < rx + rwidth && this.x + this.width > rx && this.y < ry + rheight && this.y + this.height > ry;
    }

    public Rect set(Rect rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
        return this;
    }

    public Rect grow(float amount) {
        return this.grow(amount, amount);
    }

    public Rect grow(float amountX, float amountY) {
        this.x -= amountX / 2.0f;
        this.y -= amountY / 2.0f;
        this.width += amountX;
        this.height += amountY;
        return this;
    }

    public Rect merge(Rect rect) {
        float minX = Math.min(this.x, rect.x);
        float maxX = Math.max(this.x + this.width, rect.x + rect.width);
        this.x = minX;
        this.width = maxX - minX;
        float minY = Math.min(this.y, rect.y);
        float maxY = Math.max(this.y + this.height, rect.y + rect.height);
        this.y = minY;
        this.height = maxY - minY;
        return this;
    }

    public Rect merge(float x, float y) {
        float minX = Math.min(this.x, x);
        float maxX = Math.max(this.x + this.width, x);
        this.x = minX;
        this.width = maxX - minX;
        float minY = Math.min(this.y, y);
        float maxY = Math.max(this.y + this.height, y);
        this.y = minY;
        this.height = maxY - minY;
        return this;
    }

    public Rect merge(Vec2 vec) {
        return this.merge(vec.x, vec.y);
    }

    public Rect merge(Vec2[] vecs) {
        float minX = this.x;
        float maxX = this.x + this.width;
        float minY = this.y;
        float maxY = this.y + this.height;
        for (int i = 0; i < vecs.length; ++i) {
            Vec2 v = vecs[i];
            minX = Math.min(minX, v.x);
            maxX = Math.max(maxX, v.x);
            minY = Math.min(minY, v.y);
            maxY = Math.max(maxY, v.y);
        }
        this.x = minX;
        this.width = maxX - minX;
        this.y = minY;
        this.height = maxY - minY;
        return this;
    }

    public float getAspectRatio() {
        return this.height == 0.0f ? Float.NaN : this.width / this.height;
    }

    public Vec2 getCenter(Vec2 vector) {
        vector.x = this.x + this.width / 2.0f;
        vector.y = this.y + this.height / 2.0f;
        return vector;
    }

    public Rect setCenter(float x, float y) {
        this.setPosition(x - this.width / 2.0f, y - this.height / 2.0f);
        return this;
    }

    public Rect setCenter(Vec2 position) {
        this.setPosition(position.x - this.width / 2.0f, position.y - this.height / 2.0f);
        return this;
    }

    public Rect fitOutside(Rect rect) {
        float ratio = this.getAspectRatio();
        if (ratio > rect.getAspectRatio()) {
            this.setSize(rect.height * ratio, rect.height);
        } else {
            this.setSize(rect.width, rect.width / ratio);
        }
        this.setPosition(rect.x + rect.width / 2.0f - this.width / 2.0f, rect.y + rect.height / 2.0f - this.height / 2.0f);
        return this;
    }

    public Rect fitInside(Rect rect) {
        float ratio = this.getAspectRatio();
        if (ratio < rect.getAspectRatio()) {
            this.setSize(rect.height * ratio, rect.height);
        } else {
            this.setSize(rect.width, rect.width / ratio);
        }
        this.setPosition(rect.x + rect.width / 2.0f - this.width / 2.0f, rect.y + rect.height / 2.0f - this.height / 2.0f);
        return this;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.width + "," + this.height + "]";
    }

    public Rect fromString(String v) {
        int s0 = v.indexOf(44, 1);
        int s1 = v.indexOf(44, s0 + 1);
        int s2 = v.indexOf(44, s1 + 1);
        if (s0 != -1 && s1 != -1 && s2 != -1 && v.charAt(0) == '[' && v.charAt(v.length() - 1) == ']') {
            try {
                float x = Float.parseFloat(v.substring(1, s0));
                float y = Float.parseFloat(v.substring(s0 + 1, s1));
                float width = Float.parseFloat(v.substring(s1 + 1, s2));
                float height = Float.parseFloat(v.substring(s2 + 1, v.length() - 1));
                return this.set(x, y, width, height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ArcRuntimeException("Malformed Rectangle: " + v);
    }

    public float area() {
        return this.width * this.height;
    }

    public float perimeter() {
        return 2.0f * (this.width + this.height);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToRawIntBits(this.height);
        result = 31 * result + Float.floatToRawIntBits(this.width);
        result = 31 * result + Float.floatToRawIntBits(this.x);
        result = 31 * result + Float.floatToRawIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rect other = (Rect)obj;
        if (Float.floatToRawIntBits(this.height) != Float.floatToRawIntBits(other.height)) {
            return false;
        }
        if (Float.floatToRawIntBits(this.width) != Float.floatToRawIntBits(other.width)) {
            return false;
        }
        if (Float.floatToRawIntBits(this.x) != Float.floatToRawIntBits(other.x)) {
            return false;
        }
        return Float.floatToRawIntBits(this.y) == Float.floatToRawIntBits(other.y);
    }
}

