/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mat;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec3;
import arc.math.geom.Vector;
import arc.util.ArcRuntimeException;
import arc.util.Time;

public class Vec2
implements Vector<Vec2>,
Position {
    public static final Vec2 X = new Vec2(1.0f, 0.0f);
    public static final Vec2 Y = new Vec2(0.0f, 1.0f);
    public static final Vec2 ZERO = new Vec2(0.0f, 0.0f);
    public float x;
    public float y;

    public Vec2() {
    }

    public Vec2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vec2(Vec2 v) {
        this.set(v);
    }

    public Vec2 trns(float angle, float amount) {
        return this.set(amount, 0.0f).rotate(angle);
    }

    public Vec2 trns(float angle, float x, float y) {
        return this.set(x, y).rotate(angle);
    }

    public Vec2 trnsExact(float angle, float amount) {
        return this.set(amount, 0.0f).rotateRadExact(angle * ((float)Math.PI / 180));
    }

    public Vec2 snap() {
        return this.set((int)this.x, (int)this.y);
    }

    @Override
    public Vec2 div(Vec2 other) {
        this.x /= other.x;
        this.y /= other.y;
        return this;
    }

    @Override
    public Vec2 cpy() {
        return new Vec2(this);
    }

    @Override
    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public float len2() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public Vec2 set(Vec2 v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    @Override
    public Vec2 set(Position v) {
        this.x = v.getX();
        this.y = v.getY();
        return this;
    }

    public Vec2 set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    @Override
    public Vec2 set(Vec3 other) {
        this.x = other.x;
        this.y = other.y;
        return this;
    }

    @Override
    public Vec2 sub(Position v) {
        return this.sub(v.getX(), v.getY());
    }

    @Override
    public Vec2 sub(Vec2 v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public Vec2 sub(float x, float y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    @Override
    public Vec2 sub(Vec3 v) {
        return this.sub(v.x, v.y);
    }

    @Override
    public Vec2 nor() {
        float len = this.len();
        if (len != 0.0f) {
            this.x /= len;
            this.y /= len;
        }
        return this;
    }

    @Override
    public Vec2 add(Vec2 v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    @Override
    public Vec2 add(Position pos) {
        return this.add(pos.getX(), pos.getY());
    }

    public Vec2 add(Vec2 vec, float scl) {
        this.x += vec.x * scl;
        this.y += vec.y * scl;
        return this;
    }

    public Vec2 add(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    @Override
    public float dot(Vec2 v) {
        return this.x * v.x + this.y * v.y;
    }

    public float dot(float ox, float oy) {
        return this.x * ox + this.y * oy;
    }

    @Override
    public Vec2 scl(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vec2 inv() {
        return this.scl(-1.0f);
    }

    public Vec2 scl(float x, float y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    @Override
    public Vec2 scl(Vec2 v) {
        this.x *= v.x;
        this.y *= v.y;
        return this;
    }

    @Override
    public Vec2 mulAdd(Vec2 vec, float scalar) {
        this.x += vec.x * scalar;
        this.y += vec.y * scalar;
        return this;
    }

    @Override
    public Vec2 mulAdd(Vec2 vec, Vec2 mulVec) {
        this.x += vec.x * mulVec.x;
        this.y += vec.y * mulVec.y;
        return this;
    }

    @Override
    public float dst(Vec2 v) {
        float x_d = v.x - this.x;
        float y_d = v.y - this.y;
        return (float)Math.sqrt(x_d * x_d + y_d * y_d);
    }

    @Override
    public float dst(float x, float y) {
        float x_d = x - this.x;
        float y_d = y - this.y;
        return (float)Math.sqrt(x_d * x_d + y_d * y_d);
    }

    @Override
    public float dst2(Vec2 v) {
        float x_d = v.x - this.x;
        float y_d = v.y - this.y;
        return x_d * x_d + y_d * y_d;
    }

    @Override
    public float dst2(float x, float y) {
        float xd = x - this.x;
        float yd = y - this.y;
        return xd * xd + yd * yd;
    }

    @Override
    public Vec2 limit(float limit) {
        return this.limit2(limit * limit);
    }

    @Override
    public Vec2 limit2(float limit2) {
        float len2 = this.len2();
        if (len2 > limit2) {
            return this.scl((float)Math.sqrt(limit2 / len2));
        }
        return this;
    }

    @Override
    public Vec2 clamp(float min, float max) {
        float len2 = this.len2();
        if (len2 == 0.0f) {
            return this;
        }
        float max2 = max * max;
        if (len2 > max2) {
            return this.scl((float)Math.sqrt(max2 / len2));
        }
        float min2 = min * min;
        if (len2 < min2) {
            return this.scl((float)Math.sqrt(min2 / len2));
        }
        return this;
    }

    @Override
    public Vec2 setLength(float len) {
        return this.setLength2(len * len);
    }

    @Override
    public Vec2 setLength2(float len2) {
        float oldLen2 = this.len2();
        return oldLen2 == 0.0f || oldLen2 == len2 ? this : this.scl((float)Math.sqrt(len2 / oldLen2));
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public Vec2 clamp(float minx, float miny, float maxy, float maxx) {
        this.x = Mathf.clamp(this.x, minx, maxx);
        this.y = Mathf.clamp(this.y, miny, maxy);
        return this;
    }

    public Vec2 tryFromString(String v) {
        try {
            int s = v.indexOf(44, 1);
            if (s != -1 && v.charAt(0) == '(' && v.charAt(v.length() - 1) == ')') {
                float x = Float.parseFloat(v.substring(1, s));
                float y = Float.parseFloat(v.substring(s + 1, v.length() - 1));
                return this.set(x, y);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.setZero();
    }

    public Vec2 fromString(String v) {
        int s = v.indexOf(44, 1);
        if (s != -1 && v.charAt(0) == '(' && v.charAt(v.length() - 1) == ')') {
            try {
                float x = Float.parseFloat(v.substring(1, s));
                float y = Float.parseFloat(v.substring(s + 1, v.length() - 1));
                return this.set(x, y);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ArcRuntimeException("Malformed Vec2: " + v);
    }

    public Vec2 mul(Mat mat) {
        float x = this.x * mat.val[0] + this.y * mat.val[3] + mat.val[6];
        float y = this.x * mat.val[1] + this.y * mat.val[4] + mat.val[7];
        this.x = x;
        this.y = y;
        return this;
    }

    public float crs(Vec2 v) {
        return this.x * v.y - this.y * v.x;
    }

    public float crs(float x, float y) {
        return this.x * y - this.y * x;
    }

    public float angle() {
        float angle = Mathf.atan2(this.x, this.y) * 57.295776f;
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float angle(Vec2 reference) {
        return (float)Math.atan2(this.crs(reference), this.dot(reference)) * 57.295776f;
    }

    public Vec2 rnd(float length) {
        this.setToRandomDirection().scl(length);
        return this;
    }

    public float angleRad() {
        return (float)Math.atan2(this.y, this.x);
    }

    public float angleRad(Vec2 reference) {
        return (float)Math.atan2(this.crs(reference), this.dot(reference));
    }

    public Vec2 setAngle(float degrees) {
        return this.setAngleRad(degrees * ((float)Math.PI / 180));
    }

    public Vec2 setAngleRad(float radians) {
        this.set(this.len(), 0.0f);
        this.rotateRad(radians);
        return this;
    }

    public Vec2 rotateTo(float angle, float speed) {
        return this.setAngle(Angles.moveToward(this.angle(), angle, speed));
    }

    public Vec2 rotate(float degrees) {
        return this.rotateRad(degrees * ((float)Math.PI / 180));
    }

    public Vec2 rotateAround(Vec2 reference, float degrees) {
        return this.sub(reference).rotate(degrees).add(reference);
    }

    public Vec2 rotateRad(float radians) {
        float cos = Mathf.cos(radians);
        float sin = Mathf.sin(radians);
        float newX = this.x * cos - this.y * sin;
        float newY = this.x * sin + this.y * cos;
        this.x = newX;
        this.y = newY;
        return this;
    }

    public Vec2 rotateRadExact(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float newX = this.x * cos - this.y * sin;
        float newY = this.x * sin + this.y * cos;
        this.x = newX;
        this.y = newY;
        return this;
    }

    public Vec2 rotateAroundRad(Vec2 reference, float radians) {
        return this.sub(reference).rotateRad(radians).add(reference);
    }

    public Vec2 rotate90(int dir) {
        float x = this.x;
        if (dir >= 0) {
            this.x = -this.y;
            this.y = x;
        } else {
            this.x = this.y;
            this.y = -x;
        }
        return this;
    }

    public Vec2 approachDelta(Vec2 target, float alpha) {
        return this.approach(target, Time.delta * alpha);
    }

    public Vec2 approach(Vec2 target, float alpha) {
        float dx = this.x - target.x;
        float dy = this.y - target.y;
        float alpha2 = alpha * alpha;
        float len2 = Mathf.len2(dx, dy);
        if (len2 > alpha2) {
            float scl = Mathf.sqrt(alpha2 / len2);
            return this.sub(dx *= scl, dy *= scl);
        }
        return this.set(target);
    }

    public Vec2 lerpPast(Vec2 target, float alpha) {
        this.x += (target.x - this.x) * alpha;
        this.y += (target.y - this.y) * alpha;
        return this;
    }

    public Vec2 lerpDelta(float tx, float ty, float alpha) {
        alpha = Mathf.clamp(alpha * Time.delta);
        float invAlpha = 1.0f - alpha;
        this.x = this.x * invAlpha + tx * alpha;
        this.y = this.y * invAlpha + ty * alpha;
        return this;
    }

    public Vec2 lerpDelta(Position target, float alpha) {
        alpha = Mathf.clamp(alpha * Time.delta);
        float invAlpha = 1.0f - alpha;
        this.x = this.x * invAlpha + target.getX() * alpha;
        this.y = this.y * invAlpha + target.getY() * alpha;
        return this;
    }

    @Override
    public Vec2 lerp(Position target, float alpha) {
        float invAlpha = 1.0f - alpha;
        this.x = this.x * invAlpha + target.getX() * alpha;
        this.y = this.y * invAlpha + target.getY() * alpha;
        return this;
    }

    public Vec2 lerp(float tx, float ty, float alpha) {
        float invAlpha = 1.0f - alpha;
        this.x = this.x * invAlpha + tx * alpha;
        this.y = this.y * invAlpha + ty * alpha;
        return this;
    }

    @Override
    public Vec2 lerp(Vec2 target, float alpha) {
        float invAlpha = 1.0f - alpha;
        this.x = this.x * invAlpha + target.x * alpha;
        this.y = this.y * invAlpha + target.y * alpha;
        return this;
    }

    @Override
    public Vec2 interpolate(Vec2 target, float alpha, Interp interpolation) {
        return this.lerp(target, interpolation.apply(alpha));
    }

    @Override
    public Vec2 setToRandomDirection() {
        float theta = Mathf.random(0.0f, (float)Math.PI * 2);
        return this.set(Mathf.cos(theta), Mathf.sin(theta));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec2 other = (Vec2)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }

    @Override
    public boolean epsilonEquals(Vec2 other, float epsilon) {
        if (other == null) {
            return false;
        }
        if (Math.abs(other.x - this.x) > epsilon) {
            return false;
        }
        return !(Math.abs(other.y - this.y) > epsilon);
    }

    public boolean epsilonEquals(float x, float y, float epsilon) {
        if (Math.abs(x - this.x) > epsilon) {
            return false;
        }
        return !(Math.abs(y - this.y) > epsilon);
    }

    public boolean epsilonEquals(Vec2 other) {
        return this.epsilonEquals(other, 1.0E-6f);
    }

    @Override
    public boolean epsilonEquals(float x, float y) {
        return this.epsilonEquals(x, y, 1.0E-6f);
    }

    public boolean isNaN() {
        return Float.isNaN(this.x) || Float.isNaN(this.y);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.x) || Float.isInfinite(this.y);
    }

    @Override
    public boolean isUnit() {
        return this.isUnit(1.0E-9f);
    }

    @Override
    public boolean isUnit(float margin) {
        return Math.abs(this.len2() - 1.0f) < margin;
    }

    @Override
    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f;
    }

    @Override
    public boolean isZero(float margin) {
        return this.len2() < margin;
    }

    @Override
    public boolean isOnLine(Vec2 other) {
        return Mathf.zero(this.x * other.y - this.y * other.x);
    }

    @Override
    public boolean isOnLine(Vec2 other, float epsilon) {
        return Mathf.zero(this.x * other.y - this.y * other.x, epsilon);
    }

    @Override
    public boolean isCollinear(Vec2 other, float epsilon) {
        return this.isOnLine(other, epsilon) && this.dot(other) > 0.0f;
    }

    @Override
    public boolean isCollinear(Vec2 other) {
        return this.isOnLine(other) && this.dot(other) > 0.0f;
    }

    @Override
    public boolean isCollinearOpposite(Vec2 other, float epsilon) {
        return this.isOnLine(other, epsilon) && this.dot(other) < 0.0f;
    }

    @Override
    public boolean isCollinearOpposite(Vec2 other) {
        return this.isOnLine(other) && this.dot(other) < 0.0f;
    }

    @Override
    public boolean isPerpendicular(Vec2 vector) {
        return Mathf.zero(this.dot(vector));
    }

    @Override
    public boolean isPerpendicular(Vec2 vector, float epsilon) {
        return Mathf.zero(this.dot(vector), epsilon);
    }

    @Override
    public boolean hasSameDirection(Vec2 vector) {
        return this.dot(vector) > 0.0f;
    }

    @Override
    public boolean hasOppositeDirection(Vec2 vector) {
        return this.dot(vector) < 0.0f;
    }

    @Override
    public Vec2 setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
        return this;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }
}

