/*
 * Decompiled with CFR 0.152.
 */
package arc.net;

import arc.net.ArcNet;
import arc.net.ArcNetException;
import arc.net.DcReason;
import arc.net.EndPoint;
import arc.net.FrameworkMessage;
import arc.net.NetListener;
import arc.net.NetSerializer;
import arc.net.TcpConnection;
import arc.net.UdpConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;

public class Connection {
    int id = -1;
    private String name;
    EndPoint endPoint;
    TcpConnection tcp;
    UdpConnection udp;
    InetSocketAddress udpRemoteAddress;
    private NetListener[] listeners = new NetListener[0];
    private final Object listenerLock = new Object();
    private int lastPingID;
    private long lastPingSendTime;
    private int returnTripTime;
    volatile boolean isConnected;
    volatile ArcNetException lastProtocolError;
    private Object arbitraryData;

    protected Connection() {
    }

    void initialize(NetSerializer serialization, int writeBufferSize, int objectBufferSize) {
        this.tcp = new TcpConnection(serialization, writeBufferSize, objectBufferSize);
    }

    public int getID() {
        return this.id;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public ArcNetException getLastProtocolError() {
        return this.lastProtocolError;
    }

    public int sendTCP(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        try {
            return this.tcp.send(object);
        }
        catch (ArcNetException | IOException ex) {
            this.close(DcReason.error);
            ArcNet.handleError(ex);
            return 0;
        }
    }

    public int sendUDP(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        InetSocketAddress address = this.udpRemoteAddress;
        if (address == null && this.udp != null) {
            address = this.udp.connectedAddress;
        }
        if (address == null && this.isConnected) {
            throw new IllegalStateException("Connection is not connected via UDP.");
        }
        try {
            if (address == null) {
                throw new SocketException("Connection is closed.");
            }
            return this.udp.send(object, address);
        }
        catch (ArcNetException | IOException ex) {
            this.close(DcReason.error);
            ArcNet.handleError(ex);
            return 0;
        }
    }

    public void close(DcReason reason) {
        boolean wasConnected = this.isConnected;
        this.isConnected = false;
        this.tcp.close();
        if (this.udp != null && this.udp.connectedAddress != null) {
            this.udp.close();
        }
        if (wasConnected) {
            this.notifyDisconnected(reason);
        }
        this.setConnected(false);
    }

    public void updateReturnTripTime() {
        FrameworkMessage.Ping ping = new FrameworkMessage.Ping();
        ping.id = this.lastPingID++;
        this.lastPingSendTime = System.currentTimeMillis();
        this.sendTCP(ping);
    }

    public int getReturnTripTime() {
        return this.returnTripTime;
    }

    public void setKeepAliveTCP(int keepAliveMillis) {
        this.tcp.keepAliveMillis = keepAliveMillis;
    }

    public void setTimeout(int timeoutMillis) {
        this.tcp.timeoutMillis = timeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(NetListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            NetListener[] listeners = this.listeners;
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (listener != listeners[i]) continue;
                return;
            }
            NetListener[] newListeners = new NetListener[n + 1];
            newListeners[0] = listener;
            System.arraycopy(listeners, 0, newListeners, 1, n);
            this.listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(NetListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            NetListener[] listeners = this.listeners;
            int n = listeners.length;
            if (n == 0) {
                return;
            }
            NetListener[] newListeners = new NetListener[n - 1];
            int ii = 0;
            for (int i = 0; i < n; ++i) {
                NetListener copyListener = listeners[i];
                if (listener == copyListener) continue;
                if (ii == n - 1) {
                    return;
                }
                newListeners[ii++] = copyListener;
            }
            this.listeners = newListeners;
        }
    }

    void notifyConnected() {
        NetListener[] listeners = this.listeners;
        int n = listeners.length;
        for (int i = 0; i < n; ++i) {
            listeners[i].connected(this);
        }
    }

    void notifyDisconnected(DcReason reason) {
        NetListener[] listeners = this.listeners;
        int n = listeners.length;
        for (int i = 0; i < n; ++i) {
            listeners[i].disconnected(this, reason);
        }
    }

    void notifyIdle() {
        NetListener[] listeners = this.listeners;
        int n = listeners.length;
        for (int i = 0; i < n; ++i) {
            listeners[i].idle(this);
            if (!this.isIdle()) break;
        }
    }

    void notifyReceived(Object object) {
        if (object instanceof FrameworkMessage.Ping) {
            FrameworkMessage.Ping ping = (FrameworkMessage.Ping)object;
            if (ping.isReply) {
                if (ping.id == this.lastPingID - 1) {
                    this.returnTripTime = (int)(System.currentTimeMillis() - this.lastPingSendTime);
                }
            } else {
                ping.isReply = true;
                this.sendTCP(ping);
            }
        }
        NetListener[] listeners = this.listeners;
        int n = listeners.length;
        for (int i = 0; i < n; ++i) {
            listeners[i].received(this, object);
        }
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public InetSocketAddress getRemoteAddressTCP() {
        Socket socket;
        SocketChannel socketChannel = this.tcp.socketChannel;
        if (socketChannel != null && (socket = this.tcp.socketChannel.socket()) != null) {
            return (InetSocketAddress)socket.getRemoteSocketAddress();
        }
        return null;
    }

    public InetSocketAddress getRemoteAddressUDP() {
        InetSocketAddress connectedAddress = this.udp.connectedAddress;
        if (connectedAddress != null) {
            return connectedAddress;
        }
        return this.udpRemoteAddress;
    }

    public void setBufferPositionFix(boolean bufferPositionFix) {
        this.tcp.bufferPositionFix = bufferPositionFix;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTcpWriteBufferSize() {
        return this.tcp.writeBuffer.position();
    }

    public boolean isIdle() {
        return (float)this.tcp.writeBuffer.position() / (float)this.tcp.writeBuffer.capacity() < this.tcp.idleThreshold;
    }

    public void setIdleThreshold(float idleThreshold) {
        this.tcp.idleThreshold = idleThreshold;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return "Connection " + this.id;
    }

    void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
        if (isConnected && this.name == null) {
            this.name = "Connection " + this.id;
        }
    }

    public Object getArbitraryData() {
        return this.arbitraryData;
    }

    public void setArbitraryData(Object arbitraryData) {
        this.arbitraryData = arbitraryData;
    }
}

