/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.ui;

import arc.Core;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.Scene;
import arc.scene.actions.Actions;
import arc.scene.event.FocusListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.event.VisibilityEvent;
import arc.scene.event.VisibilityListener;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;

public class Dialog
extends Table {
    private static Prov<Action> defaultShowAction = () -> Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.fadeIn(0.4f, Interp.fade));
    private static Prov<Action> defaultHideAction = () -> Actions.fadeOut(0.4f, Interp.fade);
    protected InputListener ignoreTouchDown = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
            event.cancel();
            return false;
        }
    };
    private static final Vec2 tmpPosition = new Vec2();
    private static final Vec2 tmpSize = new Vec2();
    private static final int MOVE = 32;
    protected int edge;
    protected boolean dragging;
    boolean isMovable = false;
    boolean isModal = true;
    boolean isResizable = false;
    boolean center = true;
    int resizeBorder = 8;
    boolean keepWithinStage = true;
    private DialogStyle style;
    Element previousKeyboardFocus;
    Element previousScrollFocus;
    FocusListener focusListener;
    public final Table cont;
    public final Table buttons;
    public final Label title;
    public final Table titleTable;

    public Dialog(String title) {
        this(title, Core.scene.getStyle(DialogStyle.class));
    }

    public Dialog(String title, DialogStyle style) {
        if (title == null) {
            throw new IllegalArgumentException("title cannot be null.");
        }
        this.touchable = Touchable.enabled;
        this.setClip(true);
        this.title = new Label(title, new Label.LabelStyle(style.titleFont, style.titleFontColor));
        this.title.setEllipsis(true);
        this.titleTable = new Table();
        this.titleTable.add(this.title).expandX().fillX().minWidth(0.0f);
        this.add(this.titleTable).growX().row();
        this.setStyle(style);
        this.setWidth(150.0f);
        this.setHeight(150.0f);
        this.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                Dialog.this.toFront();
                return false;
            }
        });
        this.addListener(new InputListener(){
            float startX;
            float startY;
            float lastX;
            float lastY;

            private void updateEdge(float x, float y) {
                float border = (float)Dialog.this.resizeBorder / 2.0f;
                float width = Dialog.this.getWidth();
                float height = Dialog.this.getHeight();
                float padTop = Dialog.this.getMarginTop();
                float padRight = Dialog.this.getMarginRight();
                float right = width - padRight;
                Dialog.this.edge = 0;
                if (Dialog.this.isResizable && x >= Dialog.this.getMarginLeft() - border && x <= right + border && y >= Dialog.this.getMarginBottom() - border) {
                    if (x < Dialog.this.getMarginLeft() + border) {
                        Dialog.this.edge |= 8;
                    }
                    if (x > right - border) {
                        Dialog.this.edge |= 0x10;
                    }
                    if (y < Dialog.this.getMarginBottom() + border) {
                        Dialog.this.edge |= 4;
                    }
                    if (Dialog.this.edge != 0) {
                        border += 25.0f;
                    }
                    if (x < Dialog.this.getMarginLeft() + border) {
                        Dialog.this.edge |= 8;
                    }
                    if (x > right - border) {
                        Dialog.this.edge |= 0x10;
                    }
                    if (y < Dialog.this.getMarginBottom() + border) {
                        Dialog.this.edge |= 4;
                    }
                }
                if (Dialog.this.isMovable && Dialog.this.edge == 0 && y <= height && y >= height - padTop && x >= Dialog.this.getMarginLeft() && x <= right) {
                    Dialog.this.edge = 32;
                }
            }

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                if (button == KeyCode.mouseLeft) {
                    this.updateEdge(x, y);
                    Dialog.this.dragging = Dialog.this.edge != 0;
                    this.startX = x;
                    this.startY = y;
                    this.lastX = x - Dialog.this.getWidth();
                    this.lastY = y - Dialog.this.getHeight();
                }
                return Dialog.this.edge != 0 || Dialog.this.isModal;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                Dialog.this.dragging = false;
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                float amountY;
                float amountX;
                boolean clampPosition;
                if (!Dialog.this.dragging) {
                    return;
                }
                float width = Dialog.this.getWidth();
                float height = Dialog.this.getHeight();
                float windowX = Dialog.this.x;
                float windowY = Dialog.this.y;
                float minWidth = Dialog.this.getMinWidth();
                float minHeight = Dialog.this.getMinHeight();
                Scene stage = Dialog.this.getScene();
                boolean bl = clampPosition = Dialog.this.keepWithinStage && Dialog.this.parent == stage.root;
                if ((Dialog.this.edge & 0x20) != 0) {
                    amountX = x - this.startX;
                    float amountY2 = y - this.startY;
                    windowX += amountX;
                    windowY += amountY2;
                }
                if ((Dialog.this.edge & 8) != 0) {
                    amountX = x - this.startX;
                    if (width - amountX < minWidth) {
                        amountX = -(minWidth - width);
                    }
                    if (clampPosition && windowX + amountX < 0.0f) {
                        amountX = -windowX;
                    }
                    width -= amountX;
                    windowX += amountX;
                }
                if ((Dialog.this.edge & 4) != 0) {
                    amountY = y - this.startY;
                    if (height - amountY < minHeight) {
                        amountY = -(minHeight - height);
                    }
                    if (clampPosition && windowY + amountY < 0.0f) {
                        amountY = -windowY;
                    }
                    height -= amountY;
                    windowY += amountY;
                }
                if ((Dialog.this.edge & 0x10) != 0) {
                    amountX = x - this.lastX - width;
                    if (width + amountX < minWidth) {
                        amountX = minWidth - width;
                    }
                    if (clampPosition && windowX + width + amountX > stage.getWidth()) {
                        amountX = stage.getWidth() - windowX - width;
                    }
                    width += amountX;
                }
                if ((Dialog.this.edge & 2) != 0) {
                    amountY = y - this.lastY - height;
                    if (height + amountY < minHeight) {
                        amountY = minHeight - height;
                    }
                    if (clampPosition && windowY + height + amountY > stage.getHeight()) {
                        amountY = stage.getHeight() - windowY - height;
                    }
                    height += amountY;
                }
                Dialog.this.setBounds(Math.round(windowX), Math.round(windowY), Math.round(width), Math.round(height));
            }

            @Override
            public boolean mouseMoved(InputEvent event, float x, float y) {
                this.updateEdge(x, y);
                return Dialog.this.isModal;
            }

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                return Dialog.this.isModal;
            }

            @Override
            public boolean keyDown(InputEvent event, KeyCode keycode) {
                return Dialog.this.isModal;
            }

            @Override
            public boolean keyUp(InputEvent event, KeyCode keycode) {
                return Dialog.this.isModal;
            }

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                return Dialog.this.isModal;
            }
        });
        this.setOrigin(1);
        this.defaults().pad(3.0f);
        this.cont = new Table();
        this.add(this.cont).expand().fill();
        this.row();
        this.buttons = new Table();
        this.add(this.buttons).fillX();
        this.cont.defaults().pad(3.0f);
        this.buttons.defaults().pad(3.0f);
        this.focusListener = new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Element actor, boolean focused) {
                if (!focused) {
                    this.focusChanged(event);
                }
            }

            @Override
            public void scrollFocusChanged(FocusListener.FocusEvent event, Element actor, boolean focused) {
                if (!focused) {
                    this.focusChanged(event);
                }
            }

            private void focusChanged(FocusListener.FocusEvent event) {
                Element newFocusedActor;
                Scene stage = Dialog.this.getScene();
                if (Dialog.this.isModal && stage != null && stage.root.getChildren().size > 0 && stage.root.getChildren().peek() == Dialog.this && (newFocusedActor = event.relatedActor) != null && !newFocusedActor.isDescendantOf(Dialog.this) && !newFocusedActor.equals(Dialog.this.previousKeyboardFocus) && !newFocusedActor.equals(Dialog.this.previousScrollFocus)) {
                    event.cancel();
                }
            }
        };
        this.shown(this::updateScrollFocus);
    }

    public DialogStyle getStyle() {
        return this.style;
    }

    public void setStyle(DialogStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.setBackground(style.background);
        this.invalidateHierarchy();
    }

    void keepWithinStage() {
        if (!this.keepWithinStage) {
            return;
        }
        this.keepInStage();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.getScene() != null) {
            this.keepWithinStage();
            if (this.center && !this.isMovable && this.getActions().size == 0) {
                this.centerWindow();
            }
        }
    }

    @Override
    public void draw() {
        Scene stage = this.getScene();
        if (stage.getKeyboardFocus() == null) {
            stage.setKeyboardFocus(this);
        }
        if (this.style.stageBackground != null) {
            this.stageToLocalCoordinates(tmpPosition.set(0.0f, 0.0f));
            this.stageToLocalCoordinates(tmpSize.set(stage.getWidth(), stage.getHeight()));
            this.drawStageBackground(this.x + Dialog.tmpPosition.x, this.y + Dialog.tmpPosition.y, this.x + Dialog.tmpSize.x, this.y + Dialog.tmpSize.y);
        }
        super.draw();
    }

    protected void drawStageBackground(float x, float y, float width, float height) {
        Color color = this.color;
        Draw.color(color.r, color.g, color.b, color.a * this.parentAlpha);
        this.style.stageBackground.draw(x, y, width, height);
    }

    @Override
    public Element hit(float x, float y, boolean touchable) {
        Element hit = super.hit(x, y, touchable);
        if (hit == null && this.isModal && (!touchable || this.touchable == Touchable.enabled)) {
            return this;
        }
        return hit;
    }

    public void centerWindow() {
        this.setPosition(Math.round((Core.scene.getWidth() - Core.scene.marginLeft - Core.scene.marginRight - this.getWidth()) / 2.0f), Math.round((Core.scene.getHeight() - Core.scene.marginTop - Core.scene.marginBottom - this.getHeight()) / 2.0f));
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    public boolean isModal() {
        return this.isModal;
    }

    public void setModal(boolean isModal) {
        this.isModal = isModal;
    }

    public void setKeepWithinStage(boolean keepWithinStage) {
        this.keepWithinStage = keepWithinStage;
    }

    public boolean isCentered() {
        return this.center;
    }

    public void setCentered(boolean center) {
        this.center = center;
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    public void setResizable(boolean isResizable) {
        this.isResizable = isResizable;
    }

    public void setResizeBorder(int resizeBorder) {
        this.resizeBorder = resizeBorder;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void updateScrollFocus() {
        boolean[] done = new boolean[]{false};
        Core.app.post(() -> this.forEach(child -> {
            if (done[0]) {
                return;
            }
            if (child instanceof ScrollPane) {
                Core.scene.setScrollFocus((Element)child);
                done[0] = true;
            }
        }));
    }

    public static void setHideAction(Prov<Action> prov) {
        defaultHideAction = prov;
    }

    public static void setShowAction(Prov<Action> prov) {
        defaultShowAction = prov;
    }

    @Override
    protected void setScene(Scene stage) {
        if (stage == null) {
            this.addListener(this.focusListener);
        } else {
            this.removeListener(this.focusListener);
        }
        super.setScene(stage);
    }

    public void shown(final Runnable run) {
        this.addListener(new VisibilityListener(){

            @Override
            public boolean shown() {
                run.run();
                return false;
            }
        });
    }

    public void hidden(final Runnable run) {
        this.addListener(new VisibilityListener(){

            @Override
            public boolean hidden() {
                run.run();
                return false;
            }
        });
    }

    public void addCloseButton() {
    }

    public void closeOnBack() {
        this.keyDown(key -> {
            if (key == KeyCode.escape || key == KeyCode.back) {
                Core.app.post(this::hide);
            }
        });
    }

    public boolean isShown() {
        return this.getScene() != null;
    }

    public Dialog show(Scene stage, Action action) {
        this.setOrigin(1);
        this.setClip(false);
        this.setTransform(true);
        this.fire(new VisibilityEvent(false));
        this.clearActions();
        this.removeCaptureListener(this.ignoreTouchDown);
        this.previousKeyboardFocus = null;
        Element actor = stage.getKeyboardFocus();
        if (actor != null && !actor.isDescendantOf(this)) {
            this.previousKeyboardFocus = actor;
        }
        this.previousScrollFocus = null;
        actor = stage.getScrollFocus();
        if (actor != null && !actor.isDescendantOf(this)) {
            this.previousScrollFocus = actor;
        }
        this.pack();
        stage.add(this);
        stage.setKeyboardFocus(this);
        stage.setScrollFocus(this);
        if (action != null) {
            this.addAction(action);
        }
        this.pack();
        return this;
    }

    public void toggle() {
        if (this.isShown()) {
            this.hide();
        } else {
            this.show();
        }
    }

    public Dialog show() {
        return this.show(Core.scene);
    }

    public Dialog show(Scene stage) {
        this.show(stage, defaultShowAction.get());
        this.centerWindow();
        return this;
    }

    public void hide(Action action) {
        this.fire(new VisibilityEvent(true));
        Scene stage = this.getScene();
        if (stage != null) {
            Element actor;
            this.removeListener(this.focusListener);
            if (this.previousKeyboardFocus != null && this.previousKeyboardFocus.getScene() == null) {
                this.previousKeyboardFocus = null;
            }
            if ((actor = stage.getKeyboardFocus()) == null || actor.isDescendantOf(this)) {
                stage.setKeyboardFocus(this.previousKeyboardFocus);
            }
            if (this.previousScrollFocus != null && this.previousScrollFocus.getScene() == null) {
                this.previousScrollFocus = null;
            }
            if ((actor = stage.getScrollFocus()) == null || actor.isDescendantOf(this)) {
                stage.setScrollFocus(this.previousScrollFocus);
            }
        }
        if (action != null) {
            this.addCaptureListener(this.ignoreTouchDown);
            this.addAction(Actions.sequence(action, (Action)Actions.removeListener(this.ignoreTouchDown, true), (Action)Actions.remove()));
        } else {
            this.remove();
        }
    }

    public void hide() {
        if (!this.isShown()) {
            return;
        }
        this.setOrigin(1);
        this.setClip(false);
        this.setTransform(true);
        this.hide(defaultHideAction.get());
    }

    public static class DialogStyle
    extends Style {
        public Drawable background;
        public Font titleFont;
        public Color titleFontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Drawable stageBackground;
    }
}

