/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.ui;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Cell;
import arc.util.Scaling;

public class ImageButton
extends Button {
    private final Image image = new Image();
    private ImageButtonStyle style;

    public ImageButton() {
        this(Core.scene.getStyle(ImageButtonStyle.class));
    }

    public ImageButton(Drawable icon, ImageButtonStyle stylen) {
        this(stylen);
        ImageButtonStyle style = new ImageButtonStyle(stylen);
        style.imageUp = icon;
        this.setStyle(style);
    }

    public ImageButton(TextureRegion region) {
        this(Core.scene.getStyle(ImageButtonStyle.class));
        ImageButtonStyle style = new ImageButtonStyle(Core.scene.getStyle(ImageButtonStyle.class));
        style.imageUp = new TextureRegionDrawable(region);
        this.setStyle(style);
    }

    public ImageButton(TextureRegion region, ImageButtonStyle stylen) {
        this(stylen);
        ImageButtonStyle style = new ImageButtonStyle(stylen);
        style.imageUp = new TextureRegionDrawable(region);
        this.setStyle(style);
    }

    public ImageButton(ImageButtonStyle style) {
        super(style);
        this.image.setScaling(Scaling.fit);
        this.add(this.image);
        this.setStyle(style);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public ImageButton(Drawable imageUp) {
        this(new ImageButtonStyle(null, null, null, imageUp, null, null));
        ImageButtonStyle style = new ImageButtonStyle(Core.scene.getStyle(ImageButtonStyle.class));
        style.imageUp = imageUp;
        this.setStyle(style);
    }

    public ImageButton(Drawable imageUp, Drawable imageDown) {
        this(new ImageButtonStyle(null, null, null, imageUp, imageDown, null));
    }

    public ImageButton(Drawable imageUp, Drawable imageDown, Drawable imageChecked) {
        this(new ImageButtonStyle(null, null, null, imageUp, imageDown, imageChecked));
    }

    @Override
    public ImageButtonStyle getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof ImageButtonStyle)) {
            throw new IllegalArgumentException("style must be an ImageButtonStyle.");
        }
        super.setStyle(style);
        this.style = (ImageButtonStyle)style;
        if (this.image != null) {
            this.updateImage();
        }
    }

    public void replaceImage(Element element) {
        this.getImageCell().setElement(element);
        this.addChild(element);
        this.image.remove();
    }

    protected void updateImage() {
        Drawable drawable = null;
        if (this.isDisabled() && this.style.imageDisabled != null) {
            drawable = this.style.imageDisabled;
        } else if (this.isPressed() && this.style.imageDown != null) {
            drawable = this.style.imageDown;
        } else if (this.isChecked && this.style.imageChecked != null) {
            drawable = this.style.imageCheckedOver != null && this.isOver() ? this.style.imageCheckedOver : this.style.imageChecked;
        } else if (this.isOver() && this.style.imageOver != null) {
            drawable = this.style.imageOver;
        } else if (this.style.imageUp != null) {
            drawable = this.style.imageUp;
        }
        Color color = this.image.color;
        if (this.isDisabled && this.style.imageDisabledColor != null) {
            color = this.style.imageDisabledColor;
        } else if (this.isPressed() && this.style.imageDownColor != null) {
            color = this.style.imageDownColor;
        } else if (this.isChecked() && this.style.imageCheckedColor != null) {
            color = this.style.imageCheckedColor;
        } else if (this.style.imageUpColor != null) {
            color = this.style.imageUpColor;
        }
        this.image.setDrawable(drawable);
        this.image.setColor(color);
    }

    @Override
    public void draw() {
        this.updateImage();
        super.draw();
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.getCell(this.image) == null ? this.getCells().first() : this.getCell(this.image);
    }

    public void resizeImage(float size) {
        this.getImageCell().size(size);
    }

    public static class ImageButtonStyle
    extends Button.ButtonStyle {
        public Drawable imageUp;
        public Drawable imageDown;
        public Drawable imageOver;
        public Drawable imageChecked;
        public Drawable imageCheckedOver;
        public Drawable imageDisabled;
        public Color imageUpColor;
        public Color imageCheckedColor;
        public Color imageDownColor;
        public Color imageDisabledColor;

        public ImageButtonStyle() {
        }

        public ImageButtonStyle(Drawable up, Drawable down, Drawable checked, Drawable imageUp, Drawable imageDown, Drawable imageChecked) {
            super(up, down, checked);
            this.imageUp = imageUp;
            this.imageDown = imageDown;
            this.imageChecked = imageChecked;
        }

        public ImageButtonStyle(ImageButtonStyle style) {
            super(style);
            this.imageUp = style.imageUp;
            this.imageDown = style.imageDown;
            this.imageOver = style.imageOver;
            this.imageChecked = style.imageChecked;
            this.imageCheckedOver = style.imageCheckedOver;
            this.imageDisabled = style.imageDisabled;
            this.imageUpColor = style.imageUpColor;
            this.imageDownColor = style.imageDownColor;
            this.imageCheckedColor = style.imageCheckedColor;
            this.imageDisabledColor = style.imageDisabledColor;
        }
    }
}

