/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.ui;

import arc.Core;
import arc.func.Boolc;
import arc.func.Cons;
import arc.scene.ui.CheckBox;
import arc.scene.ui.Dialog;
import arc.scene.ui.Label;
import arc.scene.ui.Slider;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;

public class SettingsDialog
extends Dialog {
    public SettingsTable main;

    public SettingsDialog() {
        super(Core.bundle.get("settings", "Settings"));
        this.addCloseButton();
        this.main = new SettingsTable();
        this.cont.add(this.main);
    }

    public static class SettingsTable
    extends Table {
        protected Seq<Setting> list = new Seq();
        protected Cons<SettingsTable> rebuilt;

        public SettingsTable() {
            this.left();
        }

        public SettingsTable(Cons<SettingsTable> rebuilt) {
            this.rebuilt = rebuilt;
            this.left();
        }

        public Seq<Setting> getSettings() {
            return this.list;
        }

        public void pref(Setting setting) {
            this.list.add(setting);
            this.rebuild();
        }

        public void screenshakePref() {
            this.sliderPref("screenshake", Core.bundle.get("setting.screenshake.name", "Screen Shake"), 4, 0, 8, (int i) -> (float)i / 4.0f + "x");
        }

        public SliderSetting sliderPref(String name, String title, int def, int min, int max, StringProcessor s) {
            return this.sliderPref(name, title, def, min, max, 1, s);
        }

        public SliderSetting sliderPref(String name, String title, int def, int min, int max, int step, StringProcessor s) {
            SliderSetting res = new SliderSetting(name, title, def, min, max, step, s);
            this.list.add(res);
            Core.settings.defaults(name, def);
            this.rebuild();
            return res;
        }

        public SliderSetting sliderPref(String name, int def, int min, int max, StringProcessor s) {
            return this.sliderPref(name, def, min, max, 1, s);
        }

        public SliderSetting sliderPref(String name, int def, int min, int max, int step, StringProcessor s) {
            SliderSetting res = new SliderSetting(name, Core.bundle.get("setting." + name + ".name"), def, min, max, step, s);
            this.list.add(res);
            Core.settings.defaults(name, def);
            this.rebuild();
            return res;
        }

        public void checkPref(String name, String title, boolean def) {
            this.list.add(new CheckSetting(name, title, def, null));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void checkPref(String name, String title, boolean def, Boolc changed) {
            this.list.add(new CheckSetting(name, title, def, changed));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void checkPref(String name, boolean def) {
            this.list.add(new CheckSetting(name, Core.bundle.get("setting." + name + ".name"), def, null));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void checkPref(String name, boolean def, Boolc changed) {
            this.list.add(new CheckSetting(name, Core.bundle.get("setting." + name + ".name"), def, changed));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        void rebuild() {
            this.clearChildren();
            for (Setting setting : this.list) {
                setting.add(this);
            }
            this.button(Core.bundle.get("settings.reset", "Reset to Defaults"), () -> {
                for (Setting setting : this.list) {
                    if (setting.name == null || setting.title == null) continue;
                    Core.settings.put(setting.name, Core.settings.getDefault(setting.name));
                }
                this.rebuild();
            }).margin(14.0f).width(240.0f).pad(6.0f);
            if (this.rebuilt != null) {
                this.rebuilt.get(this);
            }
        }

        public static class SliderSetting
        extends Setting {
            int def;
            int min;
            int max;
            int step;
            StringProcessor sp;
            float[] values = null;

            SliderSetting(String name, String title, int def, int min, int max, int step, StringProcessor s) {
                this.name = name;
                this.title = title;
                this.def = def;
                this.min = min;
                this.max = max;
                this.step = step;
                this.sp = s;
            }

            @Override
            public void add(SettingsTable table) {
                Slider slider = new Slider(this.min, this.max, this.step, false);
                slider.setValue(Core.settings.getInt(this.name));
                if (this.values != null) {
                    slider.setSnapToValues(this.values, 1.0f);
                }
                Label label = new Label(this.title);
                slider.changed(() -> {
                    Core.settings.put(this.name, (int)slider.getValue());
                    label.setText(this.title + ": " + this.sp.get((int)slider.getValue()));
                });
                slider.change();
                table.table(t -> {
                    t.left().defaults().left();
                    t.add(label).minWidth(label.getPrefWidth() / Scl.scl(1.0f) + 50.0f);
                    t.add(slider).width(180.0f);
                }).left().padTop(3.0f);
                table.row();
            }
        }

        public static class CheckSetting
        extends Setting {
            boolean def;
            Boolc changed;

            CheckSetting(String name, String title, boolean def, Boolc changed) {
                this.name = name;
                this.title = title;
                this.def = def;
                this.changed = changed;
            }

            @Override
            public void add(SettingsTable table) {
                CheckBox box = new CheckBox(this.title);
                box.update(() -> box.setChecked(Core.settings.getBool(this.name)));
                box.changed(() -> {
                    Core.settings.put(this.name, box.isChecked);
                    if (this.changed != null) {
                        this.changed.get(box.isChecked);
                    }
                });
                box.left();
                table.add(box).left().padTop(3.0f);
                table.row();
            }
        }

        public static abstract class Setting {
            public String name;
            public String title;

            public abstract void add(SettingsTable var1);
        }
    }

    public static interface StringProcessor {
        public String get(int var1);
    }
}

