/*
 * Decompiled with CFR 0.152.
 */
package arc.struct;

import arc.struct.IntSeq;
import arc.struct.Seq;
import java.util.Comparator;

public class DelayedRemovalSeq<T>
extends Seq<T> {
    private int iterating;
    private IntSeq remove = new IntSeq(0);
    private int clear;

    public DelayedRemovalSeq() {
    }

    public DelayedRemovalSeq(Seq array) {
        super(array);
    }

    public DelayedRemovalSeq(boolean ordered, int capacity, Class arrayType) {
        super(ordered, capacity, arrayType);
    }

    public DelayedRemovalSeq(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public DelayedRemovalSeq(boolean ordered, T[] array, int startIndex, int count) {
        super(ordered, array, startIndex, count);
    }

    public DelayedRemovalSeq(Class arrayType) {
        super(arrayType);
    }

    public DelayedRemovalSeq(int capacity) {
        super(capacity);
    }

    public DelayedRemovalSeq(T[] array) {
        super(array);
    }

    public static <T> DelayedRemovalSeq<T> with(T ... array) {
        return new DelayedRemovalSeq<T>(array);
    }

    public void begin() {
        ++this.iterating;
    }

    public void end() {
        if (this.iterating == 0) {
            throw new IllegalStateException("begin must be called before end.");
        }
        --this.iterating;
        if (this.iterating == 0) {
            if (this.clear > 0 && this.clear == this.size) {
                this.remove.clear();
                this.clear();
            } else {
                int i;
                int n = this.remove.size;
                for (i = 0; i < n; ++i) {
                    int index = this.remove.pop();
                    if (index < this.clear) continue;
                    this.remove(index);
                }
                for (i = this.clear - 1; i >= 0; --i) {
                    this.remove(i);
                }
            }
            this.clear = 0;
        }
    }

    private void removeIntern(int index) {
        if (index < this.clear) {
            return;
        }
        int n = this.remove.size;
        for (int i = 0; i < n; ++i) {
            int removeIndex = this.remove.get(i);
            if (index == removeIndex) {
                return;
            }
            if (index >= removeIndex) continue;
            this.remove.insert(i, index);
            return;
        }
        this.remove.add(index);
    }

    @Override
    public boolean remove(T value, boolean identity) {
        if (this.iterating > 0) {
            int index = this.indexOf(value, identity);
            if (index == -1) {
                return false;
            }
            this.removeIntern(index);
            return true;
        }
        return super.remove(value, identity);
    }

    @Override
    public T remove(int index) {
        if (this.iterating > 0) {
            this.removeIntern(index);
            return this.get(index);
        }
        return super.remove(index);
    }

    @Override
    public void removeRange(int start, int end) {
        if (this.iterating > 0) {
            for (int i = end; i >= start; --i) {
                this.removeIntern(i);
            }
        } else {
            super.removeRange(start, end);
        }
    }

    @Override
    public Seq<T> clear() {
        if (this.iterating > 0) {
            this.clear = this.size;
            return this;
        }
        return super.clear();
    }

    @Override
    public void set(int index, T value) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.set(index, value);
    }

    @Override
    public void insert(int index, T value) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.insert(index, value);
    }

    @Override
    public void swap(int first, int second) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.swap(first, second);
    }

    @Override
    public T pop() {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        return super.pop();
    }

    @Override
    public Seq<T> sort() {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        return super.sort();
    }

    @Override
    public Seq<T> sort(Comparator<? super T> comparator) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        return super.sort(comparator);
    }

    @Override
    public void reverse() {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.reverse();
    }

    @Override
    public void shuffle() {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.shuffle();
    }

    @Override
    public void truncate(int newSize) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.truncate(newSize);
    }

    @Override
    public T[] setSize(int newSize) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        return super.setSize(newSize);
    }
}

