/*
 * Decompiled with CFR 0.152.
 */
package arc.struct;

import arc.struct.Seq;
import java.util.Comparator;

public class SnapshotSeq<T>
extends Seq<T> {
    private T[] snapshot;
    private T[] recycled;
    private int snapshots;

    public SnapshotSeq() {
    }

    public SnapshotSeq(Seq<T> array) {
        super(array);
    }

    public SnapshotSeq(boolean ordered, int capacity, Class arrayType) {
        super(ordered, capacity, arrayType);
    }

    public SnapshotSeq(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public SnapshotSeq(boolean ordered, T[] array, int startIndex, int count) {
        super(ordered, array, startIndex, count);
    }

    public SnapshotSeq(Class arrayType) {
        super(arrayType);
    }

    public SnapshotSeq(int capacity) {
        super(capacity);
    }

    public SnapshotSeq(T[] array) {
        super(array);
    }

    public static <T> SnapshotSeq<T> with(T ... array) {
        return new SnapshotSeq<T>(array);
    }

    public T[] begin() {
        this.modified();
        this.snapshot = this.items;
        ++this.snapshots;
        return this.items;
    }

    public void end() {
        this.snapshots = Math.max(0, this.snapshots - 1);
        if (this.snapshot == null) {
            return;
        }
        if (this.snapshot != this.items && this.snapshots == 0) {
            this.recycled = this.snapshot;
            int n = this.recycled.length;
            for (int i = 0; i < n; ++i) {
                this.recycled[i] = null;
            }
        }
        this.snapshot = null;
    }

    private void modified() {
        if (this.snapshot == null || this.snapshot != this.items) {
            return;
        }
        if (this.recycled != null && this.recycled.length >= this.size) {
            System.arraycopy(this.items, 0, this.recycled, 0, this.size);
            this.items = this.recycled;
            this.recycled = null;
        } else {
            this.resize(this.items.length);
        }
    }

    @Override
    public void set(int index, T value) {
        this.modified();
        super.set(index, value);
    }

    @Override
    public void insert(int index, T value) {
        this.modified();
        super.insert(index, value);
    }

    @Override
    public void swap(int first, int second) {
        this.modified();
        super.swap(first, second);
    }

    @Override
    public boolean remove(T value, boolean identity) {
        this.modified();
        return super.remove(value, identity);
    }

    @Override
    public T remove(int index) {
        this.modified();
        return super.remove(index);
    }

    @Override
    public void removeRange(int start, int end) {
        this.modified();
        super.removeRange(start, end);
    }

    @Override
    public boolean removeAll(Seq<? extends T> array, boolean identity) {
        this.modified();
        return super.removeAll(array, identity);
    }

    @Override
    public T pop() {
        this.modified();
        return super.pop();
    }

    @Override
    public Seq<T> clear() {
        this.modified();
        super.clear();
        return this;
    }

    @Override
    public Seq<T> sort() {
        this.modified();
        return super.sort();
    }

    @Override
    public Seq<T> sort(Comparator<? super T> comparator) {
        this.modified();
        return super.sort(comparator);
    }

    @Override
    public void reverse() {
        this.modified();
        super.reverse();
    }

    @Override
    public void shuffle() {
        this.modified();
        super.shuffle();
    }

    @Override
    public void truncate(int newSize) {
        this.modified();
        super.truncate(newSize);
    }

    @Override
    public T[] setSize(int newSize) {
        this.modified();
        return super.setSize(newSize);
    }
}

