/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.util.ColorCodes;
import arc.util.Strings;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Log {
    private static final Object[] empty = new Object[0];
    public static boolean useColors = true;
    public static LogLevel level = LogLevel.info;
    public static LogHandler logger = new DefaultLogHandler();
    public static LogFormatter formatter = new DefaultLogFormatter();

    public static void log(LogLevel level, String text, Object ... args) {
        if (Log.level.ordinal() > level.ordinal()) {
            return;
        }
        logger.log(level, Log.format(text, args));
    }

    public static void debug(String text, Object ... args) {
        Log.log(LogLevel.debug, text, args);
    }

    public static void debug(Object object) {
        Log.debug(String.valueOf(object), empty);
    }

    public static void infoList(Object ... args) {
        if (level.ordinal() > LogLevel.info.ordinal()) {
            return;
        }
        StringBuilder build = new StringBuilder();
        for (Object o : args) {
            build.append(o);
            build.append(" ");
        }
        Log.info(build.toString());
    }

    public static void infoTag(String tag, String text) {
        Log.log(LogLevel.info, "[" + tag + "] " + text, new Object[0]);
    }

    public static void info(String text, Object ... args) {
        Log.log(LogLevel.info, text, args);
    }

    public static void info(Object object) {
        Log.info(String.valueOf(object), empty);
    }

    public static void warn(String text, Object ... args) {
        Log.log(LogLevel.warn, text, args);
    }

    public static void errTag(String tag, String text) {
        Log.log(LogLevel.err, "[" + tag + "] " + text, new Object[0]);
    }

    public static void err(String text, Object ... args) {
        Log.log(LogLevel.err, text, args);
    }

    public static void err(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        Log.err(sw.toString(), new Object[0]);
    }

    public static void err(String text, Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        Log.err(text + ": " + sw.toString(), new Object[0]);
    }

    public static String format(String text, Object ... args) {
        return Log.formatColors(text, useColors, args);
    }

    public static String formatColors(String text, boolean useColors, Object ... args) {
        return formatter.format(text, useColors, args);
    }

    public static String removeColors(String text) {
        for (String color : ColorCodes.codes) {
            text = text.replace("&" + color, "");
        }
        return text;
    }

    public static String addColors(String text) {
        for (int i = 0; i < ColorCodes.codes.length; ++i) {
            text = text.replace("&" + ColorCodes.codes[i], ColorCodes.values[i]);
        }
        return text;
    }

    public static enum LogLevel {
        debug,
        info,
        warn,
        err,
        none;

    }

    public static interface LogHandler {
        public void log(LogLevel var1, String var2);
    }

    public static interface LogFormatter {
        public String format(String var1, boolean var2, Object ... var3);
    }

    public static class DefaultLogHandler
    implements LogHandler {
        @Override
        public void log(LogLevel level, String text) {
            System.out.println(Log.format((level == LogLevel.debug ? "&lc&fb" : (level == LogLevel.info ? "&fb" : (level == LogLevel.warn ? "&ly&fb" : (level == LogLevel.err ? "&lr&fb" : "")))) + text + "&fr", new Object[0]));
        }
    }

    public static class DefaultLogFormatter
    implements LogFormatter {
        @Override
        public String format(String text, boolean useColors, Object ... args) {
            text = Strings.format(text, args);
            return useColors ? Log.addColors(text) : Log.removeColors(text);
        }
    }

    public static class NoopLogHandler
    implements LogHandler {
        @Override
        public void log(LogLevel level, String text) {
        }
    }
}

