/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.Net;
import arc.func.Cons;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.async.AsyncExecutor;
import arc.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class NetJavaImpl {
    private final AsyncExecutor asyncExecutor = new AsyncExecutor(6);
    private boolean block;

    public void http(Net.HttpRequest request, Cons<Net.HttpResponse> success, Cons<Throwable> failure) {
        if (request.url == null) {
            failure.get(new ArcRuntimeException("can't process a HTTP request without URL set"));
            return;
        }
        try {
            URL url;
            Net.HttpMethod method = request.method;
            if (method == Net.HttpMethod.GET) {
                String queryString = "";
                String value = request.content;
                if (value != null && !"".equals(value)) {
                    queryString = "?" + value;
                }
                url = new URL(request.url + queryString);
            } else {
                url = new URL(request.url);
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            boolean doingOutPut = method == Net.HttpMethod.POST || method == Net.HttpMethod.PUT;
            connection.setDoOutput(doingOutPut);
            connection.setDoInput(true);
            connection.setRequestMethod(method.toString());
            HttpURLConnection.setFollowRedirects(request.followRedirects);
            request.headers.each(connection::addRequestProperty);
            connection.setConnectTimeout(request.timeout);
            connection.setReadTimeout(request.timeout);
            this.run(() -> {
                try {
                    if (doingOutPut) {
                        String contentAsString = request.content;
                        if (contentAsString != null) {
                            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
                            try {
                                writer.write(contentAsString);
                            }
                            finally {
                                Streams.close(writer);
                            }
                        }
                        InputStream contentAsStream = request.contentStream;
                        if (contentAsStream != null) {
                            OutputStream os = connection.getOutputStream();
                            try {
                                Streams.copy(contentAsStream, os);
                            }
                            finally {
                                Streams.close(os);
                            }
                        }
                    }
                    connection.connect();
                    HttpClientResponse clientResponse = new HttpClientResponse(connection);
                    try {
                        success.get(clientResponse);
                    }
                    finally {
                        connection.disconnect();
                    }
                }
                catch (Throwable e) {
                    connection.disconnect();
                    failure.get(e);
                }
            });
        }
        catch (Throwable e) {
            failure.get(e);
        }
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    private void run(Runnable run) {
        if (this.block) {
            run.run();
        } else {
            this.asyncExecutor.submit(run);
        }
    }

    static class HttpClientResponse
    implements Net.HttpResponse {
        private final HttpURLConnection connection;
        private Net.HttpStatus status;

        public HttpClientResponse(HttpURLConnection connection) throws IOException {
            this.connection = connection;
            this.status = Net.HttpStatus.byCode(connection.getResponseCode());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getResult() {
            InputStream input = this.getInputStream();
            if (input == null) {
                return Streams.EMPTY_BYTES;
            }
            try {
                byte[] byArray = Streams.copyBytes(input, this.connection.getContentLength());
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = Streams.EMPTY_BYTES;
                return byArray;
            }
            finally {
                Streams.close(input);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getResultAsString() {
            InputStream input = this.getInputStream();
            if (input == null) {
                return "";
            }
            try {
                String string = Streams.copyString(input, this.connection.getContentLength());
                return string;
            }
            catch (IOException e) {
                String string = "";
                return string;
            }
            finally {
                Streams.close(input);
            }
        }

        @Override
        public InputStream getResultAsStream() {
            return this.getInputStream();
        }

        @Override
        public Net.HttpStatus getStatus() {
            return this.status;
        }

        @Override
        public String getHeader(String name) {
            return this.connection.getHeaderField(name);
        }

        @Override
        public ObjectMap<String, Seq<String>> getHeaders() {
            ObjectMap<String, Seq<String>> out = new ObjectMap<String, Seq<String>>();
            Map<String, List<String>> fields = this.connection.getHeaderFields();
            for (String key : fields.keySet()) {
                if (key == null) continue;
                out.put(key, Seq.with(fields.get(key).toArray(new String[0])));
            }
            return out;
        }

        private InputStream getInputStream() {
            try {
                return this.connection.getInputStream();
            }
            catch (IOException e) {
                return this.connection.getErrorStream();
            }
        }
    }
}

