/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.Core;
import arc.files.Fi;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class OS {
    public static final int cores = Runtime.getRuntime().availableProcessors();
    public static final String username = OS.prop("user.name");
    public static final String userhome = OS.prop("user.home");
    public static boolean isWindows = OS.propNoNull("os.name").contains("Windows");
    public static boolean isLinux = OS.propNoNull("os.name").contains("Linux") || OS.propNoNull("os.name").contains("BSD");
    public static boolean isMac = OS.propNoNull("os.name").contains("Mac");
    public static boolean isIos = false;
    public static boolean isAndroid = false;
    public static boolean isARM = OS.propNoNull("os.arch").startsWith("arm") || OS.propNoNull("os.arch").startsWith("aarch64");
    public static boolean is64Bit;

    public static String getAppDataDirectoryString(String appname) {
        if (isWindows) {
            return OS.env("AppData") + "\\\\" + appname;
        }
        if (isIos || isAndroid) {
            return Core.files.getLocalStoragePath();
        }
        if (isLinux) {
            if (System.getenv("XDG_DATA_HOME") != null) {
                String dir = System.getenv("XDG_DATA_HOME");
                if (!dir.endsWith("/")) {
                    dir = dir + "/";
                }
                return dir + appname + "/";
            }
            return OS.prop("user.home") + "/.local/share/" + appname + "/";
        }
        if (isMac) {
            return OS.prop("user.home") + "/Library/Application Support/" + appname + "/";
        }
        return null;
    }

    public static String exec(String ... args) {
        try {
            String line;
            Process process = Runtime.getRuntime().exec(args);
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder result = new StringBuilder();
            while ((line = in.readLine()) != null) {
                result.append(line).append("\n");
            }
            BufferedReader inerr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = inerr.readLine()) != null) {
                result.append(line).append("\n");
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean execSafe(String command) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream()));
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Fi getAppDataDirectory(String appname) {
        return Core.files.absolute(OS.getAppDataDirectoryString(appname));
    }

    public static boolean hasProp(String name) {
        return System.getProperty(name) != null;
    }

    public static String prop(String name) {
        return System.getProperty(name);
    }

    public static boolean hasEnv(String name) {
        return System.getenv(name) != null;
    }

    public static String env(String name) {
        return System.getenv(name);
    }

    public static String propNoNull(String name) {
        String s = OS.prop(name);
        return s == null ? "" : s;
    }

    static {
        boolean bl = is64Bit = OS.propNoNull("os.arch").contains("64") || OS.propNoNull("os.arch").startsWith("armv8");
        if (OS.propNoNull("java.runtime.name").contains("Android Runtime") || OS.propNoNull("java.vm.vendor").contains("The Android Project") || OS.propNoNull("java.vendor").contains("The Android Project")) {
            isAndroid = true;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
        if (OS.propNoNull("moe.platform.name").equals("iOS") || !isAndroid && !isWindows && !isLinux && !isMac) {
            isIos = true;
            isAndroid = false;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
    }
}

