/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.func.Prov;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class Reflect {
    public static boolean isWrapper(Class<?> type) {
        return type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Character.class || type == Boolean.class || type == Float.class || type == Double.class;
    }

    public static <T> Prov<T> cons(Class<T> type) {
        try {
            Constructor c = type.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return () -> {
                try {
                    return c.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T get(Field field) {
        return Reflect.get(null, field);
    }

    public static <T> T get(Object object, Field field) {
        try {
            return (T)field.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T get(Class<?> type, Object object, String name) {
        try {
            Field field = type.getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T get(Object object, String name) {
        return Reflect.get(object.getClass(), object, name);
    }

    public static <T> T get(Class<?> type, String name) {
        return Reflect.get(type, null, name);
    }

    public static void set(Class<?> type, Object object, String name, Object value) {
        try {
            Field field = type.getDeclaredField(name);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void set(Object object, String name, Object value) {
        Reflect.set(object.getClass(), object, name, value);
    }

    public static void set(Class<?> type, String name, Object value) {
        Reflect.set(type, null, name, value);
    }

    public static <T> T make(String type) {
        try {
            Class<?> c = Class.forName(type);
            return (T)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

