/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.Core;
import arc.func.Floatp;
import arc.struct.LongSeq;
import arc.struct.Seq;
import arc.util.Timer;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;

public class Time {
    public static final float toSeconds = 60.0f;
    public static final float toMinutes = 3600.0f;
    public static final float toHours = 216000.0f;
    public static float delta = 1.0f;
    public static float time;
    public static float globalTime;
    public static final long nanosPerMilli = 1000000L;
    private static double timeRaw;
    private static double globalTimeRaw;
    private static Seq<DelayRun> runs;
    private static Seq<DelayRun> removal;
    private static LongSeq marks;
    private static Floatp deltaimpl;

    public static void run(float delay, Runnable r) {
        DelayRun run = Pools.obtain(DelayRun.class, DelayRun::new);
        run.finish = r;
        run.delay = delay;
        runs.add(run);
    }

    public static Timer.Task runTask(float delay, Runnable r) {
        return Timer.schedule(r, delay / 60.0f);
    }

    public static void mark() {
        marks.add(Time.nanos());
    }

    public static float elapsed() {
        if (Time.marks.size == 0) {
            return -1.0f;
        }
        return (float)Time.timeSinceNanos(marks.pop()) / 1000000.0f;
    }

    public static void updateGlobal() {
        globalTimeRaw += (double)(Core.graphics.getDeltaTime() * 60.0f);
        delta = deltaimpl.get();
        if (Double.isInfinite(timeRaw) || Double.isNaN(timeRaw)) {
            timeRaw = 0.0;
        }
        time = (float)timeRaw;
        globalTime = (float)globalTimeRaw;
    }

    public static void update() {
        removal.clear();
        if (Double.isInfinite(timeRaw += (double)delta) || Double.isNaN(timeRaw)) {
            timeRaw = 0.0;
        }
        time = (float)timeRaw;
        globalTime = (float)globalTimeRaw;
        for (DelayRun run : runs) {
            run.delay -= delta;
            if (!(run.delay <= 0.0f)) continue;
            run.finish.run();
            removal.add(run);
            Pools.free(run);
        }
        runs.removeAll(removal);
    }

    public static void clear() {
        runs.clear();
    }

    public static void setDeltaProvider(Floatp impl) {
        deltaimpl = impl;
        delta = impl.get();
    }

    public static long nanos() {
        return System.nanoTime();
    }

    public static long millis() {
        return System.currentTimeMillis();
    }

    public static long nanosToMillis(long nanos) {
        return nanos / 1000000L;
    }

    public static long millisToNanos(long millis) {
        return millis * 1000000L;
    }

    public static long timeSinceNanos(long prevTime) {
        return Time.nanos() - prevTime;
    }

    public static long timeSinceMillis(long prevTime) {
        return Time.millis() - prevTime;
    }

    static {
        runs = new Seq();
        removal = new Seq();
        marks = new LongSeq();
        deltaimpl = () -> Math.min(Core.graphics.getDeltaTime() * 60.0f, 3.0f);
    }

    public static class DelayRun
    implements Pool.Poolable {
        float delay;
        Runnable finish;

        @Override
        public void reset() {
            this.delay = 0.0f;
            this.finish = null;
        }
    }
}

