/*
 * Decompiled with CFR 0.152.
 */
package arc.util.async;

import arc.util.ArcRuntimeException;
import arc.util.Disposable;
import arc.util.async.AsyncResult;
import arc.util.async.AsyncTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AsyncExecutor
implements Disposable {
    private final ExecutorService executor;

    public AsyncExecutor(int maxConcurrent) {
        this.executor = Executors.newFixedThreadPool(maxConcurrent, r -> {
            Thread thread = new Thread(r, "AsynchExecutor-Thread");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((t, e) -> e.printStackTrace());
            return thread;
        });
    }

    public AsyncResult<Void> submit(Runnable run) {
        return this.submit(() -> {
            run.run();
            return null;
        });
    }

    public <T> AsyncResult<T> submit(AsyncTask<T> task) {
        if (this.executor.isShutdown()) {
            throw new ArcRuntimeException("Cannot run tasks on an executor that has been shutdown (disposed)");
        }
        return new AsyncResult<Object>(this.executor.submit(task::call));
    }

    @Override
    public void dispose() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ArcRuntimeException("Couldn't shutdown loading thread", e);
        }
    }
}

