/*
 * Decompiled with CFR 0.152.
 */
package arc.util.serialization;

import arc.files.Fi;
import arc.struct.ArrayMap;
import arc.struct.IntSet;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.OrderedMap;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Reflect;
import arc.util.io.Streams;
import arc.util.serialization.BaseJsonWriter;
import arc.util.serialization.JsonReader;
import arc.util.serialization.JsonValue;
import arc.util.serialization.JsonWriter;
import arc.util.serialization.SerializationException;
import arc.util.serialization.UBJsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Json {
    private static final boolean debug = false;
    private final ObjectMap<Class, OrderedMap<String, FieldMetadata>> typeToFields = new ObjectMap();
    private final ObjectMap<String, Class> tagToClass = new ObjectMap();
    private final ObjectMap<Class, String> classToTag = new ObjectMap();
    private final ObjectMap<Class, Serializer> classToSerializer = new ObjectMap();
    private final ObjectMap<Class, Object[]> classToDefaultValues = new ObjectMap();
    private final Object[] equals1 = new Object[]{null};
    private final Object[] equals2 = new Object[]{null};
    private BaseJsonWriter writer;
    private String typeName = "class";
    private boolean usePrototypes = true;
    private JsonWriter.OutputType outputType;
    private boolean quoteLongValues;
    private boolean ignoreUnknownFields = true;
    private boolean ignoreDeprecated;
    private boolean readDeprecated;
    private boolean enumNames = true;
    private Serializer defaultSerializer;

    public Json() {
        this.outputType = JsonWriter.OutputType.minimal;
    }

    public Json(JsonWriter.OutputType outputType) {
        this.outputType = outputType;
    }

    public boolean getIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public void setIgnoreDeprecated(boolean ignoreDeprecated) {
        this.ignoreDeprecated = ignoreDeprecated;
    }

    public void setReadDeprecated(boolean readDeprecated) {
        this.readDeprecated = readDeprecated;
    }

    public void setOutputType(JsonWriter.OutputType outputType) {
        this.outputType = outputType;
    }

    public void setQuoteLongValues(boolean quoteLongValues) {
        this.quoteLongValues = quoteLongValues;
    }

    public void setEnumNames(boolean enumNames) {
        this.enumNames = enumNames;
    }

    public void addClassTag(String tag, Class type) {
        this.tagToClass.put(tag, type);
        this.classToTag.put(type, tag);
    }

    public Class getClass(String tag) {
        return this.tagToClass.get(tag);
    }

    public String getTag(Class type) {
        return this.classToTag.get(type);
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setDefaultSerializer(Serializer defaultSerializer) {
        this.defaultSerializer = defaultSerializer;
    }

    public <T> void setSerializer(Class<T> type, Serializer<T> serializer) {
        this.classToSerializer.put(type, serializer);
    }

    public <T> Serializer<T> getSerializer(Class<T> type) {
        return this.classToSerializer.get(type);
    }

    public void setUsePrototypes(boolean usePrototypes) {
        this.usePrototypes = usePrototypes;
    }

    public void setElementType(Class type, String fieldName, Class elementType) {
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        FieldMetadata metadata = (FieldMetadata)fields.get(fieldName);
        if (metadata == null) {
            throw new SerializationException("Field not found: " + fieldName + " (" + type.getName() + ")");
        }
        metadata.elementType = elementType;
    }

    public OrderedMap<String, FieldMetadata> getFields(Class type) {
        OrderedMap<String, FieldMetadata> fields = this.typeToFields.get(type);
        if (fields != null) {
            return fields;
        }
        Seq classHierarchy = new Seq();
        for (Class nextClass = type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            classHierarchy.add(nextClass);
        }
        Seq<Field> allFields = new Seq<Field>();
        for (int i = classHierarchy.size - 1; i >= 0; --i) {
            allFields.addAll(((Class)classHierarchy.get(i)).getDeclaredFields());
        }
        OrderedMap<String, FieldMetadata> nameToField = new OrderedMap<String, FieldMetadata>(allFields.size);
        for (Field field : allFields) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || type.isEnum() || Reflect.isWrapper(type)) continue;
            if (!field.isAccessible()) {
                try {
                    field.setAccessible(true);
                }
                catch (Exception ex) {
                    continue;
                }
            }
            if (this.ignoreDeprecated && !this.readDeprecated && field.isAnnotationPresent(Deprecated.class)) continue;
            FieldMetadata data = new FieldMetadata(field);
            nameToField.put(field.getName(), data);
        }
        this.typeToFields.put(type, nameToField);
        return nameToField;
    }

    public String toJson(Object object) {
        return this.toJson(object, object == null ? null : object.getClass(), (Class)null);
    }

    public String toJson(Object object, Class knownType) {
        return this.toJson(object, knownType, (Class)null);
    }

    public void toUBJson(Object object, Class knownType, OutputStream stream) {
        this.writer = new UBJsonWriter(stream);
        this.toJson(object, knownType, (Class)null);
    }

    public String toJson(Object object, Class knownType, Class elementType) {
        StringWriter buffer = new StringWriter();
        this.toJson(object, knownType, elementType, buffer);
        return buffer.toString();
    }

    public void toJson(Object object, Fi file) {
        this.toJson(object, object == null ? null : object.getClass(), null, file);
    }

    public void toJson(Object object, Class knownType, Fi file) {
        this.toJson(object, knownType, null, file);
    }

    public void toJson(Object object, Class knownType, Class elementType, Fi file) {
        Writer writer = null;
        try {
            writer = file.writer(false, "UTF-8");
            this.toJson(object, knownType, elementType, writer);
        }
        catch (Exception ex) {
            try {
                throw new SerializationException("Error writing file: " + file, ex);
            }
            catch (Throwable throwable) {
                Streams.close(writer);
                throw throwable;
            }
        }
        Streams.close(writer);
    }

    public void toJson(Object object, Writer writer) {
        this.toJson(object, object == null ? null : object.getClass(), null, writer);
    }

    public void toJson(Object object, Class knownType, Writer writer) {
        this.toJson(object, knownType, null, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toJson(Object object, Class knownType, Class elementType, Writer writer) {
        this.setWriter(new JsonWriter(writer));
        try {
            this.writeValue(object, knownType, elementType);
        }
        finally {
            Streams.close(this.writer);
            this.writer = null;
        }
    }

    public BaseJsonWriter getWriter() {
        return this.writer;
    }

    public void setWriter(BaseJsonWriter writer) {
        this.writer = writer;
        this.writer.setOutputType(this.outputType);
        this.writer.setQuoteLongValues(this.quoteLongValues);
    }

    public void writeFields(Object object) {
        Class<?> type = object.getClass();
        Object[] defaultValues = this.getDefaultValues(type);
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        int i = 0;
        for (FieldMetadata metadata : new OrderedMap.OrderedMapValues<FieldMetadata>(fields)) {
            Field field = metadata.field;
            if (this.readDeprecated && this.ignoreDeprecated && field.isAnnotationPresent(Deprecated.class)) continue;
            try {
                Object value = field.get(object);
                if (defaultValues != null) {
                    Object defaultValue = defaultValues[i++];
                    if (value == null && defaultValue == null) continue;
                    if (value != null && defaultValue != null) {
                        if (value.equals(defaultValue)) continue;
                        if (value.getClass().isArray() && defaultValue.getClass().isArray()) {
                            this.equals1[0] = value;
                            this.equals2[0] = defaultValue;
                            if (Arrays.deepEquals(this.equals1, this.equals2)) continue;
                        }
                    }
                }
                this.writer.name(field.getName());
                this.writeValue(value, field.getType(), metadata.elementType);
            }
            catch (IllegalAccessException ex) {
                throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
            }
            catch (SerializationException ex) {
                ex.addTrace(field + " (" + type.getName() + ")");
                throw ex;
            }
            catch (Exception runtimeEx) {
                SerializationException ex = new SerializationException(runtimeEx);
                ex.addTrace(field + " (" + type.getName() + ")");
                throw ex;
            }
        }
    }

    private Object[] getDefaultValues(Class type) {
        Object object;
        if (!this.usePrototypes) {
            return null;
        }
        if (this.classToDefaultValues.containsKey(type)) {
            return this.classToDefaultValues.get(type);
        }
        try {
            object = this.newInstance(type);
        }
        catch (Exception ex) {
            this.classToDefaultValues.put(type, null);
            return null;
        }
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        Object[] values = new Object[fields.size];
        this.classToDefaultValues.put(type, values);
        int i = 0;
        for (FieldMetadata metadata : ((ObjectMap)fields).values()) {
            Field field = metadata.field;
            if (this.readDeprecated && this.ignoreDeprecated && field.isAnnotationPresent(Deprecated.class)) continue;
            try {
                values[i++] = field.get(object);
            }
            catch (IllegalAccessException ex) {
                throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
            }
            catch (SerializationException ex) {
                ex.addTrace(field + " (" + type.getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                SerializationException ex = new SerializationException(runtimeEx);
                ex.addTrace(field + " (" + type.getName() + ")");
                throw ex;
            }
        }
        return values;
    }

    public void writeField(Object object, String name) {
        this.writeField(object, name, name, null);
    }

    public void writeField(Object object, String name, Class elementType) {
        this.writeField(object, name, name, elementType);
    }

    public void writeField(Object object, String fieldName, String jsonName) {
        this.writeField(object, fieldName, jsonName, null);
    }

    public void writeField(Object object, String fieldName, String jsonName, Class elementType) {
        Class<?> type = object.getClass();
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        FieldMetadata metadata = (FieldMetadata)fields.get(fieldName);
        if (metadata == null) {
            throw new SerializationException("Field not found: " + fieldName + " (" + type.getName() + ")");
        }
        Field field = metadata.field;
        if (elementType == null) {
            elementType = metadata.elementType;
        }
        try {
            this.writer.name(jsonName);
            this.writeValue(field.get(object), field.getType(), elementType);
        }
        catch (IllegalAccessException ex) {
            throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
        }
        catch (SerializationException ex) {
            ex.addTrace(field + " (" + type.getName() + ")");
            throw ex;
        }
        catch (Exception runtimeEx) {
            SerializationException ex = new SerializationException(runtimeEx);
            ex.addTrace(field + " (" + type.getName() + ")");
            throw ex;
        }
    }

    public void writeValue(String name, Object value) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        if (value == null) {
            this.writeValue(value, null, null);
        } else {
            this.writeValue(value, value.getClass(), null);
        }
    }

    public void writeValue(String name, Object value, Class knownType) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        this.writeValue(value, knownType, null);
    }

    public void writeValue(String name, Object value, Class knownType, Class elementType) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        this.writeValue(value, knownType, elementType);
    }

    public void writeValue(Object value) {
        if (value == null) {
            this.writeValue(value, null, null);
        } else {
            this.writeValue(value, value.getClass(), null);
        }
    }

    public void writeValue(Object value, Class knownType) {
        this.writeValue(value, knownType, null);
    }

    /*
     * WARNING - void declaration
     */
    public void writeValue(Object value, Class knownType, Class elementType) {
        if (knownType != null && knownType.isAnonymousClass()) {
            knownType = knownType.getSuperclass();
        }
        try {
            Class<?> actualType;
            if (value == null) {
                this.writer.value(null);
                return;
            }
            if (knownType != null && knownType.isPrimitive() || knownType == String.class || knownType == Integer.class || knownType == Boolean.class || knownType == Float.class || knownType == Long.class || knownType == Double.class || knownType == Short.class || knownType == Byte.class || knownType == Character.class) {
                this.writer.value(value);
                return;
            }
            Class<?> clazz = actualType = value.getClass().isAnonymousClass() ? value.getClass().getSuperclass() : value.getClass();
            if (actualType.isPrimitive() || actualType == String.class || actualType == Integer.class || actualType == Boolean.class || actualType == Float.class || actualType == Long.class || actualType == Double.class || actualType == Short.class || actualType == Byte.class || actualType == Character.class) {
                this.writeObjectStart(actualType, null);
                this.writeValue("value", value);
                this.writeObjectEnd();
                return;
            }
            if (value instanceof JsonSerializable) {
                this.writeObjectStart(actualType, knownType);
                ((JsonSerializable)value).write(this);
                this.writeObjectEnd();
                return;
            }
            Serializer serializer = this.classToSerializer.get(actualType);
            if (serializer != null) {
                serializer.write(this, value, knownType);
                return;
            }
            if (value instanceof Seq) {
                void var7_19;
                if (knownType != null && actualType != knownType && actualType != Seq.class) {
                    throw new SerializationException("Serialization of an Array other than the known type is not supported.\nKnown type: " + knownType + "\nActual type: " + actualType);
                }
                this.writeArrayStart();
                Seq array = (Seq)value;
                boolean bl = false;
                int n = array.size;
                while (var7_19 < n) {
                    this.writeValue(array.get((int)var7_19), elementType, null);
                    ++var7_19;
                }
                this.writeArrayEnd();
                return;
            }
            if (value instanceof ObjectSet) {
                if (knownType == null) {
                    knownType = ObjectSet.class;
                }
                this.writeObjectStart(actualType, knownType);
                this.writer.name("values");
                this.writeArrayStart();
                for (Object e : (ObjectSet)value) {
                    this.writeValue(e, elementType, null);
                }
                this.writeArrayEnd();
                this.writeObjectEnd();
                return;
            }
            if (value instanceof IntSet) {
                if (knownType == null) {
                    knownType = IntSet.class;
                }
                this.writeObjectStart(actualType, knownType);
                this.writer.name("values");
                this.writeArrayStart();
                IntSet.IntSetIterator iter = ((IntSet)value).iterator();
                while (iter.hasNext) {
                    this.writeValue(iter.next(), Integer.class, null);
                }
                this.writeArrayEnd();
                this.writeObjectEnd();
                return;
            }
            if (value instanceof Queue) {
                void var7_22;
                if (knownType != null && actualType != knownType && actualType != Queue.class) {
                    throw new SerializationException("Serialization of a Queue other than the known type is not supported.\nKnown type: " + knownType + "\nActual type: " + actualType);
                }
                this.writeArrayStart();
                Queue queue = (Queue)value;
                boolean bl = false;
                int n = queue.size;
                while (var7_22 < n) {
                    this.writeValue(queue.get((int)var7_22), elementType, null);
                    ++var7_22;
                }
                this.writeArrayEnd();
                return;
            }
            if (value instanceof Collection) {
                if (this.typeName != null && actualType != ArrayList.class && (knownType == null || knownType != actualType)) {
                    this.writeObjectStart(actualType, knownType);
                    this.writeArrayStart("items");
                    for (Object e : (Collection)value) {
                        this.writeValue(e, elementType, null);
                    }
                    this.writeArrayEnd();
                    this.writeObjectEnd();
                } else {
                    this.writeArrayStart();
                    for (Object e : (Collection)value) {
                        this.writeValue(e, elementType, null);
                    }
                    this.writeArrayEnd();
                }
                return;
            }
            if (actualType.isArray()) {
                void var7_26;
                if (elementType == null) {
                    elementType = actualType.getComponentType();
                }
                int length = Array.getLength(value);
                this.writeArrayStart();
                boolean bl = false;
                while (var7_26 < length) {
                    this.writeValue(Array.get(value, (int)var7_26), elementType, null);
                    ++var7_26;
                }
                this.writeArrayEnd();
                return;
            }
            if (value instanceof ObjectMap) {
                if (knownType == null) {
                    knownType = ObjectMap.class;
                }
                this.writeObjectStart(actualType, knownType);
                for (ObjectMap.Entry entry : ((ObjectMap)value).entries()) {
                    this.writer.name(this.convertToString(entry.key));
                    this.writeValue(entry.value, elementType, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (value instanceof ObjectIntMap) {
                if (knownType == null) {
                    knownType = ObjectIntMap.class;
                }
                this.writeObjectStart(actualType, knownType);
                for (ObjectIntMap.Entry entry : ((ObjectIntMap)value).entries()) {
                    this.writer.name(this.convertToString(entry.key));
                    this.writer.value(entry.value);
                }
                this.writeObjectEnd();
                return;
            }
            if (value instanceof ArrayMap) {
                void var7_30;
                if (knownType == null) {
                    knownType = ArrayMap.class;
                }
                this.writeObjectStart(actualType, knownType);
                ArrayMap map = (ArrayMap)value;
                boolean bl = false;
                int n = map.size;
                while (var7_30 < n) {
                    this.writer.name(this.convertToString(map.keys[var7_30]));
                    this.writeValue(map.values[var7_30], elementType, null);
                    ++var7_30;
                }
                this.writeObjectEnd();
                return;
            }
            if (value instanceof Map) {
                if (knownType == null) {
                    knownType = HashMap.class;
                }
                this.writeObjectStart(actualType, knownType);
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    this.writer.name(this.convertToString(entry.getKey()));
                    this.writeValue(entry.getValue(), elementType, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (Enum.class.isAssignableFrom(actualType)) {
                if (this.typeName != null && (knownType == null || knownType != actualType)) {
                    if (actualType.getEnumConstants() == null) {
                        actualType = actualType.getSuperclass();
                    }
                    this.writeObjectStart(actualType, null);
                    this.writer.name("value");
                    this.writer.value(this.convertToString((Enum)value));
                    this.writeObjectEnd();
                } else {
                    this.writer.value(this.convertToString((Enum)value));
                }
                return;
            }
            this.writeObjectStart(actualType, knownType);
            this.writeFields(value);
            this.writeObjectEnd();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeObjectStart(String name) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        this.writeObjectStart();
    }

    public void writeObjectStart(String name, Class actualType, Class knownType) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        this.writeObjectStart(actualType, knownType);
    }

    public void writeObjectStart() {
        try {
            this.writer.object();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeObjectStart(Class actualType, Class knownType) {
        try {
            this.writer.object();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        if (knownType == null || knownType != actualType) {
            this.writeType(actualType);
        }
    }

    public void writeObjectEnd() {
        try {
            this.writer.pop();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeArrayStart(String name) {
        try {
            this.writer.name(name);
            this.writer.array();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeArrayStart() {
        try {
            this.writer.array();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeArrayEnd() {
        try {
            this.writer.pop();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeType(Class type) {
        if (this.typeName == null) {
            return;
        }
        String className = this.getTag(type);
        if (className == null) {
            className = type.getName();
        }
        try {
            this.writer.set(this.typeName, className);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public <T> T fromJson(Class<T> type, Reader reader) {
        return this.readValue(type, null, new JsonReader().parse(reader));
    }

    public <T> T fromJson(Class<T> type, Class elementType, Reader reader) {
        return this.readValue(type, elementType, new JsonReader().parse(reader));
    }

    public <T> T fromJson(Class<T> type, InputStream input) {
        return this.readValue(type, null, new JsonReader().parse(input));
    }

    public <T> T fromJson(Class<T> type, Class elementType, InputStream input) {
        return this.readValue(type, elementType, new JsonReader().parse(input));
    }

    public <T> T fromJson(Class<T> type, Fi file) {
        try {
            return this.readValue(type, null, new JsonReader().parse(file));
        }
        catch (Exception ex) {
            throw new SerializationException("Error reading file: " + file, ex);
        }
    }

    public <T> T fromJson(Class<T> type, Class elementType, Fi file) {
        try {
            return this.readValue(type, elementType, new JsonReader().parse(file));
        }
        catch (Exception ex) {
            throw new SerializationException("Error reading file: " + file, ex);
        }
    }

    public <T> T fromJson(Class<T> type, char[] data, int offset, int length) {
        return this.readValue(type, null, new JsonReader().parse(data, offset, length));
    }

    public <T> T fromJson(Class<T> type, Class elementType, char[] data, int offset, int length) {
        return this.readValue(type, elementType, new JsonReader().parse(data, offset, length));
    }

    public <T> T fromJson(Class<T> type, String json) {
        return this.readValue(type, null, new JsonReader().parse(json));
    }

    public <T> T fromJson(Class<T> type, Class elementType, String json) {
        return this.readValue(type, elementType, new JsonReader().parse(json));
    }

    public void readField(Object object, String name, JsonValue jsonData) {
        this.readField(object, name, name, null, jsonData);
    }

    public void readField(Object object, String name, Class elementType, JsonValue jsonData) {
        this.readField(object, name, name, elementType, jsonData);
    }

    public void readField(Object object, String fieldName, String jsonName, JsonValue jsonData) {
        this.readField(object, fieldName, jsonName, null, jsonData);
    }

    public void readField(Object object, String fieldName, String jsonName, Class elementType, JsonValue jsonMap) {
        Class<?> type = object.getClass();
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        FieldMetadata metadata = (FieldMetadata)fields.get(fieldName);
        if (metadata == null) {
            throw new SerializationException("Field not found: " + fieldName + " (" + type.getName() + ")");
        }
        Field field = metadata.field;
        if (elementType == null) {
            elementType = metadata.elementType;
        }
        this.readField(object, field, jsonName, elementType, jsonMap);
    }

    public void readField(Object object, Field field, String jsonName, Class elementType, JsonValue jsonMap) {
        JsonValue jsonValue = jsonMap.get(jsonName);
        if (jsonValue == null) {
            return;
        }
        try {
            field.set(object, this.readValue(field.getType(), elementType, jsonValue));
        }
        catch (IllegalAccessException ex) {
            throw new SerializationException("Error accessing field: " + field.getName() + " (" + field.getDeclaringClass().getName() + ")", ex);
        }
        catch (SerializationException ex) {
            ex.addTrace(field.getName() + " (" + field.getDeclaringClass().getName() + ")");
            throw ex;
        }
        catch (RuntimeException runtimeEx) {
            SerializationException ex = new SerializationException(runtimeEx);
            ex.addTrace(jsonValue.trace());
            ex.addTrace(field.getName() + " (" + field.getDeclaringClass().getName() + ")");
            throw ex;
        }
    }

    public void readFields(Object object, JsonValue jsonMap) {
        Class<?> type = object.getClass();
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        JsonValue child = jsonMap.child;
        while (child != null) {
            FieldMetadata metadata = (FieldMetadata)fields.get(child.name().replace(" ", "_"));
            if (metadata == null) {
                if (!(child.name.equals(this.typeName) || this.ignoreUnknownFields || this.ignoreUnknownField(type, child.name))) {
                    SerializationException ex = new SerializationException("Field not found: " + child.name + " (" + type.getName() + ")");
                    ex.addTrace(child.trace());
                    throw ex;
                }
            } else {
                Field field = metadata.field;
                try {
                    field.set(object, this.readValue(field.getType(), metadata.elementType, child, metadata.keyType));
                }
                catch (IllegalAccessException ex) {
                    throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
                }
                catch (SerializationException ex) {
                    ex.addTrace(field.getName() + " (" + type.getName() + ")");
                    throw ex;
                }
                catch (RuntimeException runtimeEx) {
                    SerializationException ex = new SerializationException(runtimeEx);
                    ex.addTrace(child.trace());
                    ex.addTrace(field.getName() + " (" + type.getName() + ")");
                    throw ex;
                }
            }
            child = child.next;
        }
    }

    protected boolean ignoreUnknownField(Class type, String fieldName) {
        return false;
    }

    public <T> T readValue(String name, Class<T> type, JsonValue jsonMap) {
        return this.readValue(type, null, jsonMap.get(name));
    }

    public <T> T readValue(String name, Class<T> type, T defaultValue, JsonValue jsonMap) {
        JsonValue jsonValue = jsonMap.get(name);
        if (jsonValue == null) {
            return defaultValue;
        }
        return this.readValue(type, null, jsonValue);
    }

    public <T> T readValue(String name, Class<T> type, Class elementType, JsonValue jsonMap) {
        return this.readValue(type, elementType, jsonMap.get(name));
    }

    public <T> T readValue(String name, Class<T> type, Class elementType, T defaultValue, JsonValue jsonMap) {
        JsonValue jsonValue = jsonMap.get(name);
        return this.readValue(type, elementType, defaultValue, jsonValue);
    }

    public <T> T readValue(Class<T> type, Class elementType, T defaultValue, JsonValue jsonData) {
        if (jsonData == null) {
            return defaultValue;
        }
        return this.readValue(type, elementType, jsonData);
    }

    public <T> T readValue(Class<T> type, JsonValue jsonData) {
        return this.readValue(type, null, jsonData);
    }

    public <T> T readValue(Class<T> type, Class elementType, JsonValue jsonData) {
        return this.readValue(type, elementType, jsonData, (Class)null);
    }

    public <T> T readValue(Class<T> type, Class elementType, JsonValue jsonData, Class keytype) {
        if (jsonData == null) {
            return null;
        }
        if (jsonData.isObject()) {
            String className;
            String string = className = this.typeName == null ? null : jsonData.getString(this.typeName, null);
            if (className != null && (type = this.getClass(className)) == null) {
                try {
                    type = Class.forName(className);
                }
                catch (Throwable ex) {
                    throw new SerializationException(ex);
                }
            }
            if (type == null) {
                if (this.defaultSerializer != null) {
                    return this.defaultSerializer.read(this, jsonData, type);
                }
                return (T)jsonData;
            }
            if (this.typeName != null && Collection.class.isAssignableFrom(type)) {
                if ((jsonData = jsonData.get("items")) == null) {
                    throw new SerializationException("Unable to convert object to struct: " + jsonData + " (" + type.getName() + ")");
                }
            } else {
                Serializer serializer = this.classToSerializer.get(type);
                if (serializer != null) {
                    return serializer.read(this, jsonData, type);
                }
                if (type == String.class || type == Integer.class || type == Boolean.class || type == Float.class || type == Long.class || type == Double.class || type == Short.class || type == Byte.class || type == Character.class || Enum.class.isAssignableFrom(type)) {
                    return (T)this.readValue("value", type, jsonData);
                }
                Object object = this.newInstance(type);
                if (object instanceof JsonSerializable) {
                    ((JsonSerializable)object).read(this, jsonData);
                    return (T)object;
                }
                if (object instanceof ObjectMap) {
                    ObjectMap result = (ObjectMap)object;
                    JsonValue child = jsonData.child;
                    while (child != null) {
                        result.put(keytype != null ? this.readValue(keytype, null, new JsonValue(child.name)) : child.name, this.readValue(elementType, null, child));
                        child = child.next;
                    }
                    return (T)result;
                }
                if (object instanceof ObjectIntMap) {
                    ObjectIntMap result = (ObjectIntMap)object;
                    JsonValue child = jsonData.child;
                    while (child != null) {
                        result.put(elementType != null ? this.readValue(elementType, null, new JsonValue(child.name)) : child.name, child.asInt());
                        child = child.next;
                    }
                    return (T)result;
                }
                if (object instanceof ObjectSet) {
                    ObjectSet result = (ObjectSet)object;
                    JsonValue child = jsonData.getChild("values");
                    while (child != null) {
                        result.add(this.readValue(elementType, null, child));
                        child = child.next;
                    }
                    return (T)result;
                }
                if (object instanceof IntSet) {
                    IntSet result = (IntSet)object;
                    JsonValue child = jsonData.getChild("values");
                    while (child != null) {
                        result.add(child.asInt());
                        child = child.next;
                    }
                    return (T)result;
                }
                if (object instanceof ArrayMap) {
                    ArrayMap result = (ArrayMap)object;
                    JsonValue child = jsonData.child;
                    while (child != null) {
                        result.put(child.name, this.readValue(elementType, null, child));
                        child = child.next;
                    }
                    return (T)result;
                }
                if (object instanceof Map) {
                    Map result = (Map)object;
                    JsonValue child = jsonData.child;
                    while (child != null) {
                        if (!child.name.equals(this.typeName)) {
                            result.put(child.name, this.readValue(elementType, null, child));
                        }
                        child = child.next;
                    }
                    return (T)result;
                }
                this.readFields(object, jsonData);
                return (T)object;
            }
        }
        if (type != null) {
            Serializer serializer = this.classToSerializer.get(type);
            if (serializer != null) {
                return serializer.read(this, jsonData, type);
            }
            if (JsonSerializable.class.isAssignableFrom(type)) {
                Object object = this.newInstance(type);
                ((JsonSerializable)object).read(this, jsonData);
                return (T)object;
            }
        }
        if (jsonData.isArray()) {
            Iterable<Object> result;
            if (type == null || type == Object.class) {
                type = Seq.class;
            }
            if (Seq.class.isAssignableFrom(type)) {
                result = type == Seq.class ? new Seq() : (Seq)this.newInstance(type);
                JsonValue child = jsonData.child;
                while (child != null) {
                    ((Seq)result).add(this.readValue(elementType, null, child));
                    child = child.next;
                }
                return (T)result;
            }
            if (ObjectSet.class.isAssignableFrom(type)) {
                result = type == ObjectSet.class ? new ObjectSet() : (ObjectSet)this.newInstance(type);
                JsonValue child = jsonData.child;
                while (child != null) {
                    ((ObjectSet)result).add(this.readValue(elementType, null, child));
                    child = child.next;
                }
                return (T)result;
            }
            if (Queue.class.isAssignableFrom(type)) {
                result = type == Queue.class ? new Queue() : (Queue)this.newInstance(type);
                JsonValue child = jsonData.child;
                while (child != null) {
                    ((Queue)result).addLast(this.readValue(elementType, null, child));
                    child = child.next;
                }
                return (T)result;
            }
            if (Collection.class.isAssignableFrom(type)) {
                result = type.isInterface() ? new ArrayList() : (Collection)this.newInstance(type);
                JsonValue child = jsonData.child;
                while (child != null) {
                    result.add(this.readValue(elementType, null, child));
                    child = child.next;
                }
                return (T)result;
            }
            if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                if (elementType == null) {
                    elementType = componentType;
                }
                Object result2 = Array.newInstance(componentType, jsonData.size);
                int i = 0;
                JsonValue child = jsonData.child;
                while (child != null) {
                    Array.set(result2, i++, this.readValue(elementType, null, child));
                    child = child.next;
                }
                return (T)result2;
            }
            throw new SerializationException("Unable to convert value to required type: " + jsonData + " (" + type.getName() + ")");
        }
        if (jsonData.isNumber()) {
            try {
                if (type == null || type == Float.TYPE || type == Float.class) {
                    return (T)Float.valueOf(jsonData.asFloat());
                }
                if (type == Integer.TYPE || type == Integer.class) {
                    return (T)Integer.valueOf(jsonData.asInt());
                }
                if (type == Long.TYPE || type == Long.class) {
                    return (T)Long.valueOf(jsonData.asLong());
                }
                if (type == Double.TYPE || type == Double.class) {
                    return (T)Double.valueOf(jsonData.asDouble());
                }
                if (type == String.class) {
                    return (T)jsonData.asString();
                }
                if (type == Short.TYPE || type == Short.class) {
                    return (T)Short.valueOf(jsonData.asShort());
                }
                if (type == Byte.TYPE || type == Byte.class) {
                    return (T)Byte.valueOf(jsonData.asByte());
                }
            }
            catch (NumberFormatException componentType) {
                // empty catch block
            }
            jsonData = new JsonValue(jsonData.asString());
        }
        if (jsonData.isBoolean()) {
            try {
                if (type == null || type == Boolean.TYPE || type == Boolean.class) {
                    return (T)Boolean.valueOf(jsonData.asBoolean());
                }
            }
            catch (NumberFormatException componentType) {
                // empty catch block
            }
            jsonData = new JsonValue(jsonData.asString());
        }
        if (jsonData.isString()) {
            String string = jsonData.asString();
            if (type == null || type == String.class) {
                return (T)string;
            }
            try {
                if (type == Integer.TYPE || type == Integer.class) {
                    return (T)Integer.valueOf(string);
                }
                if (type == Float.TYPE || type == Float.class) {
                    return (T)(string.endsWith("f") ? Float.valueOf(string.substring(0, string.length() - 1)) : (string.endsWith("f,") ? Float.valueOf(string.substring(0, string.length() - 2)) : Float.valueOf(string)));
                }
                if (type == Long.TYPE || type == Long.class) {
                    return (T)Long.valueOf(string);
                }
                if (type == Double.TYPE || type == Double.class) {
                    return (T)Double.valueOf(string);
                }
                if (type == Short.TYPE || type == Short.class) {
                    return (T)Short.valueOf(string);
                }
                if (type == Byte.TYPE || type == Byte.class) {
                    return (T)Byte.valueOf(string);
                }
            }
            catch (NumberFormatException result2) {
                // empty catch block
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return (T)Boolean.valueOf(string);
            }
            if (type == Character.TYPE || type == Character.class) {
                return (T)Character.valueOf(string.charAt(0));
            }
            if (Enum.class.isAssignableFrom(type)) {
                for (Enum e : (Enum[])type.getEnumConstants()) {
                    if (!string.equals(this.convertToString(e))) continue;
                    return (T)e;
                }
            }
            if (type == CharSequence.class) {
                return (T)string;
            }
            throw new SerializationException("Unable to convert value to required type: " + jsonData + " (" + type.getName() + ")");
        }
        return null;
    }

    public void copyFields(Object from, Object to) {
        this.copyFields(from, to, false);
    }

    public void copyFields(Object from, Object to, boolean setFinals) {
        OrderedMap<String, FieldMetadata> toFields = this.getFields(from.getClass());
        for (ObjectMap.Entry entry : this.getFields(from.getClass())) {
            FieldMetadata toField = (FieldMetadata)toFields.get((String)entry.key);
            Field fromField = ((FieldMetadata)entry.value).field;
            if (Modifier.isFinal(fromField.getModifiers()) && !setFinals) continue;
            if (toField == null) {
                throw new SerializationException("To object is missing field" + (String)entry.key);
            }
            try {
                toField.field.set(to, fromField.get(from));
            }
            catch (IllegalAccessException ex) {
                throw new SerializationException("Error copying field: " + fromField.getName(), ex);
            }
        }
    }

    private String convertToString(Enum e) {
        return this.enumNames ? e.name() : e.toString();
    }

    protected String convertToString(Object object) {
        if (object instanceof Enum) {
            return this.convertToString((Enum)object);
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return String.valueOf(object);
    }

    protected Object newInstance(Class type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            try {
                Constructor constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (SecurityException constructor) {
            }
            catch (IllegalAccessException ignored) {
                if (Enum.class.isAssignableFrom(type)) {
                    if (type.getEnumConstants() == null) {
                        type = type.getSuperclass();
                    }
                    return type.getEnumConstants()[0];
                }
                if (type.isArray()) {
                    throw new SerializationException("Encountered JSON object when expected array of type: " + type.getName(), ex);
                }
                if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
                    throw new SerializationException("Class cannot be created (non-static member class): " + type.getName(), ex);
                }
                throw new SerializationException("Class cannot be created (missing no-arg constructor): " + type.getName(), ex);
            }
            catch (Exception privateConstructorException) {
                ex = privateConstructorException;
            }
            throw new SerializationException("Error constructing instance of class: " + type.getName(), ex);
        }
    }

    public String prettyPrint(Object object) {
        return this.prettyPrint(object, 0);
    }

    public String prettyPrint(String json) {
        return this.prettyPrint(json, 0);
    }

    public String prettyPrint(Object object, int singleLineColumns) {
        return this.prettyPrint(this.toJson(object), singleLineColumns);
    }

    public String prettyPrint(String json, int singleLineColumns) {
        return new JsonReader().parse(json).prettyPrint(this.outputType, singleLineColumns);
    }

    public String prettyPrint(Object object, JsonValue.PrettyPrintSettings settings) {
        return this.prettyPrint(this.toJson(object), settings);
    }

    public String prettyPrint(String json, JsonValue.PrettyPrintSettings settings) {
        return new JsonReader().parse(json).prettyPrint(settings);
    }

    static Class getElementType(Field field, int index) {
        Type[] actualTypes;
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType && (actualTypes = ((ParameterizedType)genericType).getActualTypeArguments()).length - 1 >= index) {
            Type componentType;
            Type actualType = actualTypes[index];
            if (actualType instanceof Class) {
                return (Class)actualType;
            }
            if (actualType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)actualType).getRawType();
            }
            if (actualType instanceof GenericArrayType && (componentType = ((GenericArrayType)actualType).getGenericComponentType()) instanceof Class) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
        }
        return null;
    }

    public static interface Serializer<T> {
        public void write(Json var1, T var2, Class var3);

        public T read(Json var1, JsonValue var2, Class var3);
    }

    public static class FieldMetadata {
        public final Field field;
        @Nullable
        public Class elementType;
        @Nullable
        public Class keyType;

        public FieldMetadata(Field field) {
            boolean isMap = ObjectMap.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType());
            this.field = field;
            this.elementType = Json.getElementType(field, isMap ? 1 : 0);
            this.keyType = isMap ? Json.getElementType(field, 0) : null;
        }
    }

    public static interface JsonSerializable {
        public void write(Json var1);

        public void read(Json var1, JsonValue var2);
    }
}

