/*
 * Decompiled with CFR 0.152.
 */
package mindustry;

import arc.ApplicationCore;
import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.assets.AssetDescriptor;
import arc.assets.AssetManager;
import arc.assets.Loadable;
import arc.assets.loaders.MusicLoader;
import arc.assets.loaders.SoundLoader;
import arc.audio.Music;
import arc.audio.Sound;
import arc.graphics.Gl;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.SortedSpriteBatch;
import arc.graphics.g2d.TextureAtlas;
import arc.math.Mathf;
import arc.util.Log;
import arc.util.OS;
import arc.util.Time;
import arc.util.async.Threads;
import mindustry.Vars;
import mindustry.ai.BaseRegistry;
import mindustry.core.ContentLoader;
import mindustry.core.Control;
import mindustry.core.FileTree;
import mindustry.core.Logic;
import mindustry.core.NetClient;
import mindustry.core.NetServer;
import mindustry.core.Platform;
import mindustry.core.Renderer;
import mindustry.core.UI;
import mindustry.ctype.Content;
import mindustry.game.EventType;
import mindustry.game.Schematics;
import mindustry.gen.Musics;
import mindustry.gen.Sounds;
import mindustry.graphics.LoadRenderer;
import mindustry.maps.Map;
import mindustry.maps.MapPreviewLoader;
import mindustry.mod.Mod;
import mindustry.mod.Mods;
import mindustry.net.Net;
import mindustry.ui.Fonts;

public abstract class ClientLauncher
extends ApplicationCore
implements Platform {
    private static final int loadingFPS = 20;
    private long lastTime;
    private long beginTime;
    private boolean finished = false;
    private LoadRenderer loader;

    @Override
    public void setup() {
        String dataDir = OS.env("MINDUSTRY_DATA_DIR");
        if (dataDir != null) {
            Core.settings.setDataDirectory(Core.files.absolute(dataDir));
        }
        Vars.checkLaunch();
        Vars.loadLogger();
        this.loader = new LoadRenderer();
        Events.fire(new EventType.ClientCreateEvent());
        Vars.loadFileLogger();
        Vars.platform = this;
        this.beginTime = Time.millis();
        Log.info("[GL] Version: @", Core.graphics.getGLVersion());
        Log.info("[GL] Max texture size: @", Gl.getInt(3379));
        Log.info("[GL] Using @ context.", Core.gl30 != null ? "OpenGL 3" : "OpenGL 2");
        Log.info("[JAVA] Version: @", System.getProperty("java.version"));
        Time.setDeltaProvider(() -> {
            float result = Core.graphics.getDeltaTime() * 60.0f;
            return Float.isNaN(result) || Float.isInfinite(result) ? 1.0f : Mathf.clamp(result, 1.0E-4f, 6.0f);
        });
        Core.batch = new SortedSpriteBatch();
        Core.assets = new AssetManager();
        Core.assets.setLoader(Texture.class, ".msav", new MapPreviewLoader());
        Vars.tree = new FileTree();
        Core.assets.setLoader(Sound.class, new SoundLoader(Vars.tree));
        Core.assets.setLoader(Music.class, new MusicLoader(Vars.tree));
        Core.assets.load("sprites/error.png", Texture.class);
        Core.atlas = TextureAtlas.blankAtlas();
        Vars.net = new Net(Vars.platform.getNet());
        Vars.mods = new Mods();
        Vars.schematics = new Schematics();
        Fonts.loadSystemCursors();
        Core.assets.load(new Vars());
        Fonts.loadDefaultFont();
        Core.assets.load(new AssetDescriptor<TextureAtlas>((String)(Gl.getInt((int)3379) >= 4096 ? "sprites/sprites.atlas" : "sprites/fallback/sprites.atlas"), TextureAtlas.class)).loaded = t -> {
            Core.atlas = (TextureAtlas)t;
            Fonts.mergeFontAtlas(Core.atlas);
        };
        Core.assets.loadRun("maps", Map.class, () -> Vars.maps.loadPreviews());
        Musics.load();
        Sounds.load();
        Core.assets.loadRun("contentcreate", Content.class, () -> {
            Vars.content.createBaseContent();
            Vars.content.loadColors();
        }, () -> {
            Vars.mods.loadScripts();
            Vars.content.createModContent();
        });
        Vars.logic = new Logic();
        this.add(Vars.logic);
        Vars.control = new Control();
        this.add(Vars.control);
        Vars.renderer = new Renderer();
        this.add(Vars.renderer);
        Vars.ui = new UI();
        this.add(Vars.ui);
        Vars.netServer = new NetServer();
        this.add(Vars.netServer);
        Vars.netClient = new NetClient();
        this.add(Vars.netClient);
        Core.assets.load(Vars.mods);
        Core.assets.load(Vars.schematics);
        Core.assets.loadRun("contentinit", ContentLoader.class, () -> Vars.content.init(), () -> Vars.content.load());
        Core.assets.loadRun("baseparts", BaseRegistry.class, () -> {}, () -> Vars.bases.load());
    }

    @Override
    public void add(ApplicationListener module) {
        Loadable l;
        super.add(module);
        ApplicationListener applicationListener = module;
        if (applicationListener instanceof Loadable && (l = (Loadable)((Object)applicationListener)) == (Loadable)((Object)applicationListener)) {
            Core.assets.load(l);
        }
    }

    @Override
    public void resize(int width, int height) {
        if (Core.assets == null) {
            return;
        }
        if (!this.finished) {
            Draw.proj().setOrtho(0.0f, 0.0f, width, height);
        } else {
            super.resize(width, height);
        }
    }

    @Override
    public void update() {
        int targetfps;
        if (!this.finished) {
            if (this.loader != null) {
                this.loader.draw();
            }
            if (Core.assets.update(50)) {
                this.loader.dispose();
                this.loader = null;
                Log.info("Total time to load: @ms", Time.timeSinceMillis(this.beginTime));
                for (ApplicationListener listener : this.modules) {
                    listener.init();
                }
                Vars.mods.eachClass(Mod::init);
                this.finished = true;
                Events.fire(new EventType.ClientLoadEvent());
                super.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> {
                    super.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                    Vars.finishLaunch();
                }))));
            }
        } else {
            Vars.asyncCore.begin();
            super.update();
            Vars.asyncCore.end();
        }
        if ((targetfps = Core.settings.getInt("fpscap", 120)) > 0 && targetfps <= 240) {
            long target = 1000000000 / targetfps;
            long elapsed = Time.timeSinceNanos(this.lastTime);
            if (elapsed < target) {
                Threads.sleep((target - elapsed) / 1000000L, (int)((target - elapsed) % 1000000L));
            }
        }
        this.lastTime = Time.nanos();
    }

    @Override
    public void exit() {
        Vars.finishLaunch();
    }

    @Override
    public void init() {
        this.setup();
    }

    @Override
    public void resume() {
        if (this.finished) {
            super.resume();
        }
    }

    @Override
    public void pause() {
        if (Vars.mobile) {
            Vars.finishLaunch();
        }
        if (this.finished) {
            super.pause();
        }
    }
}

