/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.func.Boolf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.GridBits;
import arc.struct.IntFloatMap;
import arc.struct.PQueue;
import arc.struct.Seq;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.world.Tile;
import mindustry.world.Tiles;

public class Astar {
    public static final DistanceHeuristic manhattan = (x1, y1, x2, y2) -> Math.abs(x1 - x2) + Math.abs(y1 - y2);
    private static final Seq<Tile> out = new Seq();
    private static final PQueue<Tile> queue = new PQueue(10000, (a, b) -> 0);
    private static final IntFloatMap costs = new IntFloatMap();
    private static byte[][] rotations;

    public static Seq<Tile> pathfind(Tile from, Tile to, TileHueristic th, Boolf<Tile> passable) {
        return Astar.pathfind(from.x, from.y, to.x, to.y, th, manhattan, passable);
    }

    public static Seq<Tile> pathfind(int startX, int startY, int endX, int endY, TileHueristic th, Boolf<Tile> passable) {
        return Astar.pathfind(startX, startY, endX, endY, th, manhattan, passable);
    }

    public static Seq<Tile> pathfind(int startX, int startY, int endX, int endY, TileHueristic th, DistanceHeuristic dh, Boolf<Tile> passable) {
        Tiles tiles = Vars.world.tiles;
        Tile start = tiles.getn(startX, startY);
        Tile end = tiles.getn(endX, endY);
        GridBits closed = new GridBits(tiles.width, tiles.height);
        costs.clear();
        queue.clear();
        Astar.queue.comparator = Structs.comparingFloat(a -> costs.get(a.pos(), 0.0f) + dh.cost(a.x, a.y, end.x, end.y));
        queue.add(start);
        if (rotations == null || rotations.length != Vars.world.width() || rotations[0].length != Vars.world.height()) {
            rotations = new byte[Vars.world.width()][Vars.world.height()];
        }
        boolean found = false;
        while (!queue.empty()) {
            Tile next = queue.poll();
            float baseCost = costs.get(next.pos(), 0.0f);
            if (next == end) {
                found = true;
                break;
            }
            closed.set(next.x, next.y);
            for (Point2 point : Geometry.d4) {
                Tile child;
                int newx = next.x + point.x;
                int newy = next.y + point.y;
                if (!Structs.inBounds(newx, newy, tiles.width, tiles.height) || !passable.get(child = tiles.getn(newx, newy))) continue;
                float newCost = th.cost(next, child) + baseCost;
                if (closed.get(child.x, child.y)) continue;
                closed.set(child.x, child.y);
                Astar.rotations[child.x][child.y] = child.relativeTo(next.x, next.y);
                costs.put(child.pos(), newCost);
                queue.add(child);
            }
        }
        out.clear();
        if (!found) {
            return out;
        }
        Tile current = end;
        while (current != start) {
            out.add(current);
            byte rot = rotations[current.x][current.y];
            current = tiles.getn(current.x + Geometry.d4x[rot], current.y + Geometry.d4y[rot]);
        }
        out.reverse();
        return out;
    }

    public static interface DistanceHeuristic {
        public float cost(int var1, int var2, int var3, int var4);
    }

    public static interface TileHueristic {
        public float cost(Tile var1);

        default public float cost(Tile from, Tile tile) {
            return this.cost(tile);
        }
    }
}

