/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.func.Boolf;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.BaseRegistry;
import mindustry.ai.Pathfinder;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.game.Schematic;
import mindustry.game.Schematics;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.blocks.distribution.PayloadConveyor;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.production.PayloadAcceptor;
import mindustry.world.blocks.storage.CoreBlock;

public class BaseAI {
    private static final Vec2 axis = new Vec2();
    private static final Vec2 rotator = new Vec2();
    private static final float correctPercent = 0.5f;
    private static final int attempts = 4;
    private static final float emptyChance = 0.01f;
    private static final int timerStep = 0;
    private static final int timerSpawn = 1;
    private static final int timerRefreshPath = 2;
    private static final int pathStep = 50;
    private static final Seq<Tile> tmpTiles = new Seq();
    private static int correct = 0;
    private static int incorrect = 0;
    private int lastX;
    private int lastY;
    private int lastW;
    private int lastH;
    private boolean triedWalls;
    private boolean foundPath;
    Teams.TeamData data;
    Interval timer = new Interval(4);
    IntSet path = new IntSet();
    IntSet calcPath = new IntSet();
    @Nullable
    Tile calcTile;
    boolean calculating;
    boolean startedCalculating;
    int calcCount = 0;
    int totalCalcs = 0;

    public BaseAI(Teams.TeamData data) {
        this.data = data;
    }

    public void update() {
        if (this.data.team.rules().aiCoreSpawn && this.timer.get(1, 150.0f) && this.data.hasCore()) {
            CoreBlock block = (CoreBlock)this.data.core().block;
            int coreUnits = Groups.unit.count(u -> u.team == this.data.team && u.type == block.unitType);
            if (!Vars.state.isEditor() && coreUnits < this.data.cores.size) {
                Unit unit = block.unitType.create(this.data.team);
                unit.set(this.data.cores.random());
                unit.add();
                Fx.spawn.at(unit);
            }
        }
        if (!this.calculating && (this.timer.get(2, 10800.0f) || !this.startedCalculating) && this.data.hasCore()) {
            this.calculating = true;
            this.startedCalculating = true;
            this.calcPath.clear();
        }
        if (this.calculating && this.calcCount >= Vars.world.width() * Vars.world.height()) {
            this.calculating = false;
            this.calcCount = 0;
            this.calcPath.clear();
            ++this.totalCalcs;
        }
        if (this.calculating) {
            if (this.calcTile == null) {
                Vars.spawner.eachGroundSpawn((x, y) -> {
                    this.calcTile = Vars.world.tile(x, y);
                });
                if (this.calcTile == null) {
                    this.calculating = false;
                }
            } else {
                Pathfinder.Flowfield field = Vars.pathfinder.getField(Vars.state.rules.waveTeam, 0, 0);
                int[][] weights = field.weights;
                for (int i = 0; i < 50; ++i) {
                    CoreBlock.CoreBuild b;
                    int minCost = Integer.MAX_VALUE;
                    short cx = this.calcTile.x;
                    short cy = this.calcTile.y;
                    boolean foundAny = false;
                    for (Point2 p : Geometry.d4) {
                        int nx = cx + p.x;
                        int ny = cy + p.y;
                        Tile other = Vars.world.tile(nx, ny);
                        if (other == null || weights[nx][ny] >= minCost || weights[nx][ny] == -1) continue;
                        minCost = weights[nx][ny];
                        this.calcTile = other;
                        foundAny = true;
                    }
                    if (!foundAny) {
                        this.calcCount = Integer.MAX_VALUE;
                        break;
                    }
                    this.calcPath.add(this.calcTile.pos());
                    for (Point2 p : Geometry.d8) {
                        this.calcPath.add(Point2.pack(p.x + this.calcTile.x, p.y + this.calcTile.y));
                    }
                    Building building = this.calcTile.build;
                    if (building instanceof CoreBlock.CoreBuild && (b = (CoreBlock.CoreBuild)building) == (CoreBlock.CoreBuild)building && b.team == Vars.state.rules.defaultTeam) {
                        this.calculating = false;
                        this.calcCount = 0;
                        this.path.clear();
                        this.path.addAll(this.calcPath);
                        this.calcPath.clear();
                        this.calcTile = null;
                        ++this.totalCalcs;
                        this.foundPath = true;
                        break;
                    }
                    ++this.calcCount;
                }
            }
        }
        if (this.foundPath && this.data.blocks.isEmpty() && this.timer.get(0, Mathf.lerp(20.0f, 4.0f, this.data.team.rules().aiTier))) {
            if (!this.triedWalls) {
                this.tryWalls();
                this.triedWalls = true;
            }
            for (int i = 0; i < 4; ++i) {
                BaseRegistry.BasePart part;
                int range = 150;
                Position pos = this.randomPosition();
                if (pos == null) {
                    return;
                }
                Tmp.v1.rnd(Mathf.random(range));
                int wx = (int)((float)World.toTile(pos.getX()) + Tmp.v1.x);
                int wy = (int)((float)World.toTile(pos.getY()) + Tmp.v1.y);
                Tile tile = Vars.world.tiles.getc(wx, wy);
                if (Vars.spawner.getSpawns().contains((Tile)((Object)((Boolf<Tile>)t -> t.within(tile, 320.0f))))) continue;
                Seq<BaseRegistry.BasePart> parts = null;
                if (tile.drop() != null && Vars.bases.forResource(tile.drop()).any()) {
                    parts = Vars.bases.forResource(tile.drop());
                } else if (Mathf.chance(0.01f)) {
                    parts = Vars.bases.parts;
                }
                if (parts != null && this.tryPlace(part = parts.random(), tile.x, tile.y)) break;
            }
        }
    }

    private Position randomPosition() {
        if (this.data.hasCore()) {
            return this.data.cores.random();
        }
        if (this.data.team == Vars.state.rules.waveTeam) {
            return Vars.spawner.getSpawns().random();
        }
        return null;
    }

    private boolean tryPlace(BaseRegistry.BasePart part, int x, int y) {
        int rotation = Mathf.range(2);
        axis.set((int)((float)part.schematic.width / 2.0f), (int)((float)part.schematic.height / 2.0f));
        Schematic result = Schematics.rotate(part.schematic, rotation);
        int rotdeg = rotation * 90;
        rotator.set(part.centerX, part.centerY).rotateAround(axis, rotdeg);
        int cx = x - (int)BaseAI.rotator.x;
        int cy = y - (int)BaseAI.rotator.y;
        for (Schematic.Stile tile : result.tiles) {
            int realX = tile.x + cx;
            int realY = tile.y + cy;
            if (!Build.validPlace(tile.block, this.data.team, realX, realY, tile.rotation)) {
                return false;
            }
            Tile wtile = Vars.world.tile(realX, realY);
            if (tile.block instanceof PayloadConveyor || tile.block instanceof PayloadAcceptor) {
                for (Point2 point : Edges.getEdges(tile.block.size)) {
                    Building t2 = Vars.world.build(tile.x + point.x, tile.y + point.y);
                    if (t2 == null) continue;
                    return false;
                }
            }
            tmpTiles.clear();
            if (!tile.block.solid || wtile == null || !wtile.getLinkedTilesAs(tile.block, tmpTiles).contains((Tile)((Object)((Boolf<Tile>)t -> this.path.contains(t.pos()))))) continue;
            return false;
        }
        incorrect = 0;
        correct = 0;
        boolean anyDrills = false;
        if (part.required instanceof Item) {
            for (Schematic.Stile tile : result.tiles) {
                if (!(tile.block instanceof Drill)) continue;
                anyDrills = true;
                tile.block.iterateTaken(tile.x + cx, tile.y + cy, (ex, ey) -> {
                    Tile res = Vars.world.rawTile(ex, ey);
                    if (res.drop() == part.required) {
                        ++correct;
                    } else if (res.drop() != null) {
                        ++incorrect;
                    }
                });
            }
        }
        if (anyDrills && (incorrect != 0 || correct == 0)) {
            return false;
        }
        for (Schematic.Stile tile : result.tiles) {
            this.data.blocks.add(new Teams.BlockPlan(cx + tile.x, cy + tile.y, tile.rotation, tile.block.id, tile.config));
        }
        this.lastX = cx - 1;
        this.lastY = cy - 1;
        this.lastW = result.width + 2;
        this.lastH = result.height + 2;
        this.triedWalls = false;
        return true;
    }

    private void tryWalls() {
        Tile spawn;
        Block wall = Blocks.copperWall;
        CoreBlock.CoreBuild spawnt = Vars.state.rules.defaultTeam.core() != null ? Vars.state.rules.defaultTeam.core() : this.data.team.core();
        Tile tile = spawn = spawnt == null ? null : spawnt.tile;
        if (spawn == null) {
            return;
        }
        for (int wx = this.lastX; wx <= this.lastX + this.lastW; ++wx) {
            block1: for (int wy = this.lastY; wy <= this.lastY + this.lastH; ++wy) {
                Tile tile2 = Vars.world.tile(wx, wy);
                if (tile2 == null || !tile2.block().alwaysReplace) continue;
                boolean any = false;
                for (Point2 p : Geometry.d8) {
                    if (Angles.angleDist(Angles.angle(p.x, p.y), spawn.angleTo(tile2)) > 70.0f) continue;
                    Tile o = Vars.world.tile(tile2.x + p.x, tile2.y + p.y);
                    if (o != null && (o.block() instanceof PayloadAcceptor || o.block() instanceof PayloadConveyor)) continue block1;
                    if (o == null || o.team() != this.data.team || o.block() instanceof Wall) continue;
                    any = true;
                }
                tmpTiles.clear();
                if (!any || !Build.validPlace(wall, this.data.team, tile2.x, tile2.y, 0) || tile2.getLinkedTilesAs(wall, tmpTiles).contains((Tile)((Object)((Boolf<Tile>)t -> this.path.contains(t.pos()))))) continue;
                this.data.blocks.add(new Teams.BlockPlan(tile2.x, tile2.y, 0, wall.id, null));
            }
        }
    }
}

