/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.struct.EnumSet;
import arc.struct.GridBits;
import arc.struct.IntMap;
import arc.struct.IntSet;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.meta.BlockFlag;

public class BlockIndexer {
    private static final int quadrantSize = 16;
    private final ObjectSet<Item> scanOres = new ObjectSet();
    private final IntSet intSet = new IntSet();
    private final ObjectSet<Item> itemSet = new ObjectSet();
    private ObjectMap<Item, TileArray> ores = new ObjectMap();
    private GridBits[] structQuadrants;
    private ObjectSet<Building>[] damagedTiles = new ObjectSet[Team.all.length];
    private ObjectSet<Item> allOres = new ObjectSet();
    private Seq<Team> activeTeams = new Seq(Team.class);
    private TileArray[][] flagMap = new TileArray[Team.all.length][BlockFlag.all.length];
    private int[] unitCaps = new int[Team.all.length];
    private IntMap<TileIndex> typeMap = new IntMap();
    private TileArray emptySet = new TileArray();
    private Seq<Tile> returnArray = new Seq();
    private Seq<Building> breturnArray = new Seq();

    public BlockIndexer() {
        Events.on(EventType.TileChangeEvent.class, event -> this.updateIndices(event.tile));
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.scanOres.clear();
            this.scanOres.addAll(Item.getAllOres());
            this.damagedTiles = new ObjectSet[Team.all.length];
            this.flagMap = new TileArray[Team.all.length][BlockFlag.all.length];
            this.unitCaps = new int[Team.all.length];
            this.activeTeams = new Seq(Team.class);
            for (int i = 0; i < this.flagMap.length; ++i) {
                for (int j = 0; j < BlockFlag.all.length; ++j) {
                    this.flagMap[i][j] = new TileArray();
                }
            }
            this.typeMap.clear();
            this.allOres.clear();
            this.ores = null;
            this.structQuadrants = new GridBits[Team.all.length];
            for (Tile tile : Vars.world.tiles) {
                this.process(tile);
                if (tile.build != null && tile.build.damaged()) {
                    this.notifyTileDamaged(tile.build);
                }
                if (tile.drop() == null) continue;
                this.allOres.add(tile.drop());
            }
            for (int x = 0; x < this.quadWidth(); ++x) {
                for (int y = 0; y < this.quadHeight(); ++y) {
                    this.updateQuadrant(Vars.world.tile(x * 16, y * 16));
                }
            }
            this.scanOres();
        });
    }

    public void updateIndices(Tile tile) {
        if (this.typeMap.get(tile.pos()) != null) {
            TileIndex index = this.typeMap.get(tile.pos());
            for (BlockFlag flag : index.flags) {
                this.getFlagged(index.team)[flag.ordinal()].remove(tile);
            }
            if (index.flags.contains(BlockFlag.unitModifier)) {
                this.updateCap(index.team);
            }
        }
        this.process(tile);
        this.updateQuadrant(tile);
    }

    private TileArray[] getFlagged(Team team) {
        return this.flagMap[team.id];
    }

    private GridBits structQuadrant(Team t) {
        if (this.structQuadrants[t.id] == null) {
            this.structQuadrants[t.id] = new GridBits(Mathf.ceil((float)Vars.world.width() / 16.0f), Mathf.ceil((float)Vars.world.height() / 16.0f));
        }
        return this.structQuadrants[t.id];
    }

    public void updateTeamIndex(Team team) {
        if (this.structQuadrants == null) {
            return;
        }
        for (Tile tile : Vars.world.tiles) {
            if (tile.team() != team) continue;
            int quadrantX = tile.x / 16;
            int quadrantY = tile.y / 16;
            this.structQuadrant(team).set(quadrantX, quadrantY);
        }
    }

    public boolean hasOre(Item item) {
        return this.allOres.contains(item);
    }

    public ObjectSet<Building> getDamaged(Team team) {
        this.breturnArray.clear();
        if (this.damagedTiles[team.id] == null) {
            this.damagedTiles[team.id] = new ObjectSet();
        }
        ObjectSet<Building> set = this.damagedTiles[team.id];
        for (Building build : set) {
            if (build.isValid() && build.team == team && build.damaged() && !(build.block instanceof ConstructBlock)) continue;
            this.breturnArray.add(build);
        }
        for (Building tile : this.breturnArray) {
            set.remove(tile);
        }
        return set;
    }

    public TileArray getAllied(Team team, BlockFlag type) {
        return this.flagMap[team.id][type.ordinal()];
    }

    @Nullable
    public Tile findClosestFlag(float x, float y, Team team, BlockFlag flag) {
        return Geometry.findClosest(x, y, this.getAllied(team, flag));
    }

    public boolean eachBlock(Teamc team, float range, Boolf<Building> pred, Cons<Building> cons) {
        return this.eachBlock(team.team(), team.getX(), team.getY(), range, pred, cons);
    }

    public boolean eachBlock(Team team, float wx, float wy, float range, Boolf<Building> pred, Cons<Building> cons) {
        this.intSet.clear();
        int tx = World.toTile(wx);
        int ty = World.toTile(wy);
        int tileRange = (int)(range / 8.0f + 1.0f);
        boolean any = false;
        for (int x = -tileRange + tx; x <= tileRange + tx; ++x) {
            for (int y = -tileRange + ty; y <= tileRange + ty; ++y) {
                Building other;
                if (!Mathf.within(x * 8, y * 8, wx, wy, range) || (other = Vars.world.build(x, y)) == null || team != null && other.team != team || !pred.get(other) || !this.intSet.add(other.pos())) continue;
                cons.get(other);
                any = true;
            }
        }
        return any;
    }

    public Seq<Tile> getEnemy(Team team, BlockFlag type) {
        this.returnArray.clear();
        Seq<Teams.TeamData> data = Vars.state.teams.present;
        if (data.isEmpty()) {
            for (Team enemy : Team.all) {
                TileArray set;
                if (enemy == team || (set = this.getFlagged(enemy)[type.ordinal()]) == null) continue;
                for (Tile tile : set) {
                    this.returnArray.add(tile);
                }
            }
        } else {
            for (int i = 0; i < data.size; ++i) {
                TileArray set;
                Team enemy = ((Teams.TeamData[])data.items)[i].team;
                if (enemy == team || (set = this.getFlagged(enemy)[type.ordinal()]) == null) continue;
                for (Tile tile : set) {
                    this.returnArray.add(tile);
                }
            }
        }
        return this.returnArray;
    }

    public void notifyTileDamaged(Building entity) {
        if (this.damagedTiles[entity.team.id] == null) {
            this.damagedTiles[entity.team.id] = new ObjectSet();
        }
        this.damagedTiles[entity.team.id].add(entity);
    }

    public Building findEnemyTile(Team team, float x, float y, float range, Boolf<Building> pred) {
        for (int i = 0; i < this.activeTeams.size; ++i) {
            Building entity;
            Team enemy = ((Team[])this.activeTeams.items)[i];
            if (enemy == team || team == Team.derelict || (entity = Vars.indexer.findTile(enemy, x, y, range, pred, true)) == null) continue;
            return entity;
        }
        return null;
    }

    public Building findTile(Team team, float x, float y, float range, Boolf<Building> pred) {
        return this.findTile(team, x, y, range, pred, false);
    }

    public Building findTile(Team team, float x, float y, float range, Boolf<Building> pred, boolean usePriority) {
        Building closest = null;
        float dst = 0.0f;
        for (int rx = Math.max((int)((x - range) / 8.0f / 16.0f), 0); rx <= (int)((x + range) / 8.0f / 16.0f) && rx < this.quadWidth(); ++rx) {
            for (int ry = Math.max((int)((y - range) / 8.0f / 16.0f), 0); ry <= (int)((y + range) / 8.0f / 16.0f) && ry < this.quadHeight(); ++ry) {
                if (!this.getQuad(team, rx, ry)) continue;
                for (int tx = rx * 16; tx < (rx + 1) * 16 && tx < Vars.world.width(); ++tx) {
                    for (int ty = ry * 16; ty < (ry + 1) * 16 && ty < Vars.world.height(); ++ty) {
                        float bdst;
                        Building e = Vars.world.build(tx, ty);
                        if (e == null || e.team != team || !pred.get(e) || !e.block.targetable || e.team == Team.derelict || !((bdst = e.dst(x, y) - e.hitSize() / 2.0f) < range) || closest != null && (!(bdst < dst) || usePriority && closest.block.priority.ordinal() > e.block.priority.ordinal()) && (!usePriority || closest.block.priority.ordinal() >= e.block.priority.ordinal())) continue;
                        dst = bdst;
                        closest = e;
                    }
                }
            }
        }
        return closest;
    }

    public TileArray getOrePositions(Item item) {
        return this.ores.get(item, this.emptySet);
    }

    public Tile findClosestOre(float xp, float yp, Item item) {
        Tile tile = Geometry.findClosest(xp, yp, this.getOrePositions(item));
        if (tile == null) {
            return null;
        }
        for (int x = Math.max(0, tile.x - 8); x < tile.x + 8 && x < Vars.world.width(); ++x) {
            for (int y = Math.max(0, tile.y - 8); y < tile.y + 8 && y < Vars.world.height(); ++y) {
                Tile res = Vars.world.tile(x, y);
                if (res.block() != Blocks.air || res.drop() != item) continue;
                return res;
            }
        }
        return null;
    }

    public Tile findClosestOre(Unit unit, Item item) {
        return this.findClosestOre(unit.x, unit.y, item);
    }

    public int getExtraUnits(Team team) {
        return this.unitCaps[team.id];
    }

    private void updateCap(Team team) {
        TileArray capped = this.getFlagged(team)[BlockFlag.unitModifier.ordinal()];
        this.unitCaps[team.id] = 0;
        for (Tile capper : capped) {
            int n = team.id;
            this.unitCaps[n] = this.unitCaps[n] + capper.block().unitCapModifier;
        }
    }

    private void process(Tile tile) {
        if (tile.block().flags.size() > 0 && tile.team() != Team.derelict && tile.isCenter()) {
            TileArray[] map = this.getFlagged(tile.team());
            for (BlockFlag flag : tile.block().flags) {
                TileArray arr = map[flag.ordinal()];
                arr.add(tile);
                map[flag.ordinal()] = arr;
            }
            if (tile.block().flags.contains(BlockFlag.unitModifier)) {
                this.updateCap(tile.team());
            }
            this.typeMap.put(tile.pos(), new TileIndex(tile.block().flags, tile.team()));
        }
        if (!this.activeTeams.contains(tile.team())) {
            this.activeTeams.add(tile.team());
        }
        if (this.ores == null) {
            return;
        }
        int quadrantX = tile.x / 16;
        int quadrantY = tile.y / 16;
        this.itemSet.clear();
        Tile rounded = Vars.world.rawTile(Mathf.clamp(quadrantX * 16 + 8, 0, Vars.world.width() - 1), Mathf.clamp(quadrantY * 16 + 8, 0, Vars.world.height() - 1));
        for (int x = Math.max(0, rounded.x - 8); x < rounded.x + 8 && x < Vars.world.width(); ++x) {
            for (int y = Math.max(0, rounded.y - 8); y < rounded.y + 8 && y < Vars.world.height(); ++y) {
                Tile result = Vars.world.tile(x, y);
                if (result == null || result.drop() == null || !this.scanOres.contains(result.drop()) || result.block() != Blocks.air) continue;
                this.itemSet.add(result.drop());
            }
        }
        for (Item item : this.scanOres) {
            TileArray set = this.ores.get(item);
            if (!this.itemSet.contains(item)) {
                set.remove(rounded);
                continue;
            }
            set.add(rounded);
        }
    }

    private void updateQuadrant(Tile tile) {
        if (this.structQuadrants == null) {
            return;
        }
        int quadrantX = tile.x / 16;
        int quadrantY = tile.y / 16;
        block0: for (Team team : this.activeTeams) {
            GridBits bits = this.structQuadrant(team);
            if (tile.team() == team && tile.build != null && tile.block().targetable) {
                bits.set(quadrantX, quadrantY);
                continue;
            }
            bits.set(quadrantX, quadrantY, false);
            for (int x = quadrantX * 16; x < Vars.world.width() && x < (quadrantX + 1) * 16; ++x) {
                for (int y = quadrantY * 16; y < Vars.world.height() && y < (quadrantY + 1) * 16; ++y) {
                    Building result = Vars.world.build(x, y);
                    if (result == null || result.team != team) continue;
                    bits.set(quadrantX, quadrantY);
                    continue block0;
                }
            }
        }
    }

    private boolean getQuad(Team team, int quadrantX, int quadrantY) {
        return this.structQuadrant(team).get(quadrantX, quadrantY);
    }

    private int quadWidth() {
        return Mathf.ceil((float)Vars.world.width() / 16.0f);
    }

    private int quadHeight() {
        return Mathf.ceil((float)Vars.world.height() / 16.0f);
    }

    private void scanOres() {
        this.ores = new ObjectMap();
        for (Item item : this.scanOres) {
            this.ores.put(item, new TileArray());
        }
        for (Tile tile : Vars.world.tiles) {
            int qx = tile.x / 16;
            int qy = tile.y / 16;
            if (tile.drop() == null || !this.scanOres.contains(tile.drop()) || tile.block() != Blocks.air) continue;
            this.ores.get(tile.drop()).add(Vars.world.tile(Mathf.clamp(qx * 16 + 8, 0, Vars.world.width() - 1), Mathf.clamp(qy * 16 + 8, 0, Vars.world.height() - 1)));
        }
    }

    public static class TileArray
    implements Iterable<Tile> {
        Seq<Tile> tiles = new Seq(false, 16);
        IntSet contained = new IntSet();

        public void add(Tile tile) {
            if (this.contained.add(tile.pos())) {
                this.tiles.add(tile);
            }
        }

        public void remove(Tile tile) {
            if (this.contained.remove(tile.pos())) {
                this.tiles.remove(tile);
            }
        }

        public int size() {
            return this.tiles.size;
        }

        public Tile first() {
            return this.tiles.first();
        }

        @Override
        public Iterator<Tile> iterator() {
            return this.tiles.iterator();
        }
    }

    private static class TileIndex {
        public final EnumSet<BlockFlag> flags;
        public final Team team;

        public TileIndex(EnumSet<BlockFlag> flags, Team team) {
            this.flags = flags;
            this.team = team;
        }
    }
}

