/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Prov;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.struct.IntQueue;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.TaskQueue;
import arc.util.Time;
import arc.util.async.Threads;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.PathTile;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BlockFlag;

public class Pathfinder
implements Runnable {
    private static final long maxUpdate = Time.millisToNanos(7L);
    private static final int updateFPS = 60;
    private static final int updateInterval = 16;
    private static final int impassable = -1;
    public static final int fieldCore = 0;
    public static final int fieldRally = 1;
    public static final Seq<Prov<Flowfield>> fieldTypes = Seq.with(EnemyCoreField::new, RallyField::new);
    public static final int costGround = 0;
    public static final int costLegs = 1;
    public static final int costNaval = 2;
    public static final Seq<PathCost> costTypes = Seq.with((team, tile) -> (PathTile.team(tile) == team.id || PathTile.team(tile) == 0) && PathTile.solid(tile) ? -1 : 1 + PathTile.health(tile) * 5 + (PathTile.nearSolid(tile) ? 2 : 0) + (PathTile.nearLiquid(tile) ? 6 : 0) + (PathTile.deep(tile) ? 6000 : 0) + (PathTile.damages(tile) ? 30 : 0), (team, tile) -> PathTile.legSolid(tile) ? -1 : 1 + (PathTile.solid(tile) ? 5 : 0), (team, tile) -> PathTile.solid(tile) || !PathTile.liquid(tile) ? 200 : 2 + (PathTile.nearGround(tile) || PathTile.nearSolid(tile) ? 14 : 0) + (PathTile.deep(tile) ? -1 : 0) + (PathTile.damages(tile) ? 35 : 0));
    Flowfield[][][] cache;
    int[][] tiles = new int[0][0];
    Seq<Flowfield> threadList = new Seq();
    Seq<Flowfield> mainList = new Seq();
    TaskQueue queue = new TaskQueue();
    @Nullable
    Thread thread;
    IntSeq tmpArray = new IntSeq();

    public Pathfinder() {
        this.clearCache();
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.stop();
            this.tiles = new int[Vars.world.width()][Vars.world.height()];
            this.threadList = new Seq();
            this.mainList = new Seq();
            this.clearCache();
            for (Tile tile : Vars.world.tiles) {
                this.tiles[tile.x][tile.y] = this.packTile(tile);
            }
            this.preloadPath(this.getField(Vars.state.rules.waveTeam, 0, 0));
            if (Vars.spawner.getSpawns().contains((Tile)((Object)((Boolf<Tile>)t -> t.floor().isLiquid)))) {
                this.preloadPath(this.getField(Vars.state.rules.waveTeam, 2, 0));
            }
            this.start();
        });
        Events.on(EventType.ResetEvent.class, event -> this.stop());
        Events.on(EventType.TileChangeEvent.class, event -> this.updateTile(event.tile));
    }

    private void clearCache() {
        this.cache = new Flowfield[256][5][5];
    }

    private int packTile(Tile tile) {
        boolean nearLiquid = false;
        boolean nearSolid = false;
        boolean nearGround = false;
        boolean solid = tile.solid();
        for (int i = 0; i < 4; ++i) {
            Tile other = tile.nearby(i);
            if (other == null) continue;
            if (other.floor().isLiquid) {
                nearLiquid = true;
            }
            if (other.solid()) {
                nearSolid = true;
            }
            if (other.floor().isLiquid) continue;
            nearGround = true;
        }
        return PathTile.get(tile.build == null || !solid || tile.block() instanceof CoreBlock ? 0 : Math.min((int)(tile.build.health / 40.0f), 80), tile.getTeamID(), solid, tile.floor().isLiquid, tile.staticDarkness() >= 2 || tile.floor().solid && tile.block() == Blocks.air, nearLiquid, nearGround, nearSolid, tile.floor().isDeep(), tile.floor().damageTaken > 1.0E-5f);
    }

    private void start() {
        this.stop();
        this.thread = Threads.daemon(this);
    }

    private void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.queue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTile(Tile tile) {
        if (Vars.net.client()) {
            return;
        }
        short x = tile.x;
        short y = tile.y;
        tile.getLinkedTiles(t -> {
            if (Structs.inBounds((int)t.x, (int)t.y, this.tiles)) {
                this.tiles[t.x][t.y] = this.packTile((Tile)t);
            }
        });
        for (Flowfield path : this.mainList) {
            if (path == null) continue;
            IntSeq intSeq = path.targets;
            synchronized (intSeq) {
                path.targets.clear();
                path.getPositions(path.targets);
            }
        }
        this.queue.post(() -> {
            for (Flowfield data : this.threadList) {
                this.updateTargets(data, x, y);
            }
        });
    }

    @Override
    public void run() {
        while (!Vars.net.client()) {
            try {
                if (Vars.state.isPlaying()) {
                    this.queue.run();
                    for (Flowfield data : this.threadList) {
                        this.updateFrontier(data, maxUpdate / (long)this.threadList.size);
                    }
                }
                try {
                    Thread.sleep(16L);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    public Flowfield getField(Team team, int costType, int fieldType) {
        if (this.cache[team.id][costType][fieldType] == null) {
            Flowfield field = fieldTypes.get(fieldType).get();
            field.team = team;
            field.cost = costTypes.get(costType);
            field.targets.clear();
            field.getPositions(field.targets);
            this.cache[team.id][costType][fieldType] = field;
            this.queue.post(() -> this.registerPath(field));
        }
        return this.cache[team.id][costType][fieldType];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Tile getTargetTile(Tile tile, Flowfield path) {
        if (tile == null) {
            return null;
        }
        if (!path.initialized) {
            return tile;
        }
        if (path.refreshRate > 0 && Time.timeSinceMillis(path.lastUpdateTime) > (long)path.refreshRate) {
            path.lastUpdateTime = Time.millis();
            this.tmpArray.clear();
            path.getPositions(this.tmpArray);
            IntSeq intSeq = path.targets;
            synchronized (intSeq) {
                if (path.targets.size != 1 || this.tmpArray.size != 1 || path.targets.first() != this.tmpArray.first()) {
                    path.targets.clear();
                    path.getPositions(path.targets);
                    this.queue.post(() -> this.updateTargets(path));
                }
            }
        }
        int[][] values = path.weights;
        int value = values[tile.x][tile.y];
        Tile current = null;
        int tl = 0;
        for (Point2 point : Geometry.d8) {
            int dx = tile.x + point.x;
            int dy = tile.y + point.y;
            Tile other = Vars.world.tile(dx, dy);
            if (other == null || values[dx][dy] >= value || current != null && values[dx][dy] >= tl || !path.passable(dx, dy) || point.x != 0 && point.y != 0 && (!path.passable(tile.x + point.x, tile.y) || !path.passable(tile.x, tile.y + point.y))) continue;
            current = other;
            tl = values[dx][dy];
        }
        if (current == null || tl == -1 || path.cost == ((PathCost[])Pathfinder.costTypes.items)[0] && current.dangerous() && !tile.dangerous()) {
            return tile;
        }
        return current;
    }

    private void updateTargets(Flowfield path, int x, int y) {
        if (!Structs.inBounds(x, y, path.weights)) {
            return;
        }
        if (path.weights[x][y] == 0) {
            path.frontier.clear();
        } else if (!path.frontier.isEmpty()) {
            return;
        }
        path.weights[x][y] = path.cost.getCost(path.team, this.tiles[x][y]);
        path.frontier.clear();
        this.updateTargets(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTargets(Flowfield path) {
        ++path.search;
        IntSeq intSeq = path.targets;
        synchronized (intSeq) {
            for (int i = 0; i < path.targets.size; ++i) {
                int pos = path.targets.get(i);
                short tx = Point2.x(pos);
                short ty = Point2.y(pos);
                path.weights[tx][ty] = 0;
                path.searches[tx][ty] = path.search;
                path.frontier.addFirst(pos);
            }
        }
    }

    private void preloadPath(Flowfield path) {
        path.targets.clear();
        path.getPositions(path.targets);
        this.registerPath(path);
        this.updateFrontier(path, -1L);
    }

    private void registerPath(Flowfield path) {
        path.lastUpdateTime = Time.millis();
        path.setup(this.tiles.length, this.tiles[0].length);
        this.threadList.add(path);
        Core.app.post(() -> this.mainList.add(path));
        for (int x = 0; x < Vars.world.width(); ++x) {
            for (int y = 0; y < Vars.world.height(); ++y) {
                path.weights[x][y] = -1;
            }
        }
        for (int i = 0; i < path.targets.size; ++i) {
            int pos = path.targets.get(i);
            path.weights[Point2.x((int)pos)][Point2.y((int)pos)] = 0;
            path.frontier.addFirst(pos);
        }
    }

    private void updateFrontier(Flowfield path, long nsToRun) {
        long start = Time.nanos();
        while (path.frontier.size > 0 && (nsToRun < 0L || Time.timeSinceNanos(start) <= nsToRun)) {
            Tile tile = Vars.world.tile(path.frontier.removeLast());
            if (tile == null || path.weights == null) {
                return;
            }
            int cost = path.weights[tile.x][tile.y];
            if (path.frontier.size >= Vars.world.width() * Vars.world.height()) {
                path.frontier.clear();
                return;
            }
            if (cost == -1) continue;
            for (Point2 point : Geometry.d4) {
                int otherCost;
                int dx = tile.x + point.x;
                int dy = tile.y + point.y;
                if (dx < 0 || dy < 0 || dx >= this.tiles.length || dy >= this.tiles[0].length || path.weights[dx][dy] <= cost + (otherCost = path.cost.getCost(path.team, this.tiles[dx][dy])) && path.searches[dx][dy] >= path.search || otherCost == -1) continue;
                path.frontier.addFirst(Point2.pack(dx, dy));
                path.weights[dx][dy] = cost + otherCost;
                path.searches[dx][dy] = (short)path.search;
            }
        }
    }

    public static abstract class Flowfield {
        protected int refreshRate;
        protected Team team = Team.derelict;
        protected PathCost cost = costTypes.get(0);
        public int[][] weights;
        public int[][] searches;
        IntQueue frontier = new IntQueue();
        final IntSeq targets = new IntSeq();
        int search = 1;
        long lastUpdateTime;
        boolean initialized;

        void setup(int width, int height) {
            this.weights = new int[width][height];
            this.searches = new int[width][height];
            this.frontier.ensureCapacity((width + height) * 3);
            this.initialized = true;
        }

        protected boolean passable(int x, int y) {
            return this.cost.getCost(this.team, Vars.pathfinder.tiles[x][y]) != -1;
        }

        protected abstract void getPositions(IntSeq var1);
    }

    static interface PathCost {
        public int getCost(Team var1, int var2);
    }

    class PathTileStruct {
        int health;
        int team;
        boolean solid;
        boolean liquid;
        boolean legSolid;
        boolean nearLiquid;
        boolean nearGround;
        boolean nearSolid;
        boolean deep;
        boolean damages;

        PathTileStruct() {
        }
    }

    public static class PositionTarget
    extends Flowfield {
        public final Position position;

        public PositionTarget(Position position) {
            this.position = position;
            this.refreshRate = 900;
        }

        @Override
        public void getPositions(IntSeq out) {
            out.add(Point2.pack(World.toTile(this.position.getX()), World.toTile(this.position.getY())));
        }
    }

    public static class RallyField
    extends Flowfield {
        @Override
        protected void getPositions(IntSeq out) {
            for (Tile other : Vars.indexer.getAllied(this.team, BlockFlag.rally)) {
                out.add(other.pos());
            }
        }
    }

    public static class EnemyCoreField
    extends Flowfield {
        @Override
        protected void getPositions(IntSeq out) {
            for (Tile other : Vars.indexer.getEnemy(this.team, BlockFlag.core)) {
                out.add(other.pos());
            }
            if (Vars.state.rules.waves && this.team == Vars.state.rules.defaultTeam) {
                for (Tile other : Vars.spawner.getSpawns()) {
                    out.add(other.pos());
                }
            }
        }
    }
}

